//---------------------------------------------------------------------------

#pragma hdrstop
#include "skinColor.h"

#include <cmath>
#include <iostream>
#include <fstream>
SkinColor::SkinColor( string fileName){
        ifstream stream( fileName.data());
        if( stream.bad()){
            throw "Unable to open skin model file";   
        }
        // nacteni modelu barvy kuze ze souboru
        stream >> meanR;
        stream >> meanG;
        stream >> cMatrix[0];
        stream >> cMatrix[1];
        stream >> cMatrix[2];
        stream >> cMatrix[3];
        stream.close();

        // vypocet inverzni kovariancni matice podle "Cihakova pravidla"
        // prohodit prvky na diagonle, mimo diagonlu obrtit znamnka a cel dlit determinantem
        cMatrixDeterminant = cMatrix[0] * cMatrix[3] - cMatrix[1] * cMatrix[2];

        double scale = 1 / ( cMatrixDeterminant );
        cMatrixInverse[0] = scale * cMatrix[3];
        cMatrixInverse[1] = scale * -cMatrix[1];
        cMatrixInverse[2] = scale * -cMatrix[2];
        cMatrixInverse[3] = scale * cMatrix[0];

        double maxProbability = 0;
        double minProbability = 10000000;

        double a = cMatrixInverse[0];
        double b = cMatrixInverse[1];
        double c = cMatrixInverse[2];
        double d = cMatrixInverse[3];
        
        for( int r = 0; r < 256; r++){
            for( int g = 0; g < 256; g++){
                double dr = r / 256.0 - meanR;
                double dg = g / 256.0 - meanG;

                double exponent = -1.0/2.0 * ( dr *( dr * a + dg * c) + dg *( dr * b + dg * d));

                fSkinProbability[ r][ g] = std::exp( exponent);

                if( fSkinProbability[ r][ g] > maxProbability){
                    maxProbability = fSkinProbability[ r][ g];
                }
                if( fSkinProbability[ r][ g] < minProbability){
                    minProbability = fSkinProbability[ r][ g];
                }
            }
        }
        for( int r = 0; r < 256; r++){
            for( int g = 0; g < 256; g++){
                skinProbability[ r][ g] =  int(fSkinProbability[ r][ g] / maxProbability * 255.0);
            }
        }
}

void SkinColor::getSkinProbability( ImageStruct * source, ImageStruct * dest){
    if( source->XSize == dest->XSize && source->YSize && source->XSize){
        for( int y = 0; y < source->YSize; y++){
            for( int x = 0; x < source->XSize; x++){
                register int sum = (ImageRGBPixelRGB( source, x, y)& 0xFF)
                                 + ((ImageRGBPixelRGB( source, x, y) & 0xFF00) >> 8)
                                 + ((ImageRGBPixelRGB( source, x, y) & 0xFF0000) >> 16);
                register int r;
                register int g;
                if( sum){
                    r = ( (ImageRGBPixelRGB( source, x, y) & 0xFF0000) >> 8) / sum;
                    g = ( (ImageRGBPixelRGB( source, x, y) & 0xFF00)) / sum;
                } else {
                    r = 0;
                    g = 0;   
                }
                Image8LinearPixel( dest, x, y) = skinProbability[ r][ g];
            }
        }
    }
}

void SkinColor::getSkinProbability( ImageStruct * source, ImageStruct * dest, int minX, int minY, int maxX, int maxY){
    if( minX >= 0 && minY >= 0 && maxX < source->XSize && maxY < source->YSize
        && maxX < dest->XSize && maxY < dest->YSize){
        for( int y = minY; y < maxY; y++){
            for( int x = minX; x < maxX; x++){
                register int sum = (ImageRGBPixelRGB( source, x, y)& 0xFF)
                                 + ((ImageRGBPixelRGB( source, x, y) & 0xFF00) >> 8)
                                 + ((ImageRGBPixelRGB( source, x, y) & 0xFF0000) >> 16);

                register int r;
                register int g;
                if( sum){
                    r = ( (ImageRGBPixelRGB( source, x, y) & 0xFF0000) >> 8) / sum;
                    g = ( (ImageRGBPixelRGB( source, x, y) & 0xFF00)) / sum;
                } else {
                    r = 0;
                    g = 0;   
                }

                Image8LinearPixel( dest, x, y) = skinProbability[ r][ g];
            }
        }
    }
}
//---------------------------------------------------------------------------

#pragma package(smart_init)

