//---------------------------------------------------------------------------


#pragma hdrstop

#include "headDetection.h"
#include "tools.h"

using namespace std;

// image.h
// Returns new reference to existing image.
// This is NOT a copy of image. Processing this image will
// affect the original one.
ImageStruct * getResizedImage(ImageStruct * img, int scale)
{
  ImageStruct * resized = NewImageReference(img, 0, 0, ImageXSize(img), ImageYSize(img));
  resized->XOffset *= scale;
  resized->YOffset *= scale;
  resized->XSize /= scale;
  resized->YSize /= scale;
  return resized;
}

// Vykresli krizek do 8bit obrazu
void THeadDetector::drawCross(ImageStruct * img, iVector2D p, Image8Value v)
{
  if (p.x() < 0 || p.y() < 0 || p.x() > ImageXSize(img) || p.y() > ImageXSize(img))
    return;
  for(int m = -20; m < 20; m++)
    if (p.x()+m > 0 && p.x()+m < img->XSize)
      SetImage8LinearPixel(img, p.x()+m, p.y(), v);
  for(int m = -20; m < 20; m++)
    if (p.y()+m > 0 && p.y()+m < img->YSize)
      SetImage8LinearPixel(img, p.x(), p.y()+m, v);
}

void THeadDetector::drawCrossRGB(ImageStruct * img, iVector2D p, ImageRGBValueRGB v)
{
  if (p.x() < 0 || p.y() < 0 || p.x() > ImageXSize(img) || p.y() > ImageXSize(img))
    return;
  for(int m = -20; m < 20; m++)
    if (p.x()+m > 0 && p.x()+m < img->XSize)
      ImageRGBLinearPixelRGB(img, p.x()+m, p.y()) = v;
  for(int m = -20; m < 20; m++)
    if (p.y()+m > 0 && p.y()+m < img->YSize)
      ImageRGBLinearPixelRGB(img, p.x(), p.y()+m) = v;
}

using namespace std;

bool THeadDetector::isHead(Component & c)
{
  int w = c.MaxX-c.MinX;
  int h = c.MaxY-c.MinY;
  int x = (w > h) ? w : h;
  x *= x;
  float m = c.pixels.size() / (float)(x);
  if (m > minCompactness)
    return true;
  else
    return false;
}

// Obarvi komponentu na pozici [x,y] hodnotou v.
void THeadDetector::fillComponent(ImageStruct * img, int x, int y, int v, Component & c, int depth)
{
  if (!depth) return;
  SetImage8LinearPixel(img, x, y, v);
  // handle component information
  c.pixels.push_back(iVector2D(x, y));
  // min/max
  if (x < c.MinX) c.MinX = x;
  if (x > c.MaxX) c.MaxX = x;
  if (y < c.MinY) c.MinY = y;
  if (y > c.MaxY) c.MaxY = y;

  static unsigned long tmp = 0;

  int d[4] = {-1, -1, -1, -1};

  int g = tmp % 4;
  for (int i = 1; i < 4; i++)
    d[i] = (g + i) % 4;

  tmp += 13;

  for (int i = 0; i < 4; i++)
  {
    switch (i) {
    case 0:
      // Recursively handle surrnouding pixels
      if (x < img->XSize-1)
      {
        if (Image8LinearPixel(img, x+1, y) == 255)
          fillComponent(img, x+1, y, v, c, depth-1);
      }
    case 1:
      if (x > 1)
      {
        if (Image8LinearPixel(img, x-1, y) == 255)
          fillComponent(img, x-1, y, v, c, depth-1);
      }
    case 2:
      if (y < img->YSize-1)
      {
        if (Image8LinearPixel(img, x, y+1) == 255)
          fillComponent(img, x, y+1, v, c, depth-1);
      }
    case 3:
      if (y > 1)
      {
        if (Image8LinearPixel(img, x, y-1) == 255)
          fillComponent(img, x, y-1, v, c, depth-1);
      }
      break;
    } // switch
  } // for

} // fillComponent()

// Nalezne komponenty obrazu
// img 2-hodnotovy obraz
vector<iVector2D> THeadDetector::getComponentPositions(ImageStruct * img)
{
  vector<Component> components;
  components.clear();

  int value = 160; // hodnota, kterou se obarvi komponenta (cokoliv krome 255)

  for(int y = 4; y < img->YSize-4; y+=8)
    for(int x = 4; x < img->XSize-4; x+=4)
    {
      assert(x >= 0 && x < img->XSize && y >= 0 && y < img->YSize);
      if (Image8LinearPixel(img, x, y) == 255)
      {
        Component tmp(value);
        fillComponent(img, x, y, value, tmp, 1000);

        if (tmp.pixels.size() > minComponentSize && (tmp.elipseAspect() > minAspectRatio && tmp.elipseAspect() < maxAspectRatio))
        {
          iVector2D ctr = tmp.center();
          components.push_back(tmp);
        } // if

      } // if
    } // for

  vector<iVector2D> result;
  result.clear();
  for (unsigned i = 0; i < components.size(); i++)
    if (isHead(components[i]))
      result.push_back(components[i].center());

  return result;
}

//---------------------------------------------------------------------------

vector<iVector2D> THeadDetector::process(ImageStruct * img)
{
  // Get Background and Skin masks
  bg->solveBackground(img);

  ImageStruct * img_scaled = getResizedImage(img, scale);
  skin->getSkinProbability(img_scaled, skinimg);
  DeleteImage(img_scaled);

  // Make intersection
  for (int y = 0; y < ImageYSize(skinimg); y++)
    for (int x = 0; x < ImageXSize(skinimg); x++)
    {
       assert((x * scale) <  width && (y * scale) < height);
       if ((bg->isBackground(x*scale, y*scale) != 0) &&
           (Image8LinearPixel(skinimg, x, y) > skinProbabilityTreshold))
       {
         SetImage8LinearPixel(skinimg, x, y, 255);
       }
       else
       {
         SetImage8LinearPixel(skinimg, x, y, 0);
       }
    }

  MedianImage8(skinimg);

  // Get relevant components in image
  vector<iVector2D> components;
  components = getComponentPositions(skinimg);

  // Erase possible multiple detections
  for (vector<iVector2D>::iterator i = components.begin(); i != components.end(); i++)
  {
    for (vector<iVector2D>::iterator j = i+1; j != components.end(); j++)
    {
      if (abs(j->x() - i->x()) < 20 && j->y() > i->y())
        components.erase(j);
      if (j == components.end())
        break;
    }
  }

  return components;
}

vector<iVector2D> THeadDetector::process1(ImageStruct * img)
{
  assert(width == ImageXSize(img) && height == ImageYSize(img));

  if (!useImageAlphaAsSkin)
  {
    ImageStruct * img_scaled = getResizedImage(img, scale);
    skin->getSkinProbability(img_scaled, skinimg);
    DeleteImage(img_scaled);

    for (int y = 0; y < skinimg->YSize; y++)
      for (int x = 0; x < skinimg->XSize; x++)
      {
        if (Image8LinearPixel(skinimg, x, y) > skinProbabilityTreshold)
        {
          SetImage8LinearPixel(skinimg, x, y, 255);
        }
        else
        {
          SetImage8LinearPixel(skinimg, x, y, 0);
        }
      } // for x
  } // if
  else
  {
    for (int y = 0; y < skinimg->YSize; y++)
      for (int x = 0; x < skinimg->XSize; x++)
      {
        if (ImageRGBLinearPixelA(img, 4*x, 4*y) > skinProbabilityTreshold)
        {
          SetImage8LinearPixel(skinimg, x, y, 255);
        }
        else
        {
          SetImage8LinearPixel(skinimg, x, y, 0);
        }
      } // for x
  } // if

  MedianImage8(skinimg);

  // Get relevant components in image
  vector<iVector2D> components;
  components = getComponentPositions(skinimg);

  for (vector<iVector2D>::iterator i = components.begin(); i != components.end(); i++)
  {
    for (vector<iVector2D>::iterator j = i+1; j != components.end(); j++)
    {
      if (abs(j->x() - i->x()) < 20 && j->y() > i->y())
        components.erase(j);
      if (j == components.end())
        break;
    }
  }
/*
  for (vector<iVector2D>::iterator i = components.begin(); i != components.end(); i++){ //draws cross over detected objects
      drawCross( skinimg, *i);
  }

  for( int y = 0; y < skinimg->YSize; y++){ //draws the mask
    for( int x = 0; x < skinimg->XSize; x++){
      ImageRGBPixelR( img, x, y) = Image8Pixel( skinimg, x, y);
      ImageRGBPixelG( img, x, y) = Image8Pixel( skinimg, x, y);
      ImageRGBPixelB( img, x, y) = Image8Pixel( skinimg, x, y);
    }
  }*/
/*  for( int y = 0; y < img->YSize; y++){
    for( int x = 0; x < img->XSize; x++){
      ImageRGBPixelR( img, x, y) = ImageRGBPixelA( img, x, y);
      ImageRGBPixelG( img, x, y) = ImageRGBPixelA( img, x, y);
      ImageRGBPixelB( img, x, y) = ImageRGBPixelA( img, x, y);
    }
  }*/
  return components;
} // process1()

vector<iVector2D> THeadDetector::process2(ImageStruct * img)
{
  ImageStruct * img_scaled = getResizedImage(img, scale);

  skin->getSkinProbability(img_scaled, skinimg);

  // Create new image and copy grayscale source weighted by the skinimg
  ImageStruct * img_weight = NewImage8(img->XSize/scale, img->YSize/scale);
  for (int y = 0; y < img->YSize/scale; y++)
    for (int x = 0; x < img->XSize/scale; x++)
    {
      Image8LinearPixel(img_weight, x, y) = (unsigned char)
      (
        RGBToGrayA(ImageRGBLinearPixelRGB(img_scaled, x, y)) *
        ((double)(Image8LinearPixel(skinimg, x, y)) / 256.0)
      );
    } // for x

    MedianImage8(skinimg);

// skinimg - maska kuze
// img_scaled - img/4
// img_weight - img/4 vazeny barvou kuze

  // get ellipses
  memset(ellipse->Array, 0, ellipse->XSize*ellipse->YSize*sizeof(int));
  ellipse->ProcessImageSkin(img_weight, skinimg, 0, 0, width/scale, height/scale);

  DeleteImage(img_scaled);
  DeleteImage(img_weight);

/*
  // Weight using skinimg. Might improve results
  int i = 0;
  for (int y = 0; y < img->YSize/scale; y++)
    for (int x = 0; x < img->XSize/scale; x++, i++)
    {
      ellipse->Array[i] = (int) (ellipse->Array[i] * (double)(Image8LinearPixel(skinimg, x, y)) / 256.0);
    }
*/

  vector<iVector2D> heads;

  int x, y;
  while (ellipse->FindMax(x, y) > ellipseThreshold) // threshold in houhg space to detect ellipses
  {
    heads.push_back(iVector2D(x, y));
  }

  return heads;
}

#pragma package(smart_init)
