/*****************************************************************************/
/*                       Image processing functions                          */
/*  Source file : hough transform for ellipse detection                      */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#ifndef ELIPSE_H
#define ELIPSE_H

#include "Image.h"
#include <mem.h>
#include <vector>

class pdCircleDetect
{
   public:
   int *Array;
   int MinR, MaxR;              // minimal and maximal radius
   float incR;
   float Ratio;                 // ellipsoid ratio
   int XSize, YSize;            // Size of the hough space and also image size
   float XRatio, YRatio;        // size ratio of height and width image and hough space
   pdCircleDetect()  { Array = NULL; }
   ~pdCircleDetect()
   {
      if (Array!=NULL)
        delete [] Array;
   }
   void Init(int xsize, int ysize, int Width, int Height, int MinRadius, int MaxRadius, float ratio);
   // xsize, ysize - size of the input image
   // Width, Height - size of the hough array
   void AddPoint(int x, int y, int ax, int ay, int weight);
   // ax, ay - size of the edge response for vertical and horizontal direction
   int FindMax(int &x, int &y);

   #define DIGILIB
   #ifdef DIGILIB
   void ProcessImage(ImageStruct *Image);
   // process the input image -> put all edges into the hough space
   void ProcessImageSkin(ImageStruct *Image, ImageStruct * skin, int, int, int, int);
   // process the input image -> put all edges into the hough space
   long DrawArray(ImageStruct *Image);
   // draw hough space into an image
   void DrawEllipse(ImageStruct *Image, int x0, int y0, float ratio);
   // draw ellipse with parameters x0, y0 and from Init function
   #endif
};

#endif
