//---------------------------------------------------------------------------

#ifndef Vector2DH
#define Vector2DH

template <typename _T>
class Vector2D{
    _T pos[2];
public:
    _T &x(){
        return pos[0];
    }
    _T &y(){
        return pos[1];
    }
    Vector2D<_T> operator-(const Vector2D<_T> & vector){
        return Vector2D<_T>(pos[0] - vector.pos[0], pos[1] - vector.pos[1]);
    }
    Vector2D<_T> operator+(const Vector2D<_T> & vector){
        return Vector2D<_T>(pos[0] + vector.pos[0], pos[1] + vector.pos[1]);
    }
    Vector2D<_T> operator*(const float scale){
        return Vector2D<_T>(pos[0] * scale, pos[1] * scale);
    }
    Vector2D<_T> operator/(const _T scale){
        return Vector2D<_T>(pos[0] / scale, pos[1] / scale);
    }
    Vector2D<_T>(_T x, _T y){
        pos[0] = x;
        pos[1] = y;
    }
    Vector2D<_T>(){pos[0] = 0; pos[1] = 0;}
};

typedef Vector2D<int> iVector2D;
typedef Vector2D<float> fVector2D;

//---------------------------------------------------------------------------
#endif
