//---------------------------------------------------------------------------

#ifndef ToolsH
#define ToolsH

#include "Image.h"


void FilterAvrgImage8( ImageStruct * src, ImageStruct * dest, int maskWidth);

/**
    src - je vstupni Image8
    dest - je vystupni Image8 po konvoluci
    mask - celociselna matice masky
    maskWidth a maskHeight - mus bt lich - rozmery maky
    scale - cislo, kterym se deli hodnota pixelu po konvoluci*/
void FilterConvImage8( ImageStruct * src, ImageStruct * dest, int * mask, int maskWidth, int maskHeight, int scale);

void RGBToIntensity( ImageStruct * src, ImageStruct * dest);

Image8Value RGBToGrayA(ImageRGBValueRGB v);

void RGBtoHImage8( ImageStruct * src, ImageStruct * dest);

void RGBtoNormR(ImageStruct * src, ImageStruct * dest);
void RGBtoNormG(ImageStruct * src, ImageStruct * dest);
void RGBtoNormB(ImageStruct * src, ImageStruct * dest);
void NormRGB( ImageStruct * src);

void AddImage8Image32( ImageStruct * src, ImageStruct * dest);
void SubstrImage8Image32( ImageStruct * src, ImageStruct * dest);

/** dest = dest - src*/
void SubstrImage32Image32( ImageStruct * src, ImageStruct * dest);
void SubstrImage32Image32Image32( ImageStruct * src, ImageStruct * src2, ImageStruct * dest);

void MullImage32( ImageStruct * src, float scale); 
void AddImage32( ImageStruct * src, int number); 
void Image32to8( ImageStruct * src, ImageStruct * dest, int scale);
void Image8to32( ImageStruct * src, ImageStruct * dest);

void ImageCopy8(ImageStruct * src, ImageStruct * dest);

void SobelImage32( ImageStruct * src, ImageStruct * dest);

void MedianImage8(ImageStruct * img);
//---------------------------------------------------------------------------
#endif
