#ifndef __MountDllTracker_h__
#define __MountDllTracker_h__

#include <windows.h>
#include <iostream>
#include <assert>

struct TResult{
    TResult( int _posX, int _posY, int _sizeX, int _sizeY, float _velocityX, float _velocityY ):
       posX( _posX), posY( _posY), sizeX( _sizeX), sizeY( _sizeY), velocityX( _velocityX), velocityY( _velocityY) {};

    TResult( ):
       posX( 0), posY( 0), sizeX( 0), sizeY( 0), velocityX( 0), velocityY( 0){};

    int posX, posY, sizeX, sizeY;
    float velocityX, velocityY;
};


//aby to jelo vcekrt -

extern int __stdcall (*initTracker)( int _sizeX, int _sizeY, const char * skinColorModelFile); //pridelat cofig file
extern void __stdcall (*addTracker)( int t, ImageStruct * image, int X, int Y);
extern int __stdcall (*nextImage)( int t, ImageStruct *image, float imageNo, int bufferSize, TResult buffer[]);
extern void __stdcall (*setInterlaced)( int t, bool interlaced);
extern void __stdcall (*finalizeTracker)( int t);

extern void __stdcall (*clearAllTrackers)( int t);
extern void __stdcall (*suspendAllTrackers)( int t);
extern void __stdcall (*setTrackerSize)( int t, int _trackerSizeX, int _trackerSizeY);
extern void __stdcall (*setParticleCount)( int t,  int _particleCount);
extern int  __stdcall (*loadConfiguration)( int t, char *configurationFile);

extern void __stdcall (*setHeadSizeRatio)( int tracker, float rx, float ry);
extern float __stdcall (*getHeadSizeRatioX)( int tracker);
extern float __stdcall (*getHeadSizeRatioY)( int tracker);
extern void __stdcall (*setMinimumComponentSizeRatio)( int tracker, float ratio);
extern float __stdcall (*getMinimumComponentSizeRatio)( int tracker);
extern void __stdcall (*setHeadDetectionScale)( int tracker, int scale);
extern int __stdcall (*getHeadDetectionScale)( int tracker );


void LoadTrackerProceduresFromDLL();
void freeTrackerDll();

#endif
