#include <windows.h>
#include <iostream>
#include <assert>
#include <Image.h>
#include "MountDllTracker.h"

int __stdcall (*initTracker)( int _sizeX, int _sizeY, const char * skinColorModelFile) = NULL; //pridelat cofig file
void __stdcall (*addTracker)( int t, ImageStruct * image, int X, int Y) = NULL;
int __stdcall (*nextImage)( int t, ImageStruct *image, float imageNo, int bufferSize, TResult buffer[]) = NULL;
void __stdcall (*setInterlaced)( int t, bool interlaced) = NULL;
void __stdcall (*finalizeTracker)( int t) = NULL;

void __stdcall (*clearAllTrackers)( int t) = NULL;
void __stdcall (*suspendAllTrackers)( int t) = NULL;
void __stdcall (*setTrackerSize)( int t, int _trackerSizeX, int _trackerSizeY) = NULL;
void __stdcall (*setParticleCount)( int t,  int _particleCount) = NULL;
int  __stdcall (*loadConfiguration)( int t,  char *configurationFile);

void __stdcall (*setHeadSizeRatio)( int tracker, float rx, float ry);
float __stdcall (*getHeadSizeRatioX)( int tracker);
float __stdcall (*getHeadSizeRatioY)( int tracker);
void __stdcall (*setMinimumComponentSizeRatio)( int tracker, float ratio);
float __stdcall (*getMinimumComponentSizeRatio)( int tracker);
void __stdcall (*setHeadDetectionScale)( int tracker, int scale);
int __stdcall (*getHeadDetectionScale)( int tracker );



static void __stdcall (*myInitCriticalSection)();
static void __stdcall (*myDeleteCriticalSection)();

using namespace std;
HMODULE LoadedDllTracker = 0;

void LoadTrackerProceduresFromDLL(){
    if( LoadedDllTracker)
        return;
    LoadedDllTracker = LoadLibrary( "DllTracker");
    if( !LoadedDllTracker){
        cerr << endl << "ERROR: Unable to load DllTracker.dll" << endl;
        assert( LoadedDllTracker);
        exit(0);
    }
    
    myInitCriticalSection = (void __stdcall (*)()) GetProcAddress( LoadedDllTracker, "_Z21myInitCriticalSectionv");
    myDeleteCriticalSection = (void __stdcall (*)()) GetProcAddress( LoadedDllTracker, "_Z23myDeleteCriticalSectionv");
    if( !myInitCriticalSection){
        cerr << endl << "ERROR: Unable to load procedure myInitCriticalSection from DllTracker.dll" << endl;
        assert( myInitCriticalSection);
    }
    if( !myDeleteCriticalSection){
        cerr << endl << "ERROR: Unable to load procedure myDeleteCriticalSection from DllTracker.dll" << endl;
        assert( myDeleteCriticalSection);
    }
    
    myInitCriticalSection();
    
    initTracker = (int __stdcall (*)( int , int , const char * )) GetProcAddress( LoadedDllTracker, "_Z11initTrackeriiPKc");
    addTracker = (void __stdcall (*)( int, ImageStruct * , int, int)) GetProcAddress( LoadedDllTracker, "_Z10addTrackeriP11ImageStructii");
    nextImage = (int __stdcall (*)( int, ImageStruct *, float, int , TResult *)) GetProcAddress( LoadedDllTracker, "_Z9nextImageiP11ImageStructfiP7TResult");
    setInterlaced = (void __stdcall (*)( int, bool)) GetProcAddress( LoadedDllTracker, "_Z13setInterlacedib");
    finalizeTracker = (void __stdcall (*)( int)) GetProcAddress( LoadedDllTracker, "_Z15finalizeTrackeri");
    clearAllTrackers = (void __stdcall (*)( int)) GetProcAddress( LoadedDllTracker, "_Z16clearAllTrackersi");
    suspendAllTrackers = (void __stdcall (*)( int)) GetProcAddress( LoadedDllTracker, "_Z18suspendAllTrackersi");
    setTrackerSize = (void __stdcall (*)( int, int , int )) GetProcAddress( LoadedDllTracker, "_Z14setTrackerSizeiii");
//    setParticleCount = (void __stdcall ()( int, int)) GetProcAddress( LoadedDllTracker, "_Z16setParticleCountii");
    loadConfiguration = (int  __stdcall (*)( int, char *)) GetProcAddress( LoadedDllTracker, "_Z17loadConfigurationiPc");;
    
//    setHeadSizeRatio = (void __stdcall (*)( int tracker, float rx, float ry) GetProcAddress( LoadedDllTracker, "_Z16setHeadSizeRatioiff");
//    getHeadSizeRatioX = (float __stdcall (*)( int tracker) GetProcAddress( LoadedDllTracker, "_Z17getHeadSizeRatioXi");
//    getHeadSizeRatioY = (float __stdcall (*)( int tracker) GetProcAddress( LoadedDllTracker, "_Z17getHeadSizeRatioYi");
//    setMinimumComponentSizeRatio = (void __stdcall (*)( int tracker, float ratio) GetProcAddress( LoadedDllTracker, "_Z28setMinimumComponentSizeRatioif");
    getMinimumComponentSizeRatio = (float __stdcall (*)( int tracker)) GetProcAddress( LoadedDllTracker, "_Z28getMinimumComponentSizeRatioi");
    setHeadDetectionScale = (void __stdcall (*)( int tracker, int scale)) GetProcAddress( LoadedDllTracker, "_Z21setHeadDetectionScaleii");
    getHeadDetectionScale = (int __stdcall (*)( int tracker )) GetProcAddress( LoadedDllTracker, "_Z21getHeadDetectionScalei");

    
    
    if( !initTracker){
        cerr << endl << "ERROR: Unable to load procedure initTracker from DllTracker.dll" << endl;
        assert( initTracker);
        exit(0);
    }
    if( !addTracker ){
        cerr << endl << "ERROR: Unable to load procedure addTracker from DllTracker.dll" << endl;
        assert( addTracker);
        exit(0);
    }
    if( !nextImage){
        cerr << endl << "ERROR: Unable to load procedure nextImage from DllTracker.dll" << endl;
        assert( nextImage);
        exit(0);
    }
    if( !setInterlaced ){
        cerr << endl << "ERROR: Unable to load procedure setInterlaced from DllTracker.dll" << endl;
        assert( setInterlaced);
        exit(0);
    }
    if( !finalizeTracker){
        cerr << endl << "ERROR: Unable to load procedure finalizeTracker from DllTracker.dll" << endl;
        assert( finalizeTracker);
        exit(0);
    }
    if( !clearAllTrackers ){
        cerr << endl << "ERROR: Unable to load procedure clearAllTrackers from DllTracker.dll" << endl;
        assert( clearAllTrackers);
        exit(0);
    }
    if( !suspendAllTrackers ){
        cerr << endl << "ERROR: Unable to load procedure suspendAllTrackers from DllTracker.dll" << endl;
        assert( suspendAllTrackers);
        exit(0);
    }
    if( !setTrackerSize){
        cerr << endl << "ERROR: Unable to load procedure setTrackerSize from DllTracker.dll" << endl;
        assert( setTrackerSize);
        exit(0);
    }
    if( !loadConfiguration){
        cerr << endl << "ERROR: Unable to load procedure loadConfiguration from DllTracker.dll" << endl;
        assert( loadConfiguration);
        exit(0);
    }
/*
    if( !setParticleCount){
        cerr << endl << "ERROR: Unable to load procedure setParticleCount from DllTracker.dll" << endl;
        assert( setParticleCoun);
        exit(0);
    }

    if( !setHeadSizeRatio){
        cerr << endl << "ERROR: Unable to load procedure setHeadSizeRatio from DllTracker.dll" << endl;
        assert( setHeadSizeRatio);
        exit(0);
    }

    if( !getHeadSizeRatioX){
        cerr << endl << "ERROR: Unable to load procedure getHeadSizeRatioX from DllTracker.dll" << endl;
        assert( getHeadSizeRatioX);
        exit(0);
    }

    if( !getHeadSizeRatioY){
        cerr << endl << "ERROR: Unable to load procedure getHeadSizeRatioY from DllTracker.dll" << endl;
        assert( getHeadSizeRatioY);
        exit(0);
    }

    if( !setMinimumComponentSizeRatio){
        cerr << endl << "ERROR: Unable to load procedure setMinimumComponentSizeRatio from DllTracker.dll" << endl;
        assert( setMinimumComponentSizeRatio);
        exit(0);
    }

    if( !getMinimumComponentSizeRatio){
        cerr << endl << "ERROR: Unable to load procedure getMinimumComponentSizeRatio from DllTracker.dll" << endl;
        assert( getMinimumComponentSizeRatio);
        exit(0);
    }

    if( !setHeadDetectionScale){
        cerr << endl << "ERROR: Unable to load procedure setHeadDetectionScale from DllTracker.dll" << endl;
        assert( setHeadDetectionScale);
        exit(0);
    }

    if( !getHeadDetectionScale ){
        cerr << endl << "ERROR: Unable to load procedure getHeadDetectionScale from DllTracker.dll" << endl;
        assert( getHeadDetectionScale);
        exit(0);
    }
    */
}

void freeTrackerDll(){
    myDeleteCriticalSection();
    FreeLibrary( LoadedDllTracker);
    LoadedDllTracker = 0;
}

