//---------------------------------------------------------------------------


#pragma hdrstop

#include "KLTTracking.h"


#include <string.h>
#include <math.h>
#include <assert.h>
#include <stdlib.h>
#include <math.h>
//---------------------------------------------------------------------------

#pragma package(smart_init)

using namespace std;
int KLTTracker::selectFeatures( ImageStruct * image, const int _posX, const int _posY, const int _sizeX, const int _sizeY){
    prepare();
    if( trackingContext->sequentialMode) {  //pokud uz se predtim trackovalo, prerusim to
        KLTStopSequentialMode( trackingContext);
    }

    posX = _posX;// musi to byt pred if( interlaced)
    posY = _posY;
    sizeX = _sizeX;
    sizeY = _sizeY;

    if( interlaced){   // pokud je video prokladane, zpracovava se pouze kazdy druhy radek
        image->YOffset *= 2;    // proto smrsuji vse podle osy y faktorem 2
        image->YSize /=2;
        prepareForInterlaced();
    }

    initialSize = iVector2D( sizeX, sizeY);

    // rozsireni okna trackeru o okraje, ve kterych se nehleda + kontrola rozsahu okna
    posX -= trackingContext->borderx + movementReserve + inactiveBorder;
    sizeX += 2 * trackingContext->borderx + 2*movementReserve + 2*inactiveBorder;
    posY -= trackingContext->bordery + movementReserve + inactiveBorder;
    sizeY += 2 * trackingContext->bordery + 2*movementReserve + 2*inactiveBorder;

    if( imageToTrack){
        delete[] imageToTrack; imageToTrack = 0;
    }
    imageToTrack = new KLT_PixelType[ sizeX * sizeY];

   /* int minX = 0;
    int minY = 0;
    int maxX = sizeX;
    int maxY = sizeY;
    if( posX + minX < 0)
        minX = - posX;
    if( posY + minY < 0)
        minY = - posY;
    if( posX + maxX > image->XSize)
        maxX = image->XSize - posX;
    if( posY + maxY > image->YSize)
        maxY = image->YSize - posY;
    int adjustedSizeX = maxX - minX;

    for( int y = minY; y < maxY; y++){  // kopie trackovaciho okna do imageToTrack
        memcpy( &imageToTrack[ y * sizeX + minX], &Image8LinearPixel( image, posX + minX, posY + y), adjustedSizeX * sizeof( char));
    }     */

  // kopie trackovaciho okna do imageToTrack
    for( int y = 0; y < sizeY; y++){  // kopie trackovaciho okna
        for( int x = 0; x < sizeX; x++){
            if( posX + x < 0 || posY + y < 0
                || posX + x >= image->XSize
                || posY + y >= image->YSize){
                imageToTrack[ y * sizeX + x] = 0;
            } else {
                imageToTrack[ y * sizeX + x] =Image8LinearPixel( image, posX + x, posY + y);
            }
        }
    }

    int sx = sizeX / 2;                    //ROVNOMERNE ROZHAZENI FEATURU
    int sy = sizeY / 2;

    int minX = (int)(sx - initialSize.x() / 2);
    int minY = (int)(sy - initialSize.y() / 2);
    int maxX = (int)(sx + initialSize.x() / 2);
    int maxY = (int)(sy + initialSize.y() / 2);
    int step = int( sqrt((maxX - minX) * (maxY - minY) / featureList->nFeatures) + 1);

   int i = 0;
    for( int y = minY; y < maxY; y += step ){
        for( int x = minX; x < maxX; x += step){
            if( i >= featureList->nFeatures)
                break;
            featureList->feature[i]->val = 1;
            featureList->feature[i]->x = x;
            featureList->feature[i]->y = y;
            i++;
        }
    }

    actualMaxFeatureCount = actualFeatureCount();
    if( temporaryFeaturePositions){
        delete[] temporaryFeaturePositions;
        temporaryFeaturePositions = 0;
    }
    temporaryFeaturePositions = new fVector2D[ featureList->nFeatures];

    if( lastImage){
        delete[] lastImage;
        lastImage = 0;
    }
    lastImage = imageToTrack;
    imageToTrack = 0;

    if( interlaced){  // pokud je video prokladane, zpracovava se pouze kazdy druhy radek
        image->YSize *= 2;  // proto bylo vse smrstene podle osy y faktorem 2
        image->YOffset /= 2;  // a ted to musime zase natahnout
        restoreFromInterlaced();
    }

    correctedPosition = position = fVector2D( posX, posY);
    velocity = fVector2D( 0, 0);
    acceleration = fVector2D( 0, 0);
    lostFeatures = 0;

    return 1;
}

int KLTTracker::nextImage( ImageStruct * image, float timeInterval){
    prepare();
    if( actualFeatureCount() == 0){
        posX = 0;
        posY = 0;
        sizeX = 20;
        sizeY = 20;
        return -1;
    }
    
    velocity = velocity * timeInterval; // prizpusobeni skutecnemu casovemu intervalu
    acceleration = acceleration * timeInterval;
    
    //uschovani soucasnych pozic castic pro budouci vypocet pohybu
    for( int x = 0; x < featureList->nFeatures; x++){
        temporaryFeaturePositions[x] = fVector2D( featureList->feature[x]->x, featureList->feature[x]->y);
    }
    fVector2D savePos = position;
    
    position = correctedPosition; //+ velocity + acceleration;    //predpoved nove pozice

    posX = int(position.x());   // posX a posY jsou uz celociselne hodnoty
    posY = int(position.y());

    if( interlaced){     // pokud je video prokladane, zpracovava se pouze kazdy druhy radek
        image->YOffset *= 2; // proto smrstuji vse podle osy y faktorem 2
        image->YSize /=2;
        savePos.y() /= 2;
        prepareForInterlaced();
    }

    //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    if( !imageToTrack){
        imageToTrack = (KLT_PixelType*) new char[ sizeX * sizeY];  // sem se zkopiruje vyrez ze vzoroveho obrazu
    }

      // kopie trackovaciho okna do imageToTrack
    for( int y = 0; y < sizeY; y++){  // kopie trackovaciho okna
        for( int x = 0; x < sizeX; x++){
            if( posX + x < 0 || posY + y < 0
                || posX + x >= image->XSize
                || posY + y >= image->YSize){
                imageToTrack[ y * sizeX + x] = 0;
            } else {
                imageToTrack[ y * sizeX + x] = Image8LinearPixel( image, posX + x, posY + y);
            }
        }
    }


 /*   int minX = 0;   // kopie trackovaciho okna do imageToTrack
    int minY = 0;
    int maxX = sizeX;
    int maxY = sizeY;
    if( posX + minX < 0)
        minX = - posX;
    if( posY + minY < 0)
        minY = - posY;
    if( posX + maxX > image->XSize)
        maxX = image->XSize - posX;
    if( posY + maxY > image->YSize)
        maxY = image->YSize - posY;
    int adjustedSizeX = maxX - minX;

    for( int y = minY; y < maxY; y++){  // kopie trackovaciho okna do imageToTrack
        memcpy( &imageToTrack[ y * sizeX + minX], &Image8LinearPixel( image, posX + minX, posY + y), adjustedSizeX * sizeof( char));
    }   */     

    // Tracking of features between images
    int oldPosX = posX;
    int oldPosY = posY;
    trackingContext->sequentialMode = true;

    lostFeatures = actualFeatureCount();
    KLTTrackFeatures( trackingContext, lastImage, imageToTrack, sizeX, sizeY, featureList);


    for( int x = 0; x < featureList->nFeatures; x++){ //vypusteni castic lezicich mimo obrazek
        if( featureList->feature[x]->x + posX < 0 ||
            featureList->feature[x]->y + posY < 0 ||
            featureList->feature[x]->x + posX >= image->XSize - 1 ||
            featureList->feature[x]->y + posY >= image->YSize - 1
            ){
                featureList->feature[x]->val = -1;
            }
    }

    lostFeatures -= actualFeatureCount();  // vypocet ztracenych featuru

    if( actualFeatureCount() == 0){
        if( interlaced){  // pokud je video prokladane, zpracovava se pouze kazdy druhy radek
            image->YSize *= 2;  // proto bylo vse smrstene podle osy y faktorem 2
            image->YOffset /= 2; // a ted to musime zase natahnout
            savePos.y() *= 2;
            restoreFromInterlaced();
        }
        posX = 0;
        posY = 0;
        sizeX = 20;
        sizeY = 20;

        return -1;
    }
 
    // nalezeni nejmensi obdelnikove oblasti obsahujici vsechny features
    fVector2D center = getFeatureCenter();
    float mnX = (center.x() - initialSize.x() /2);// Velikost trackovaneho objektu
    float mnY = (center.y() - initialSize.y() /2);

    // rozsireni oblasti o okraje pro zachyceni pohybu
    // + rozsireni oblasti o okraje, ve kterych se nehleda
    //vznikaji kvuli nenulove velikosti feature + subsampling v pyramide
    float pX = mnX + position.x() - movementReserve - inactiveBorder - trackingContext->borderx;
    float pY = mnY + position.y() - movementReserve - inactiveBorder - trackingContext->bordery;

    correctedPosition = fVector2D( pX, pY);

    // Posunuti castic v pristim snimku, vzhledem k opravene pozici okna - snad to nekdo pochopi
    for( int i = 0 ; i < featureList->nFeatures; i++) {
        featureList->feature[i]->speadX = -(correctedPosition.x() - position.x());
        featureList->feature[i]->speadY = -(correctedPosition.y() - position.y());
    }

    if( interlaced){  // pokud je video prokladane, zpracovava se pouze kazdy druhy radek
        image->YSize *= 2;  // proto bylo vse smrstene podle osy y faktorem 2
        image->YOffset /= 2; // a ted to musime zase natahnout
        savePos.y() *= 2;
        restoreFromInterlaced();
    }
    
    fVector2D oldVelocity = velocity;
    velocity = fVector2D( 0, 0); //vypocet prumerne rychlosti castic a zrychleni
    int count = 0;
    for( int x = 0; x < featureList->nFeatures; x++){
        if( featureList->feature[x]->val >= 0){
            velocity = velocity
                + ( position + fVector2D( featureList->feature[x]->x, featureList->feature[x]->y))
                - ( savePos + temporaryFeaturePositions[x]);
            count++;
        }
    }
    sumVelocity = sqrt( velocity.x() * velocity.x() + (velocity.y() * velocity.y())) / float(count);
    velocity =  velocity / float(count);
    acceleration = velocity - oldVelocity;

    float odchylka = 0;
   for( int x = 0; x < featureList->nFeatures; x++){ //vypocet prumerne odchylky castic od prumerne rychlosti
        if( featureList->feature[x]->val >= 0){
            fVector2D tempVelocity;
            tempVelocity = velocity
                - (( position + fVector2D( featureList->feature[x]->x, featureList->feature[x]->y))
                - ( savePos + temporaryFeaturePositions[x]));
            odchylka +=  tempVelocity.x() * tempVelocity.x() + tempVelocity.y() * tempVelocity.y();
        }
    }
    odchylka /= count;

    for( int x = 0; x < featureList->nFeatures; x++){     // vypusteni nekterych castic vzhledem k jejich rychlosti
        if( featureList->feature[x]->val >= 0){
            fVector2D tempVelocity;
            tempVelocity = velocity
                - (( position + fVector2D( featureList->feature[x]->x, featureList->feature[x]->y))
                - ( savePos + temporaryFeaturePositions[x]));
           if( tempVelocity.x() * tempVelocity.x() + tempVelocity.y() * tempVelocity.y() > odchylka * 2 + 1){
                featureList->feature[x]->val = -1;
           }
        }
    }
    
    // pokud se zmensi pocet castic na urcite procento, obnova ztracenych castic
    if( actualFeatureCount() < actualMaxFeatureCount * 0.4){
       reselectLostFeatures();
    }
    for( int x = 0; x < featureList->nFeatures; x++){
        if( featureList->feature[x]->x + posX < 0 || //vypusteni castic lezicich mimo obrazek
            featureList->feature[x]->y + posY < 0 ||
            featureList->feature[x]->x + posX >= image->XSize - 1 ||
            featureList->feature[x]->y + posY >= image->YSize - 1
            ){
                featureList->feature[x]->val = -1;
            }
    }
    
    posX = (int)position.x();
    posY = (int)position.y();
    
    velocity = velocity / timeInterval; // prepocet na pixel za sekundu
    acceleration = acceleration / timeInterval;
    lastInterval =  timeInterval;
    return 1;
}


int KLTTracker::reselectLostFeatures( ){
    if( interlaced){
        prepareForInterlaced();
    }

    int sx = sizeX / 2;
    int sy = sizeY / 2;

    int minX = (int)(sx - initialSize.x() / 2);
    int minY = (int)(sy - initialSize.y() / 2);
    int maxX = (int)(sx + initialSize.x() / 2);
    int maxY = (int)(sy + initialSize.y() / 2);
    int step = int( sqrt((maxX - minX) * (maxY - minY) / featureList->nFeatures) + 1);

    int i = 0;
    for( int y = minY; y < maxY; y += step ){
        for( int x = minX; x < maxX; x += step){
            if( i >= featureList->nFeatures)
                break;
            featureList->feature[i]->val = 1;
            featureList->feature[i]->x = x;
            featureList->feature[i]->y = y;
            featureList->feature[i]->speadX = 0;
            featureList->feature[i]->speadY = 0;
            i++;
        }
    }

    actualMaxFeatureCount = actualFeatureCount();

    if( interlaced){
        restoreFromInterlaced();
    }
    return 1;
}


void KLTTracker::clearFeatures(){
    for( int i = 0 ; i < featureList->nFeatures ; i++)  {
        featureList->feature[i]->val = -1;
    }
}

int KLTTracker::actualFeatureCount(){
    int count = 0;
    for( int i = 0 ; i < featureList->nFeatures; i++) {
        if( featureList->feature[i]->val >= 0){
            count++;
        }
    }
    return count;
}

fVector2D KLTTracker::getFeatureCenter(){
    int count = 0;
    fVector2D avg( 0, 0);
    for( int i = 0 ; i < featureList->nFeatures; i++) {
        if( featureList->feature[i]->val >= 0){
            avg = avg + fVector2D( featureList->feature[i]->x ,featureList->feature[i]->y);
            count++;
        }
    }
    assert( count > 0);
    avg = avg / count;
    return avg;
}

void KLTTracker::getMinMax( int &minX, int &minY, int &maxX, int &maxY){
    minX = sizeX;
    maxX = 0;
    minY = sizeY;
    maxY = 0;

    for( int i = 0 ; i < featureList->nFeatures; i++) {
        if( featureList->feature[i]->val >= 0){
            if( featureList->feature[i]->x > maxX)
                maxX = (int)(featureList->feature[i]->x);

            if( featureList->feature[i]->x < minX)
                minX = (int)(featureList->feature[i]->x);

            if( featureList->feature[i]->y > maxY)
                maxY = (int)(featureList->feature[i]->y);

            if( featureList->feature[i]->y < minY)
                minY = (int)(featureList->feature[i]->y);
        }
    }
    if( maxX < minX){
        minX = 0;
        maxX = 0;
        minY = 0;
        maxY = 0;
    }
}

void KLTTracker::setInterlaced( ImageStruct * image, const bool _interlaced){
    interlaced = _interlaced;
    int minX, minY, maxX, maxY;
    getMinMax( minX, minY, maxX, maxY);
    clearFeatures();
    if( minX > maxX){
        minX = 0;
        maxX = 0;
        minY = 0;
        maxY = 0;
    }
    int x = (posX + minX + posX + maxX) / 2; //aby se to nezmensilo - stredova pozice +- initialSize
    int y = (posY + minY + posY + minY) / 2; 
    selectFeatures( image, (int)(x - initialSize.x() / 2), (int)(y - initialSize.y() / 2), initialSize.x(), (int)initialSize.y());
}

void KLTTracker::prepareForInterlaced(){
    posY /= 2;
    sizeY /= 2;
    position.y() /= 2;
    correctedPosition.y() /= 2;
    velocity.y() /= 2;
    acceleration.y() /= 2;
    initialSize.y() /= 2;
    for( int i = 0 ; i < featureList->nFeatures; i++) {
        featureList->feature[i]->y /= 2;
        featureList->feature[i]->speadY /= 2;
    }
}

void KLTTracker::restoreFromInterlaced(){
    posY *= 2;
    sizeY *= 2;
    position.y() *= 2;
    correctedPosition.y() *= 2;
    velocity.y() *= 2;
    acceleration.y() *= 2;
    initialSize.y() *= 2;
    for( int i = 0 ; i < featureList->nFeatures; i++) {
        featureList->feature[i]->y *= 2;
        featureList->feature[i]->speadY *= 2;
    }
}

void KLTTracker::prepare(void){     //kopie konfigurace trackeru z konfiguracniho tracking contextu
    trackingContext->mindist = controlTrackingContext->mindist;
    trackingContext->window_width = controlTrackingContext->window_width;
    trackingContext->window_height = controlTrackingContext->window_height;
    trackingContext->smoothBeforeSelecting = controlTrackingContext->smoothBeforeSelecting;
    trackingContext->writeInternalImages = controlTrackingContext->writeInternalImages;
    trackingContext->lighting_insensitive = controlTrackingContext->lighting_insensitive;
    trackingContext->min_eigenvalue = controlTrackingContext->min_eigenvalue;
    trackingContext->min_determinant = controlTrackingContext->min_determinant;
    trackingContext->min_displacement = controlTrackingContext->min_displacement;
    trackingContext->max_iterations = controlTrackingContext->max_iterations;
    trackingContext->max_residue = controlTrackingContext->max_residue;
    trackingContext->grad_sigma = controlTrackingContext->grad_sigma;
    trackingContext->smooth_sigma_fact = controlTrackingContext->smooth_sigma_fact;
    trackingContext->pyramid_sigma_fact = controlTrackingContext->pyramid_sigma_fact;
    trackingContext->nSkippedPixels = controlTrackingContext->nSkippedPixels;
    trackingContext->borderx = controlTrackingContext->borderx;
    trackingContext->bordery = controlTrackingContext->bordery;
    trackingContext->nPyramidLevels = controlTrackingContext->nPyramidLevels;
    trackingContext->subsampling = controlTrackingContext->subsampling;
}

