#ifndef __IMAGETOOLS2_H__
#define __IMAGETOOLS2_H__

#include <memory.h>
#include <stdio.h>
#include <stdlib.h> 
#include <math.h>

typedef enum _KERNEL_ {
    GAUSS_5x5 = 0x0,
    GAUSS_7x7 = 0x1,
    USER_5x5 = 0x2,
    USER_7x7 = 0x3
} KERNEL;

extern float* user_5x5;
extern float* user_7x7;

typedef void* (*smooth_function)(float*,int,int,float*,KERNEL);

void  convolution_5x5( float* src , int w_src , int h_src , float* dst , KERNEL kernel );
void  convolution_7x7( float* src , int w_src , int h_src , float* dst , KERNEL kernel );
void  sobel_3x3( float* src , int w_src , int h_src , float* dst);

void  sobel( float* src , int w_src , int h_src , float* gradx , float* grady );

void  image_down_5x5( float* src , int w_src , int h_src , float* dst , KERNEL kernel );
void  image_down_7x7( float* src , int w_src , int h_src , float* dst , KERNEL kernel );

#endif 

