//---------------------------------------------------------------------------
#pragma hdrstop
#include "SkinModelAcquisition.h"
//---------------------------------------------------------------------------

#pragma package(smart_init)

#include <fstream>


void SkinModelAcquisitor::clearSamples(){
    samplesR.clear();
    samplesG.clear();
    samplesB.clear();
}

int SkinModelAcquisitor::getSamples( ImageStruct * image, int x1, int y1, int x2, int y2){
    if( x1 > x2){
        int temp = x1;
        x1 = x2;
        x2 = temp;
    }
    if( y1 > y2){
        int temp = y1;
        y1 = y2;
        y2 = temp;
    }
    if( x1 < 0)
        x1 = 0;
    if( y1 < 0)
        y1 = 0;
    for( int y = y1; y < y2 && y < image->YSize; y++){
        for( int x = x1; x < x2 && x < image->XSize; x++){
            samplesR.push_back( ImageRGBPixelR( image, x, y));
            samplesG.push_back( ImageRGBPixelG( image, x, y));
            samplesB.push_back( ImageRGBPixelB( image, x, y));
        }
    }
}

void SkinModelAcquisitor::saveModel( std::string saveModelFileName){
    std::vector<double> rSamples;
    std::vector<double> gSamples;

    double cMatrix[4];
    int sampleCount;
    double meanR, meanG;

    meanR = 0;
    meanG = 0;
    sampleCount = 0;
    cMatrix[0] = cMatrix[1] = cMatrix[2] = cMatrix[3] =0;

    //nacteni RGB samples - prevod na norm RG a vypocet mean r a mean g
    for( int i = 0; i < samplesR.size(); i++){
        double r = samplesR[i] / (double)(samplesR[i] + samplesG[i] + samplesB[i]);
        double g = samplesG[i] / (double)(samplesR[i] + samplesG[i] + samplesB[i]);

        sampleCount++;

        meanR += r;
        meanG += g;

        rSamples.push_back( r);
        gSamples.push_back( g);
    }

    meanR /= sampleCount;
    meanG /= sampleCount;

    // vypocet kovariancni matice
    for( int x = 0; x < sampleCount; x++){
        double dr = rSamples[x] - meanR;
        double dg = gSamples[x] - meanG;

        // prvni radek matice
        cMatrix[0] += dr * dr;
        cMatrix[1] += dr * dg;

        //druhy radek matice
        cMatrix[2] += dg * dr;
        cMatrix[3] += dg * dg;
    }

    cMatrix[0] /= sampleCount;
    cMatrix[1] /= sampleCount;
    cMatrix[2] /= sampleCount;
    cMatrix[3] /= sampleCount;

    std::ofstream stream( saveModelFileName.data());
    if( stream.bad()){
        throw "Unable to open output file for skin model file";
    }

    stream << meanR << std::endl;
    stream << meanG << std::endl;
    stream << cMatrix[0] << ' ' << cMatrix[1] << std::endl;
    stream << cMatrix[2] << ' ' << cMatrix[3] << std::endl;
    stream << "Sample count: " << sampleCount;
    stream.close();
}

