//---------------------------------------------------------------------------
#pragma hdrstop
#include "ImageFun2.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
void FastDownSample(ImageStruct *Input, ImageStruct *Output, int XRatio, int YRatio) {
    char *Src = Input->Raster;
    char *Dst = Output->Raster;

    for (int y = 0; y < ImageYSize(Output); y++) {
      int *SrcLine = (int*)Src;
      int *DstLine = (int*)Dst;

      for (int x = 0; x < ImageXSize(Output); x++) {
        *DstLine = *SrcLine;
        DstLine++;
        SrcLine += XRatio;
      }
      Src += Input->YOffset * YRatio;
      Dst += Output->YOffset;
    }
}

