//---------------------------------------------------------------------------
//	DVCapture
//  2002 - 2005 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	UnitSources.cpp
//  sources selection form
//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include <vcl.h>
#pragma hdrstop
#include "UnitSources.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormSources *FormSources;

const AnsiString VideoSourceID = "Video: ";
const AnsiString AudioSourceID = "Audio: ";

const AnsiString AudioFiles = ".wav";
const AnsiString VideoFiles = ".mpg";
//---------------------------------------------------------------------------

__fastcall TFormSources::TFormSources(TComponent* Owner): TForm(Owner) {
}
//---------------------------------------------------------------------------

void __fastcall TFormSources::FormShow(TObject *Sender) {
	ListBoxSources->Items->Clear();
  HRESULT hr;
  ICreateDevEnum *pDevEnum = NULL;
  IEnumMoniker *pEnum = NULL;

	// Create the System Device Enumerator.
	hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, (void**)(&pDevEnum));
	if (SUCCEEDED(hr)) {
    // Create an enumerator for the video capture category.
    hr = pDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnum, 0);

    if (pEnum != NULL) {
      HWND hList; // Handle to the list box.
      IMoniker *pMoniker = NULL;
      while (pEnum->Next(1, &pMoniker, NULL) == S_OK) {
        IPropertyBag *pPropBag;
        hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void**)(&pPropBag));
        if (FAILED(hr)) {
        	pMoniker->Release();
          continue;  // Skip this one, maybe the next one will work.
        }
        // Find the description or friendly name.
        VARIANT varName;
        VariantInit(&varName);
        hr = pPropBag->Read(L"Description", &varName, 0);
        if (FAILED(hr)) {
        	hr = pPropBag->Read(L"FriendlyName", &varName, 0);
        }

        if (SUCCEEDED(hr)) {
          ListBoxSources->Items->Add(VideoSourceID + varName.bstrVal);
          VariantClear(&varName);
        }
        pPropBag->Release();
        pMoniker->Release();
      }
      pEnum->Release();
    }
    pDevEnum->Release();
  }

  pDevEnum = NULL;
  pEnum = NULL;

	// Create the System Device Enumerator.
	hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, (void**)(&pDevEnum));
	if (SUCCEEDED(hr)) {
    // Create an enumerator for the audio capture category.
    hr = pDevEnum->CreateClassEnumerator(CLSID_AudioInputDeviceCategory, &pEnum, 0);

    if (pEnum != NULL) {
      HWND hList; // Handle to the list box.
      IMoniker *pMoniker = NULL;
      while (pEnum->Next(1, &pMoniker, NULL) == S_OK) {
        IPropertyBag *pPropBag;
        hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void**)(&pPropBag));
        if (FAILED(hr)) {
        	pMoniker->Release();
          continue;  // Skip this one, maybe the next one will work.
        }
        // Find the description or friendly name.
        VARIANT varName;
        VariantInit(&varName);
        hr = pPropBag->Read(L"Description", &varName, 0);
        if (FAILED(hr)) {
        	hr = pPropBag->Read(L"FriendlyName", &varName, 0);
        }

        if (SUCCEEDED(hr)) {
          ListBoxSources->Items->Add(AudioSourceID + varName.bstrVal);
          VariantClear(&varName);
        }
        pPropBag->Release();
        pMoniker->Release();
      }
      pEnum->Release();
    }
    pDevEnum->Release();
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormSources::BitBtn1Click(TObject *Sender) {
	if (ListBoxSources->SelCount > 0)
		ModalResult = mrOk;
  else
  	ShowMessage("No selected source!");
}
//---------------------------------------------------------------------------

bool TFormSources::IsVideoSource(AnsiString Name) {
	return Name.Pos(VideoSourceID) == 1;
}
//---------------------------------------------------------------------------

bool TFormSources::IsAudioSource(AnsiString Name) {
	return Name.Pos(AudioSourceID) == 1;
}
//---------------------------------------------------------------------------

AnsiString TFormSources::GetVideoSourceID() {
	return VideoSourceID;
}
//---------------------------------------------------------------------------

AnsiString TFormSources::GetAudioSourceID() {
	return AudioSourceID;
}
//---------------------------------------------------------------------------

void __fastcall TFormSources::BitBtn3Click(TObject *Sender) {
  if (OpenDialog1->Execute()) {
    AnsiString Ext = ExtractFileExt(OpenDialog1->FileName);
    if (AnsiSameText(Ext, AudioFiles))
      ListBoxSources->Items->Add(AudioSourceID + OpenDialog1->FileName);
    else if (AnsiSameText(Ext, VideoFiles))
      ListBoxSources->Items->Add(VideoSourceID + OpenDialog1->FileName);
    else
      ShowMessage("Unsupported file type!");
  }
}
//---------------------------------------------------------------------------

