//---------------------------------------------------------------------------
#ifndef UnitMainH
#define UnitMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <Dialogs.hpp>
#include <Menus.hpp>
#include <AppEvnts.hpp>
#include "ImageControl.h"
#include <vector>
#include "AVSource.h"
#include "AudioServer.h"
#include "FrameServer.h"
#include "MemoryManager.h"
#include "SampleGrabberADCB.h"

extern const AnsiString DefaultINI;

//---------------------------------------------------------------------------
class TFormMain : public TForm
{
__published:	// IDE-managed Components
	TButton *ButtonAdd;
	TButton *ButtonRemove;
  TListView *ListViewSources;
  TSaveDialog *SaveDialog;
  TButton *ButtonProperties;
  TMainMenu *MainMenu1;
  TMenuItem *FileSave;
  TMenuItem *Open1;
  TMenuItem *Save1;
  TSaveDialog *SaveDialog1;
  TOpenDialog *OpenDialog1;
  TMenuItem *Help1;
  TMenuItem *About1;
	TPageControl *PageControl;
	TTabSheet *TabSheet1;
	TLabel *Label1;
	TLabel *Label3;
	TLabel *Label4;
	TLabel *Label5;
	TLabel *Label6;
	TLabel *Label7;
	TLabel *LabelVolume;
	TLabel *LabelBalance;
	TComboBox *ComboBoxChannels;
	TComboBox *ComboBoxBits;
	TComboBox *ComboBoxRate;
	TButton *ButtonRate;
	TComboBox *ComboBoxInput;
	TTrackBar *TrackBarVolume;
	TTrackBar *TrackBarBalance;
	TMenuItem *N1;
	TMenuItem *Exit1;
	TButton *Button1;
	TButton *Button2;
	TTabSheet *TabSheet2;
  TCheckBox *CheckBoxAudioPreview;
  TButton *ButtonFilters;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall ButtonAddClick(TObject *Sender);
  void __fastcall ListViewSourcesDeletion(TObject *Sender,
          TListItem *Item);
  void __fastcall ListViewSourcesSelectItem(TObject *Sender,
          TListItem *Item, bool Selected);
  void __fastcall ButtonPropertiesClick(TObject *Sender);
  void __fastcall ButtonRemoveClick(TObject *Sender);
  void __fastcall Save1Click(TObject *Sender);
  void __fastcall Open1Click(TObject *Sender);
  void __fastcall ComboBoxAudioChange(TObject *Sender);
  void __fastcall ButtonRateClick(TObject *Sender);
  void __fastcall ComboBoxInputChange(TObject *Sender);
  void __fastcall TrackBarVolumeChange(TObject *Sender);
  void __fastcall About1Click(TObject *Sender);
	void __fastcall Exit1Click(TObject *Sender);
	void __fastcall Button1Click(TObject *Sender);
  void __fastcall CheckBoxAudioPreviewClick(TObject *Sender);
  void __fastcall ButtonFiltersClick(TObject *Sender);
private:	// User declarations
  DWORD g_dwGraphRegister;
  IGraphBuilder *pGraph;
  ICaptureGraphBuilder2 *pBuild;
  IMediaControl *pMC;
  IMediaSeeking *pMS;
  float AudioDelay;

  bool ChangeAudio, ChangeVideo, Running;

  bool AddVideoSource(AnsiString Name);
  bool AddAudioSource(AnsiString Name);

  void AddPreview();
  void RemovePreview();

  void AddFilterToGraph(REFCLSID rclsid, IBaseFilter **ppv, const char *Name);
  bool ConnectF2F(const GUID *pType, IBaseFilter *fin, IBaseFilter *fout, bool ShowError = true);
  void RemoveOutputFilters();
  void RunStopGraph();

  void SelectComboBoxItem(TComboBox *ComboBox, AnsiString Value);
  void LoadINI(AnsiString FileName);
  void SaveINI(AnsiString FileName);
public:		// User declarations
  TMManager *MManager;
  TAudioServer *pAudioServer;
  TFrameServer *pFrameServer;

	__fastcall TFormMain(TComponent* Owner);
  void Run();
  void Stop();
  void SetAudioDelay(float Value);
};
//---------------------------------------------------------------------------
extern PACKAGE TFormMain *FormMain;
//---------------------------------------------------------------------------
#endif
