//---------------------------------------------------------------------------
//	DVCapture
//  2002 - 2005 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	UnitMain.cpp
//  main form
//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include "BaseClasses_hack.h"
#include "garguids.h"
#include "igargle.h"
#include <winsock2.h>
#include <SysUtils.hpp>
#include <IniFiles.hpp>
#include <StrUtils.hpp>
#include <vcl.h>
#include <math.h>
//---------------------------------------------------------------------------
#pragma hdrstop
#include "DSTools.h"
#include "UnitMain.h"
#include "UnitSources.h"
#include "UnitSampleRate.h"
#include "fuuids.h"
#include "SampleGrabberCB.h"
#include "SampleGrabberADCB.h"
#include "AudioServer.h"
#include "FrameServer.h"
#include "UnitFilters.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ImageControl"
#pragma resource "*.dfm"

TFormMain *FormMain;

const AnsiString DefaultINI = "AMIDemo.ini";
const AnsiString SectionMain = "Main";
//---------------------------------------------------------------------------

__fastcall TFormMain::TFormMain(TComponent* Owner): TForm(Owner) {
  MManager = NULL;
	pAudioServer = NULL;
  pFrameServer = NULL;
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::FormCreate(TObject *Sender) {
	if(FAILED(CoInitializeEx(NULL, COINIT_APARTMENTTHREADED))) {
  	ShowMessage("CoInitialize Failed!");
    exit(1);
  }

  AudioDelay = 1;
  ChangeVideo = ChangeAudio = true;
  pGraph = NULL;
  pBuild = NULL;
  pMC = NULL;
  pMS = NULL;
  Running = false;

  if (InitCaptureGraphBuilder(&pGraph, &pBuild, &pMC) != S_OK) {
  	ShowMessage("CreateGraph Failed!");
    exit(1);
  }
  pGraph->QueryInterface(IID_IMediaSeeking,(LPVOID *) &pMS);

  g_dwGraphRegister = 0;
  AddGraphToRot(pGraph, &g_dwGraphRegister);

  MManager = new TMManager();
//  TBuffer::MemoryManager = MManager;

  pAudioServer = new TAudioServer();
  pAudioServer->Priority = tpTimeCritical;

  if (pAudioServer->Connect(INADDR_ANY, 65000) == 0)
  	pAudioServer->Resume();
  else
  	ShowMessage("Could not start server!");

  pFrameServer = new TFrameServer();
  pFrameServer->Resume();

  ListViewSources->OnSelectItem(NULL, NULL, true);
  LoadINI(ExtractFileDir(Application->ExeName) + "\\" + DefaultINI);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::FormDestroy(TObject *Sender) {
	Stop();
	if (g_dwGraphRegister != 0)
  	RemoveGraphFromRot(g_dwGraphRegister);

  pAudioServer->Terminate();
  pFrameServer->Terminate();
  pAudioServer->WaitFor();
  pFrameServer->WaitFor();

  ListViewSources->Items->Clear();
  SAFE_RELEASE(pMC);
  SAFE_RELEASE(pMS);
	SAFE_RELEASE(pGraph);
  SAFE_RELEASE(pBuild);

  delete pAudioServer;
  delete pFrameServer;
  delete MManager;
	CoUninitialize();
}
//---------------------------------------------------------------------------


void __fastcall TFormMain::Open1Click(TObject *Sender) {
	if (Running)
  	return;

  if (OpenDialog1->Execute()) {
    LoadINI(OpenDialog1->FileName);
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::Save1Click(TObject *Sender) {
  if (SaveDialog1->Execute()) {
    SaveINI(SaveDialog1->FileName);
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::Exit1Click(TObject *Sender) {
	Close();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::About1Click(TObject *Sender) {
  ShowMessage(Application->Title + " (Compiled: " + AnsiString(__DATE__) + ")\n2002 - 2006 Stanislav Sumec\nBrno University of Technology\nFaculty of Information Technology");
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Aux DS methods -----------------------------------------------------------
//---------------------------------------------------------------------------

void TFormMain::AddFilterToGraph(REFCLSID rclsid, IBaseFilter **ppv, const char *Name) {
  *ppv = NULL;
  int hr;
  LPVOID pv;
  hr = CoCreateInstance(rclsid, 0, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (void**)(&pv));
  if (SUCCEEDED(hr)) {
    AnsiString n = Name;
    wchar_t wn[1024];
    n.WideChar(wn, 1024);
    hr = pGraph->AddFilter((IBaseFilter*)pv, wn);
    if (SUCCEEDED(hr)) {
      *ppv = (IBaseFilter*)pv;
    } else {
      ((IBaseFilter*)pv)->Release();
    }
  }
  if (*ppv == NULL)
    ShowMessage(AnsiString("Could not add filter!\n") + Name);
}
//---------------------------------------------------------------------------

bool TFormMain::ConnectF2F(const GUID *pType, IBaseFilter *fin, IBaseFilter *fout, bool ShowError) {
  bool b = (SUCCEEDED(pBuild->RenderStream(0, pType, fin, 0, fout)));
  if (!b && ShowError) {
    AnsiString Message = "Could not connect filters!";
    FILTER_INFO Info;
    if (fin->QueryFilterInfo(&Info) == S_OK) {
    	Message = Message + "\n" + Info.achName;
      if (Info.pGraph != NULL)
      	Info.pGraph->Release();
    }
    if (fout->QueryFilterInfo(&Info) == S_OK) {
    	Message = Message + "\n" + Info.achName;
      if (Info.pGraph != NULL)
      	Info.pGraph->Release();
    }
    ShowMessage(Message);
  }
  return b;
}
//---------------------------------------------------------------------------

void TFormMain::RunStopGraph() {
  pMC->Run();
  Sleep(1000);
  pMC->Stop();
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

bool TFormMain::AddVideoSource(AnsiString Name) {
	int IDLength = FormSources->GetVideoSourceID().Length();
	AnsiString DName = Name.SubString(1 + IDLength, Name.Length() - IDLength);

  if (FileExists(ExpandFileName(DName))) {
    HRESULT hr;
    TAVSource AVSource;
    AVSource.Type = 0;
    AVSource.VideoFormat = 0;
    AVSource.File = "";
    AVSource.VideoPreview = false;
    AVSource.AudioPreview = false;
    AVSource.Init();
    AVSource.FileSource = true;

    AddFilterToGraph(CLSID_AsyncReader, &AVSource.pCap, "File source");

    if (AVSource.pCap) {
      CComQIPtr<IFileSourceFilter, &IID_IFileSourceFilter> pSource(AVSource.pCap);
      if (pSource) {
        WideString n = DName;
        if (pSource->Load(n.c_bstr(), NULL) == 0) {
          AddFilterToGraph(CLSID_SampleGrabber, &AVSource.pSampleGrabber, "SampleGrabber");
          AddFilterToGraph(CLSID_NullRenderer, &AVSource.pNullRenderer, "NullRenderer");

          AddFilterToGraph(CLSID_MoonlightDemuxer2, &AVSource.pMPEG2TSDemux, "MPEG2PS Demuxer");
          if (AVSource.pMPEG2TSDemux != NULL) {
            if (ConnectF2F(NULL, AVSource.pCap, AVSource.pMPEG2TSDemux, false))
              /*RunStopGraph()*/;
            else
              SAFE_REMOVE(pGraph, AVSource.pMPEG2TSDemux);
          }

          if (AVSource.pSampleGrabber != NULL && AVSource.pNullRenderer != NULL) {
            CComQIPtr<ISampleGrabber, &IID_ISampleGrabber> pGrabber(AVSource.pSampleGrabber);
            if (pGrabber) {
              AVSource.SampleGrabberCB = new TSampleGrabberCB();
              if (pGrabber->SetBufferSamples(FALSE) ==  S_OK &&
                  pGrabber->SetOneShot(FALSE) ==  S_OK &&
                  pGrabber->SetCallback(AVSource.SampleGrabberCB, 1) == S_OK) {
                CMediaType GrabType;
                GrabType.SetType(&MEDIATYPE_Video);
                GrabType.SetSubtype(&MEDIASUBTYPE_RGB32);
                hr = pGrabber->SetMediaType(&GrabType);
                if (SUCCEEDED(hr)) {
                  if (ConnectF2F(&MEDIATYPE_Video, AVSource.pCap, AVSource.pSampleGrabber) && ConnectF2F(&MEDIATYPE_Video, AVSource.pSampleGrabber, AVSource.pNullRenderer)) {
                    AM_MEDIA_TYPE mt;
                    hr = pGrabber->GetConnectedMediaType(&mt);
                    if (SUCCEEDED(hr)) {
                      VIDEOINFOHEADER *vih = (VIDEOINFOHEADER*)mt.pbFormat;
                      AVSource.VideoWidth = vih->bmiHeader.biWidth;
                      AVSource.VideoHeight = vih->bmiHeader.biHeight;
                      FreeMediaType(mt);
                    }

                    TListItem *li = ListViewSources->Items->Add();
                    li->Caption = Name;
                    li->Data = new TAVSource;
                    (*((TAVSource*)(li->Data))) = AVSource;
                    ListViewSources->Selected = li;
                    pFrameServer->AddAVSource((TAVSource*)li->Data);
                    return true;
                  }
                }
              }
            }
          }
        }
      }
    }
    ShowMessage("Could not add source: " + Name);
    AVSource.Release(pGraph);
    return false;
  } else {
    ICreateDevEnum *pDevEnum = NULL;
    IEnumMoniker *pEnum = NULL;

    // Create the System Device Enumerator.
    HRESULT hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, (void**)(&pDevEnum));
    if (SUCCEEDED(hr)) {
      // Create an enumerator for the video capture category.
      hr = pDevEnum->CreateClassEnumerator(CLSID_VideoInputDeviceCategory, &pEnum, 0);

      if (pEnum != NULL) {
        IMoniker *pMoniker = NULL;
        while (pEnum->Next(1, &pMoniker, NULL) == S_OK) {
          IPropertyBag *pPropBag;
          hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void**)(&pPropBag));
          if (FAILED(hr)) {
            pMoniker->Release();
            continue;  // Skip this one, maybe the next one will work.
          }
          // Find the description or friendly name.
          VARIANT varName;
          VariantInit(&varName);
          hr = pPropBag->Read(L"Description", &varName, 0);
          if (FAILED(hr)) {
            hr = pPropBag->Read(L"FriendlyName", &varName, 0);
          }

          if (SUCCEEDED(hr)) {
            if (AnsiString(varName.bstrVal) == DName) {
              VariantClear(&varName);

              TAVSource AVSource;
              AVSource.Type = 0;
              AVSource.VideoFormat = 0;
              AVSource.File = "";
              AVSource.VideoPreview = false;
              AVSource.AudioPreview = false;
              AVSource.Init();

              hr = pMoniker->BindToObject(0, 0, IID_IBaseFilter, (void**)&AVSource.pCap);
              if (SUCCEEDED(hr)) {
                  hr = pGraph->AddFilter(AVSource.pCap, L"Capture Filter");

                  pPropBag->Release();
                  pMoniker->Release();

                  pEnum->Release();
                  pDevEnum->Release();

                  AddFilterToGraph(CLSID_SampleGrabber, &AVSource.pSampleGrabber, "SampleGrabber");
                  AddFilterToGraph(CLSID_NullRenderer, &AVSource.pNullRenderer, "NullRenderer");

                  AddFilterToGraph(CLSID_MoonlightDemuxer, &AVSource.pMPEG2TSDemux, "MPEG2TS Demuxer");
                  if (AVSource.pMPEG2TSDemux != NULL) {
                    if (ConnectF2F(NULL, AVSource.pCap, AVSource.pMPEG2TSDemux, false))
                      RunStopGraph();
                    else
                      SAFE_REMOVE(pGraph, AVSource.pMPEG2TSDemux);
                  }

                  if (AVSource.pSampleGrabber != NULL && AVSource.pNullRenderer != NULL) {
                      CComQIPtr<ISampleGrabber, &IID_ISampleGrabber> pGrabber(AVSource.pSampleGrabber);
                      if (pGrabber) {
                        AVSource.SampleGrabberCB = new TSampleGrabberCB();
                        if (pGrabber->SetBufferSamples(FALSE) ==  S_OK &&
                            pGrabber->SetOneShot(FALSE) ==  S_OK &&
                            pGrabber->SetCallback(AVSource.SampleGrabberCB, 1) == S_OK) {
                          CMediaType GrabType;
                          GrabType.SetType(&MEDIATYPE_Video);
                          GrabType.SetSubtype(&MEDIASUBTYPE_RGB32);
                          hr = pGrabber->SetMediaType(&GrabType);
                          if (SUCCEEDED(hr)) {
                            if (ConnectF2F(&MEDIATYPE_Video, AVSource.pCap, AVSource.pSampleGrabber) && ConnectF2F(&MEDIATYPE_Video, AVSource.pSampleGrabber, AVSource.pNullRenderer)) {
                              AM_MEDIA_TYPE mt;
                              hr = pGrabber->GetConnectedMediaType(&mt);
                              if (SUCCEEDED(hr)) {
                                VIDEOINFOHEADER *vih = (VIDEOINFOHEADER*)mt.pbFormat;
                                AVSource.VideoWidth = vih->bmiHeader.biWidth;
                                AVSource.VideoHeight = vih->bmiHeader.biHeight;
                                FreeMediaType(mt);
                              }

                              TListItem *li = ListViewSources->Items->Add();
                              li->Caption = Name;
                              li->Data = new TAVSource;
                              (*((TAVSource*)(li->Data))) = AVSource;
                              ListViewSources->Selected = li;
                              pFrameServer->AddAVSource((TAVSource*)li->Data);
                              return true;
                            }
                          }
                        }
                      }
                  }
                  ShowMessage("Could not add source: " + Name);
                  AVSource.Release(pGraph);
                  return false;
              }
            } else
              VariantClear(&varName);
          }
          pPropBag->Release();
          pMoniker->Release();
        }
      }
      SAFE_RELEASE(pEnum);
      SAFE_RELEASE(pDevEnum);
    }
    return false;
  }
}
//---------------------------------------------------------------------------

bool TFormMain::AddAudioSource(AnsiString Name) {
  int IDLength = FormSources->GetAudioSourceID().Length();
	AnsiString DName = Name.SubString(1 + IDLength, Name.Length() - IDLength);

  if (FileExists(ExpandFileName(DName))) {
    TAVSource AVSource;
    AVSource.Type = 1;
    AVSource.VideoFormat = 0;
    AVSource.File = "";
    AVSource.VideoPreview = false;
    AVSource.AudioPreview = false;
    AVSource.Init();
    AVSource.FileSource = true;

    AddFilterToGraph(CLSID_AsyncReader, &AVSource.pCap, "File source");
    AddFilterToGraph(CLSID_WAVEParser, &AVSource.pDVSplit, "Wave parser");
    AddFilterToGraph(CLSID_InfTee, &AVSource.pInfTee, "Infinite Pin Tee Filter");
    AddFilterToGraph(CLSID_SampleGrabber, &AVSource.pSampleGrabber, "SampleGrabber");
    AddFilterToGraph(CLSID_NullRenderer, &AVSource.pNullRenderer, "NullRenderer");

    if (AVSource.pCap && AVSource.pDVSplit && AVSource.pInfTee && AVSource.pSampleGrabber && AVSource.pNullRenderer) {
      CComQIPtr<IFileSourceFilter, &IID_IFileSourceFilter> pSource(AVSource.pCap);
      if (pSource) {
        WideString n = DName;
        if (pSource->Load(n.c_bstr(), NULL) == 0) {
          if (ConnectF2F(NULL, AVSource.pCap, AVSource.pDVSplit) && ConnectF2F(&MEDIATYPE_Audio, AVSource.pDVSplit, AVSource.pInfTee) && ConnectF2F(&MEDIATYPE_Audio, AVSource.pInfTee, AVSource.pSampleGrabber) && ConnectF2F(&MEDIATYPE_Audio, AVSource.pSampleGrabber, AVSource.pNullRenderer)) {
            CComQIPtr<ISampleGrabber, &IID_ISampleGrabber> pGrabber(AVSource.pSampleGrabber);
            if (pGrabber) {
              AVSource.SampleGrabberCB = new TSampleGrabberCB();
              if (pGrabber->SetBufferSamples(FALSE) ==  S_OK &&
                  pGrabber->SetOneShot(FALSE) ==  S_OK &&
                  pGrabber->SetCallback(AVSource.SampleGrabberCB, 1) == S_OK) {

                TListItem *li = ListViewSources->Items->Add();
                li->Caption = Name;
                li->Data = new TAVSource;
                (*((TAVSource*)(li->Data))) = AVSource;
                ListViewSources->Selected = li;
                pAudioServer->AddAVSource((TAVSource*)li->Data);
                return true;
              }
            }
          }
        }
      }
    }
    ShowMessage("Could not add source: " + Name);
    AVSource.Release(pGraph);
    return false;
  } else {
    ICreateDevEnum *pDevEnum = NULL;
    IEnumMoniker *pEnum = NULL;

    // Create the System Device Enumerator.
    HRESULT hr = CoCreateInstance(CLSID_SystemDeviceEnum, NULL, CLSCTX_INPROC_SERVER, IID_ICreateDevEnum, (void**)(&pDevEnum));
    if (SUCCEEDED(hr)) {
      // Create an enumerator for the audio capture category.
      hr = pDevEnum->CreateClassEnumerator(CLSID_AudioInputDeviceCategory, &pEnum, 0);

      if (pEnum != NULL) {
        IMoniker *pMoniker = NULL;
        while (pEnum->Next(1, &pMoniker, NULL) == S_OK) {
          IPropertyBag *pPropBag;
          hr = pMoniker->BindToStorage(0, 0, IID_IPropertyBag, (void**)(&pPropBag));
          if (FAILED(hr)) {
            pMoniker->Release();
            continue;  // Skip this one, maybe the next one will work.
          }
          // Find the description or friendly name.
          VARIANT varName;
          VariantInit(&varName);
          hr = pPropBag->Read(L"Description", &varName, 0);
          if (FAILED(hr)) {
            hr = pPropBag->Read(L"FriendlyName", &varName, 0);
          }

          if (SUCCEEDED(hr)) {
            if (AnsiString(varName.bstrVal) == DName) {
              VariantClear(&varName);

              TAVSource AVSource;
              AVSource.Type = 1;
              AVSource.VideoFormat = 0;
              AVSource.File = "";
              AVSource.VideoPreview = false;
              AVSource.AudioPreview = false;
              AVSource.Init();

              hr = pMoniker->BindToObject(0, 0, IID_IBaseFilter, (void**)&AVSource.pCap);
              if (SUCCEEDED(hr)) {
                  hr = pGraph->AddFilter(AVSource.pCap, L"Capture Filter");
                  IPin *OutPin = GetPin(AVSource.pCap, PINDIR_OUTPUT, 0);
                  if (OutPin) {
                    CComQIPtr<IAMBufferNegotiation, &IID_IAMBufferNegotiation> pAMBufferNegotiation(OutPin);
                    if (pAMBufferNegotiation) {
                      ALLOCATOR_PROPERTIES ap;
  //                    hr = pAMBufferNegotiation->GetAllocatorProperties(&ap);
                      ap.cbAlign = -1;  // -1 means no preference.
                      ap.cbBuffer = 8000;
                      ap.cbPrefix = -1;
                      ap.cBuffers = -1;
                      hr = pAMBufferNegotiation->SuggestAllocatorProperties(&ap);
                    }
                    OutPin->Release();
                  }

                  pPropBag->Release();
                  pMoniker->Release();

                  pEnum->Release();
                  pDevEnum->Release();

                  AddFilterToGraph(CLSID_SampleGrabber, &AVSource.pSampleGrabber, "SampleGrabber");
                  AddFilterToGraph(CLSID_NullRenderer, &AVSource.pNullRenderer, "NullRenderer");
                  AddFilterToGraph(CLSID_InfTee, &AVSource.pInfTee, "Infinite Pin Tee Filter");

                  if (AVSource.pInfTee && AVSource.pSampleGrabber != NULL && AVSource.pNullRenderer != NULL) {
                    if (ConnectF2F(&MEDIATYPE_Audio, AVSource.pCap, AVSource.pInfTee) &&
                        ConnectF2F(&MEDIATYPE_Audio, AVSource.pInfTee, AVSource.pSampleGrabber) &&
                        /*ConnectF2F(&MEDIATYPE_Audio, AVSource.pCap, AVSource.pSampleGrabber) &&*/
                        ConnectF2F(&MEDIATYPE_Audio, AVSource.pSampleGrabber, AVSource.pNullRenderer)) {
                      CComQIPtr<ISampleGrabber, &IID_ISampleGrabber> pGrabber(AVSource.pSampleGrabber);
                      if (pGrabber) {
                        AVSource.SampleGrabberCB = new TSampleGrabberCB();
                        if (pGrabber->SetBufferSamples(FALSE) ==  S_OK &&
                            pGrabber->SetOneShot(FALSE) ==  S_OK &&
                            pGrabber->SetCallback(AVSource.SampleGrabberCB, 1) == S_OK) {

                          TListItem *li = ListViewSources->Items->Add();
                          li->Caption = Name;
                          li->Data = new TAVSource;
                          (*((TAVSource*)(li->Data))) = AVSource;
                          ListViewSources->Selected = li;
                          pAudioServer->AddAVSource((TAVSource*)li->Data);
                          return true;
                        }
                      }
                    }
                  }
                  ShowMessage("Could not add source: " + Name);
                  AVSource.Release(pGraph);
                  return false;
              }

            } else
              VariantClear(&varName);
          }
          pPropBag->Release();
          pMoniker->Release();
        }
      }
      SAFE_RELEASE(pEnum);
      SAFE_RELEASE(pDevEnum);
    }
    return false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonAddClick(TObject *Sender) {
	if (Running)
  	return;

	if (FormSources->ShowModal() == mrOk) {
  	for (int i = 0; i < FormSources->ListBoxSources->Items->Count; i++) {
    	if (FormSources->ListBoxSources->Selected[i]) {
        AnsiString Name = FormSources->ListBoxSources->Items->Strings[i];
        if (FormSources->IsVideoSource(Name))
          AddVideoSource(Name);
        else if (FormSources->IsAudioSource(Name))
          AddAudioSource(Name);
        ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
      }
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonRemoveClick(TObject *Sender) {
	if (Running)
  	return;

  if (ListViewSources->Selected != NULL) {
    CheckBoxAudioPreview->Checked = false;
    ListViewSources->Selected->Delete();
    ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonPropertiesClick(TObject *Sender) {
  if (ListViewSources->Selected != NULL) {
    TAVSource *s = ((TAVSource*)(ListViewSources->Selected->Data));
    ShowFilterProperties(Handle, s->pCap);
  }
  ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ListViewSourcesDeletion(TObject *Sender, TListItem *Item) {
  TAVSource *av = ((TAVSource*)(Item->Data));
  pAudioServer->RemoveAVSource(av);
  pFrameServer->RemoveAVSource(av);
  av->Release(pGraph);
  delete av;
}
//---------------------------------------------------------------------------

void TFormMain::SelectComboBoxItem(TComboBox *ComboBox, AnsiString Value) {
  ComboBox->ItemIndex = ComboBox->Items->IndexOf(Value);
  if (ComboBox->ItemIndex < 0)
    ComboBox->ItemIndex = ComboBox->Items->Add(Value);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ListViewSourcesSelectItem(TObject *Sender, TListItem *Item, bool Selected) {
  if (Selected) {
    ChangeVideo = ChangeAudio = false;

    bool e = Item != NULL;
    ButtonRate->Enabled = e;
    CheckBoxAudioPreview->Enabled = e;
    TrackBarVolume->Enabled = e;
    TrackBarBalance->Enabled = e;

    ComboBoxChannels->Items->Clear();
    ComboBoxBits->Items->Clear();
    ComboBoxRate->Items->Clear();
    ComboBoxInput->Items->Clear();

    ComboBoxChannels->Enabled = e;
    ComboBoxBits->Enabled = e;
    ComboBoxRate->Enabled = e;
    ComboBoxInput->Enabled = e;

    int hr;
    if (e) {
      TAVSource *av = ((TAVSource*)(Item->Data));
      CheckBoxAudioPreview->Checked = av->AudioPreview;

      if (av->Type == 0) {
	      PageControl->ActivePageIndex = 1;
        TrackBarVolume->Position = 0;
        TrackBarBalance->Position = 0;
        LabelVolume->Caption = "";
        LabelBalance->Caption = "";

        int width, height, frames;
        VIDEO_STREAM_CONFIG_CAPS scc;
/*
        SetVideoParams(pBuild, av->pCap, 360, 288, 25);
        GetVideoParams(pBuild, av->pCap, width, height, frames, scc);

        for (unsigned int i = scc.MinCroppingSize.cx; i <= scc.MaxCroppingSize.cx; i += scc.CropGranularityX)
          ComboBoxWidth->Items->Add(IntToStr(i));

        for (unsigned int i = scc.MinCroppingSize.cy; i <= scc.MaxCroppingSize.cy; i += scc.CropGranularityY)
          ComboBoxHeight->Items->Add(IntToStr(i));

        SelectComboBoxItem(ComboBoxWidth, width);
        SelectComboBoxItem(ComboBoxHeight, height);

        if (av->pDVSplit != NULL) {
        	RadioButtonVFAVI->Enabled = true;
          RadioButtonVFAVI->Checked = true;
          av->VideoFormat = 0;
        } else {
        	RadioButtonVFMPEG2TS->Enabled = true;
    			RadioButtonVFMPEG2PS->Enabled = true;
          if (av->VideoFormat == 1)
          	RadioButtonVFMPEG2TS->Checked = true;
          else {
          	RadioButtonVFMPEG2PS->Checked = true;
            av->VideoFormat = 2;
          }
        }
*/        
      } else {
      	PageControl->ActivePageIndex = 0;
        int rate, bits, chn;
        AUDIO_STREAM_CONFIG_CAPS scc;
        GetAudioParams(pBuild, av->pCap, rate, bits, chn, scc);

        for (unsigned int i = scc.MinimumChannels; i <= scc.MaximumChannels; i += scc.ChannelsGranularity)
          ComboBoxChannels->Items->Add(IntToStr(i));
        for (unsigned int i = scc.MinimumBitsPerSample; i <= scc.MaximumBitsPerSample; i += scc.BitsPerSampleGranularity)
          ComboBoxBits->Items->Add(IntToStr(i));
        for (unsigned int i = scc.MinimumSampleFrequency; i <= scc.MaximumSampleFrequency; i += scc.SampleFrequencyGranularity)
          ComboBoxRate->Items->Add(IntToStr(i));

        SelectComboBoxItem(ComboBoxChannels, chn);
        SelectComboBoxItem(ComboBoxBits, bits);
        SelectComboBoxItem(ComboBoxRate, rate);

        Pins pins = GetPins(av->pCap, PINDIR_INPUT);

        for (unsigned int i = 0; i < pins.size(); i++)
          ComboBoxInput->Items->Add(GetPinName(pins[i]));

        ComboBoxInput->ItemIndex = FindSelectedPin(pins);
        if (ComboBoxInput->ItemIndex >= 0) {
          double level, pan;
          bool enabled;
          GetPinParams(pins[ComboBoxInput->ItemIndex], level, pan, enabled);
          TrackBarVolume->Position = Round(100.0 * level);
          TrackBarBalance->Position = Round(50.0 * pan);

          LabelVolume->Caption = FloatToStr(level);
          LabelBalance->Caption = FloatToStr(pan);
        }

        ReleasePins(pins);
      }
    } else {
      CheckBoxAudioPreview->Checked = false;  
      TrackBarVolume->Position = 0;
      TrackBarBalance->Position = 0;
      LabelVolume->Caption = "";
      LabelBalance->Caption = "";
      PageControl->ActivePageIndex = 0;
    }

    ChangeVideo = ChangeAudio = true;
  }
}
//---------------------------------------------------------------------------

void TFormMain::SaveINI(AnsiString FileName) {
  TIniFile *ini = new TIniFile(FileName);

  TStringList *Sections = new TStringList();
  try {
    ini->ReadSections(Sections);
    for (int i = 0; i < Sections->Count; i++)
      ini->EraseSection(Sections->Strings[i]);
  } __finally {
    delete Sections;
  }

  for (int i = 0; i < ListViewSources->Items->Count; i++) {
    AnsiString n = ListViewSources->Items->Item[i]->Caption;
    TAVSource *s = ((TAVSource*)(ListViewSources->Items->Item[i]->Data));
    if (s->File != NULL) {
      ini->WriteString(n, "File", s->File);
      ini->WriteBool(n, "Video preview", s->VideoPreview);
      ini->WriteBool(n, "Audio preview", s->AudioPreview);
      ini->WriteInteger(n, "Video format", s->VideoFormat);
/*
      for (int j = 0; j < s->AudioChannels.size(); j++)
        ini->WriteString(n, KeyChannelA + IntToStr(j + 1), s->AudioChannels[j]);
      for (int j = 0; j < s->VideoChannels.size(); j++)
        ini->WriteString(n, KeyChannelV + IntToStr(j + 1), s->VideoChannels[j]);
*/
      if (s->Type == 0) {
      } else {
        int rate, bits, chn;
        GetAudioParams(pBuild, s->pCap, rate, bits, chn);
        ini->WriteInteger(n, "Rate", rate);
        ini->WriteInteger(n, "Bits", bits);
        ini->WriteInteger(n, "Channels", chn);

        Pins pins = GetPins(s->pCap, PINDIR_INPUT);

        int Pin = FindSelectedPin(pins);
        if (Pin >= 0) {
          double level, pan;
          bool enabled;
          GetPinParams(pins[Pin], level, pan, enabled);

          ini->WriteString(n, "Input", GetPinName(pins[Pin]));
          ini->WriteFloat(n, "Volume", level);
          ini->WriteFloat(n, "Balance", pan);
        }
        ReleasePins(pins);
      }
    }
  }
  delete ini;
}
//---------------------------------------------------------------------------

void TFormMain::LoadINI(AnsiString FileName) {
  ListViewSources->Items->Clear();
  TIniFile *ini = new TIniFile(FileName);

  TStringList *nl = new TStringList();
  ini->ReadSections(nl);
  for (int i = 0; i < nl->Count; i++) {
    AnsiString n = nl->Strings[i];
    if (n != SectionMain) {
      bool ok;
      if (FormSources->IsVideoSource(n)) {
        ok = AddVideoSource(n);
      } else if (FormSources->IsAudioSource(n)) {
        ok = AddAudioSource(n);
      } else
      	ok = false;

      if (ok) {
        TAVSource *s = ((TAVSource*)(ListViewSources->Items->Item[ListViewSources->Items->Count - 1]->Data));

        TStringList *Values = new TStringList();
        try {
          ini->ReadSection(n, Values);
          /*
          for (int j = 0; j < Values->Count; j++) {
            if (AnsiStartsText(KeyChannelA, Values->Strings[j])) {
              int Number = StrToIntDef(Values->Strings[j].SubString(KeyChannelA.Length() + 1, Values->Strings[j].Length() - KeyChannelA.Length()), 0) - 1;
              if (Number >= 0) {
                if (Number >= s->AudioChannels.size())
                  s->AudioChannels.resize(Number + 1);
                s->AudioChannels[Number] = ini->ReadString(n, Values->Strings[j], "");
              }
            }

            if (AnsiStartsText(KeyChannelV, Values->Strings[j])) {
              int Number = StrToIntDef(Values->Strings[j].SubString(KeyChannelV.Length() + 1, Values->Strings[j].Length() - KeyChannelV.Length()), 0) - 1;
              if (Number >= 0) {
                if (Number >= s->VideoChannels.size())
                  s->VideoChannels.resize(Number + 1);
                s->VideoChannels[Number] = ini->ReadString(n, Values->Strings[j], "");
              }
            }
          }
          */
        } __finally {
          delete Values;
        }

        s->File = ini->ReadString(n, "File", "");
        s->VideoPreview = ini->ReadBool(n, "Video preview", false);
        s->AudioPreview = ini->ReadBool(n, "Audio preview", false);
        s->VideoFormat = ini->ReadInteger(n, "Video format", 0);

        if (s->Type == 0) {
        } else {
          if (!s->FileSource) {
            SetAudioParams(pBuild, s->pCap, ini->ReadInteger(n, "Rate", 44100), ini->ReadInteger(n, "Bits", 16), ini->ReadInteger(n, "Channels", 2));

            Pins pins = GetPins(s->pCap, PINDIR_INPUT);
            AnsiString Input = ini->ReadString(n, "Input", "unknown");
            int Pin = FindPin(pins, Input);

            if (Pin < 0) {
              if (Input != "unknown")
                ShowMessage("Could not find input: " + Input);
            } else
              for (unsigned int i = 0; i < pins.size(); i++) {
                double level, pan;
                bool enabled;
                GetPinParams(pins[Pin], level, pan, enabled);
                enabled = i == Pin;
                if (enabled) {
                  level = ini->ReadFloat(n, "Volume", 1);
                  pan = ini->ReadFloat(n, "Balance", 0);
                }
                SetPinParams(pins[Pin], level, pan, enabled);
              }

            ReleasePins(pins);
          }
        }
      }
    }
  }
  delete nl;
  delete ini;

  ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ComboBoxAudioChange(TObject *Sender) {
  if (!ChangeAudio)
    return;

  if (ListViewSources->Selected == NULL)
    return;
    
  TAVSource *av = (TAVSource*)ListViewSources->Selected->Data;
  if (av == NULL)
    return;

  if (av->Type == 0) {
  } else {
    int rate, bits, chn;
    if (TryStrToInt(ComboBoxRate->Text, rate) &&
        TryStrToInt(ComboBoxBits->Text, bits) &&
        TryStrToInt(ComboBoxChannels->Text, chn))
      SetAudioParams(pBuild, av->pCap, rate, bits, chn);
  }

  ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonRateClick(TObject *Sender) {
  if (ListViewSources->Selected == NULL)
    return;

  TAVSource *av = (TAVSource*)ListViewSources->Selected->Data;
  if (av == NULL)
    return;

  if (FormSampleRate->ShowModal() == mrOk) {
    if (av->Type == 0) {
    }
    else {
      int rate, bits, chn;
      if (TryStrToInt(ComboBoxBits->Text, bits) &&
          TryStrToInt(ComboBoxChannels->Text, chn))
        SetAudioParams(pBuild, av->pCap, FormSampleRate->SampleRate, bits, chn);
    }

    ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ComboBoxInputChange(TObject *Sender) {
  if (!ChangeAudio)
    return;

  if (ListViewSources->Selected == NULL)
    return;

  TAVSource *av = (TAVSource*)ListViewSources->Selected->Data;
  if (av == NULL)
    return;

  Pins pins = GetPins(av->pCap, PINDIR_INPUT);

  double level, pan;
  bool enabled;

  for (unsigned int i = 0; i < pins.size(); i++) {
    GetPinParams(pins[i], level, pan, enabled);
    enabled = i == ComboBoxInput->ItemIndex;
    SetPinParams(pins[i], level, pan, enabled);
  }

  ReleasePins(pins);

  ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::TrackBarVolumeChange(TObject *Sender) {
  if (!ChangeAudio)
    return;

  if (ListViewSources->Selected == NULL)
    return;

  TAVSource *av = (TAVSource*)ListViewSources->Selected->Data;
  if (av == NULL)
    return;

  Pins pins = GetPins(av->pCap, PINDIR_INPUT);

  double level, pan;
  bool enabled;

  for (unsigned int i = 0; i < pins.size(); i++) {
    if (i == ComboBoxInput->ItemIndex) {
      GetPinParams(pins[i], level, pan, enabled);
      if (Sender == TrackBarVolume)
        level = TrackBarVolume->Position / 100.0;
      else if (Sender == TrackBarBalance)
        pan = TrackBarBalance->Position / 50.0;
      SetPinParams(pins[i], level, pan, enabled);
      break;
    }
  }

  ReleasePins(pins);

  ListViewSources->OnSelectItem(ListViewSources, ListViewSources->Selected, true);
}
//---------------------------------------------------------------------------

void TFormMain::Run() {
	if (!Running) {
    LONGLONG Current = 0;
    pMS->SetPositions(&Current, AM_SEEKING_AbsolutePositioning, NULL, AM_SEEKING_NoPositioning);

    AddPreview();
  	for (int i = 0; i < ListViewSources->Items->Count; i++) {
    	TAVSource *s = (TAVSource*)ListViewSources->Items->Item[i]->Data;
    	s->Update();
      if (s->SampleGrabberCB != NULL) {
        s->SampleGrabberCB->Buffers.clear();
        s->SampleGrabberCB->SetDrop(0);
      }
    }
    SetAudioDelay(AudioDelay);
    pAudioServer->InitClients();
		if (pMC->Run() != S_OK) {
	    OAFilterState fs;
    	pMC->GetState(INFINITE, &fs);
    }
  	Running = true;
  }
}
//---------------------------------------------------------------------------

void TFormMain::Stop() {
	if (Running) {
  	pMC->Stop();
    for (int i = 0; i < ListViewSources->Items->Count; i++) {
    	TAVSource *s = (TAVSource*)ListViewSources->Items->Item[i]->Data;
      if (s->SampleGrabberCB != NULL)
      	s->SampleGrabberCB->Buffers.clear();
    }
    RemovePreview();
    Running = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::Button1Click(TObject *Sender) {
	if (Sender == Button1)
  	Run();
  else
		Stop();
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::CheckBoxAudioPreviewClick(TObject *Sender) {
  if (ListViewSources->Selected != NULL) {
    TAVSource *s = ((TAVSource*)(ListViewSources->Selected->Data));
    s->AudioPreview = CheckBoxAudioPreview->Checked;
  }
}
//---------------------------------------------------------------------------

void TFormMain::AddPreview() {
  RemovePreview();
  for (int i = 0; i < ListViewSources->Items->Count; i++) {
    TAVSource *s = ((TAVSource*)(ListViewSources->Items->Item[i]->Data));
    if (s->AudioPreview) {
      if (s->Type != 0) {
#if 1
        AddFilterToGraph(CLSID_Gargle, &s->pAudioDelay, "Audio Delay");
        AddFilterToGraph(CLSID_DSoundRender, &s->pAudioRenderer, "Audio Renderer");
        if (!s->pAudioDelay || !s->pAudioRenderer ||
            !ConnectF2F(&MEDIATYPE_Audio, s->pInfTee, s->pAudioDelay) ||
            !ConnectF2F(&MEDIATYPE_Audio, s->pAudioDelay, s->pAudioRenderer)) {
          SAFE_REMOVE(pGraph, s->pAudioDelay);
          SAFE_REMOVE(pGraph, s->pAudioRenderer);
        }
#else
        AddFilterToGraph(CLSID_SampleGrabber, &s->pAudioDelay, "Audio Delay");
        CComQIPtr<ISampleGrabber, &IID_ISampleGrabber> pGrabber(s->pAudioDelay);
        if (pGrabber) {
          s->SampleGrabberADCB = new TSampleGrabberADCB();
          if (pGrabber->SetBufferSamples(FALSE) !=  S_OK ||
              pGrabber->SetOneShot(FALSE) !=  S_OK ||
              pGrabber->SetCallback(s->SampleGrabberADCB, 1) != S_OK) {
            delete s->SampleGrabberADCB;
            s->SampleGrabberADCB = NULL;
          }
        }

        AddFilterToGraph(CLSID_DSoundRender, &s->pAudioRenderer, "Audio Renderer");
        if (!s->pAudioDelay || !s->pAudioRenderer || !s->SampleGrabberADCB ||
            !ConnectF2F(&MEDIATYPE_Audio, s->pInfTee, s->pAudioDelay) ||
            !ConnectF2F(&MEDIATYPE_Audio, s->pAudioDelay, s->pAudioRenderer)) {
          SAFE_REMOVE(pGraph, s->pAudioDelay);
          SAFE_REMOVE(pGraph, s->pAudioRenderer);
          if (s->SampleGrabberADCB) {
            delete s->SampleGrabberADCB;
            s->SampleGrabberADCB = NULL;
          }
        }
#endif        
      } else {
        AddFilterToGraph(CLSID_ElecardAudio, &s->pPreviewAudioDecoder, "Audio decoder");
        AddFilterToGraph(CLSID_DSoundRender, &s->pAudioRenderer, "Audio Renderer");
        if (!s->pPreviewAudioDecoder || !s->pAudioRenderer ||
            !ConnectF2F(&MEDIATYPE_Audio, s->pMPEG2TSDemux, s->pPreviewAudioDecoder) ||
            !ConnectF2F(&MEDIATYPE_Audio, s->pPreviewAudioDecoder, s->pAudioRenderer)) {
          SAFE_REMOVE(pGraph, s->pAudioRenderer);
          SAFE_REMOVE(pGraph, s->pPreviewAudioDecoder);
        }
      }
    }
  }
}
//---------------------------------------------------------------------------

void TFormMain::RemovePreview() {
  for (int i = 0; i < ListViewSources->Items->Count; i++) {
    TAVSource *s = ((TAVSource*)(ListViewSources->Items->Item[i]->Data));
    SAFE_REMOVE(pGraph, s->pAudioDelay);
    SAFE_REMOVE(pGraph, s->pAudioRenderer);
    SAFE_REMOVE(pGraph, s->pPreviewAudioDecoder);
    if (s->SampleGrabberADCB) {
      delete s->SampleGrabberADCB;
      s->SampleGrabberADCB = NULL;
    }
  }
}
//---------------------------------------------------------------------------

void TFormMain::SetAudioDelay(float Value) {
  if (Value < 0)
    Value = 0;
  AudioDelay = Value;

  for (int i = 0; i < ListViewSources->Items->Count; i++) {
    TAVSource *s = ((TAVSource*)(ListViewSources->Items->Item[i]->Data));
#if 1
    if (s->pAudioDelay) {
      bool OK = false;
      CComQIPtr<IGargle, &IID_IGargle> pGrabber(s->pAudioDelay);
      if (pGrabber) {
        pGrabber->put_DelayLength(Value);
        OK = true;
      }
      if (!OK)
        ShowMessage("Could not set audio delay!");
    }
#else
    if (s->pAudioDelay && s->SampleGrabberADCB) {
      bool OK = false;
      CComQIPtr<ISampleGrabber, &IID_ISampleGrabber> pGrabber(s->pAudioDelay);
      if (pGrabber) {
        AM_MEDIA_TYPE Type;
        if (pGrabber->GetConnectedMediaType(&Type) == S_OK) {
          if (Type.formattype == FORMAT_WaveFormatEx) {
            WAVEFORMATEX *Format = (WAVEFORMATEX*)Type.pbFormat;
            if (Format->wFormatTag == WAVE_FORMAT_PCM) {
              long Delay = Value * Format->nSamplesPerSec * Format->nChannels * Format->wBitsPerSample / 8000.0;
              s->SampleGrabberADCB->SetQueueSize(Delay);
              OK = true;
            }
          }
          FreeMediaType(Type);
        }
      }
      if (!OK)
        ShowMessage("Could not set audio delay!");
    }
#endif
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonFiltersClick(TObject *Sender) {
  IEnumFilters *Enum = NULL;
  if (pGraph->EnumFilters(&Enum) != S_OK) {
    ShowMessage("Could not create enumerator!");
    return;
  }

  TFormFilters *Form = new TFormFilters(this);

  IBaseFilter *pFilter;
  while (Enum->Next(1, &pFilter, NULL) == S_OK) {
    FILTER_INFO Info;
    if (pFilter->QueryFilterInfo(&Info) == S_OK) {
      Form->ListBox1->Items->AddObject(Info.achName, (TObject*)pFilter);
      Info.pGraph->Release();
    } else
      pFilter->Release();
  }

  Form->ShowModal();

  for (int i = 0; i < Form->ListBox1->Items->Count; i++)
    ((IBaseFilter*)Form->ListBox1->Items->Objects[i])->Release();

  delete Form;
  Enum->Release();
}
//---------------------------------------------------------------------------

