//---------------------------------------------------------------------------
#include "dshow_hack.h"
#pragma hdrstop
#include <time.h>
#include "Logging.h"
#include "SampleGrabberCB.h"
#pragma option -VF -VM
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TSampleGrabberCB::TSampleGrabberCB() {
	Drop = Counter = Dropped = 0;
	CS = new TCriticalSection();
}

//---------------------------------------------------------------------------
void TSampleGrabberCB::SetDrop(int Drop) {
	CS->Enter();
  if (Drop < 0)
  	Drop = 0;
  this->Drop = Drop;
  CS->Leave();
}

//---------------------------------------------------------------------------
int TSampleGrabberCB::IncDrop(int Increment) {
	CS->Enter();
  Drop += Increment;
  if (Drop < 0)
  	Drop = 0;
  int Temp = Drop;
  CS->Leave();
  return Temp; 
};

//---------------------------------------------------------------------------
int TSampleGrabberCB::GetDrop() {
	CS->Enter();
  int Temp = Drop;
  CS->Leave();
	return Temp;
}

//---------------------------------------------------------------------------
int TSampleGrabberCB::GetDropped() {
	CS->Enter();
  int Temp = Dropped;
  CS->Leave();
	return Temp;
}

//---------------------------------------------------------------------------
TSampleGrabberCB::~TSampleGrabberCB() {
	delete CS;
}

//---------------------------------------------------------------------------
STDMETHODIMP_(ULONG) TSampleGrabberCB::AddRef() {
  return 2;
}

//---------------------------------------------------------------------------
STDMETHODIMP_(ULONG) TSampleGrabberCB::Release() {
  return 1;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberCB::QueryInterface(REFIID riid, void ** ppv) {
  CheckPointer(ppv, E_POINTER);
  if (riid == IID_ISampleGrabberCB || riid == IID_IUnknown) {
  	*ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
    return NOERROR;
  }
  return E_NOINTERFACE;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberCB::SampleCB(double SampleTime, IMediaSample *pSample) {
	CS->Enter();
	if (Counter >= Drop) {
  	Dropped = Counter;
    BYTE *pBuffer;
    long BufferSize = pSample->GetSize();
    if (pSample->GetPointer(&pBuffer) == S_OK)
  		Buffers.push_back(new TBuffer(SampleTime, pBuffer, BufferSize));
    Counter = 0;
  } else
  	Counter++;
  CS->Leave();
  return 0;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberCB::BufferCB(double SampleTime, BYTE *pBuffer, long BufferSize) {
	CS->Enter();
	if (Counter >= Drop) {
    Dropped = Counter;
		Buffers.push_back(new TBuffer(SampleTime, pBuffer, BufferSize));
    Counter = 0;
  } else
  	Counter++;

  if (BufferSize > 1000000) {
    int Time = 1000.0 * SampleTime;
    Log("SampleGrabberCB", "Time: %d Timestamp: %d", int(1000.0 * clock() / CLK_TCK), Time);
  }

  CS->Leave();
  return 0;
}

