//---------------------------------------------------------------------------
#include "dshow_hack.h"
#pragma hdrstop
#include "SampleGrabberADCB.h"
#pragma option -VF -VM
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TSampleGrabberADCB::TSampleGrabberADCB() {
	CS = new TCriticalSection();
  QueueSize = QueuePos = 0;
  Queue = new BYTE[QueueSize];
}

//---------------------------------------------------------------------------
TSampleGrabberADCB::~TSampleGrabberADCB() {
	delete CS;
  delete[] Queue;
}

//---------------------------------------------------------------------------
void TSampleGrabberADCB::SetQueueSize(long Value) {
	CS->Enter();
  Value = Value & 0xfffffffc;
  if (Value != QueueSize) {
    BYTE *NewQueue = new BYTE[Value];

    memcpy(NewQueue, Queue, min(Value, QueueSize));
    if (Value > QueueSize)
      memset(NewQueue + QueueSize, 0, Value - QueueSize);

    delete[] Queue;

    Queue = NewQueue;
    QueueSize = Value;
    if (QueuePos > QueueSize)
      QueuePos = 0;
  }
  CS->Leave();
}

//---------------------------------------------------------------------------
STDMETHODIMP_(ULONG) TSampleGrabberADCB::AddRef() {
  return 2;
}

//---------------------------------------------------------------------------
STDMETHODIMP_(ULONG) TSampleGrabberADCB::Release() {
  return 1;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberADCB::QueryInterface(REFIID riid, void ** ppv) {
  CheckPointer(ppv, E_POINTER);
  if (riid == IID_ISampleGrabberCB || riid == IID_IUnknown) {
  	*ppv = (void *) static_cast<ISampleGrabberCB*> ( this );
    return NOERROR;
  }
  return E_NOINTERFACE;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberADCB::SampleCB(double SampleTime, IMediaSample *pSample) {
  return 0;
}

//---------------------------------------------------------------------------
STDMETHODIMP TSampleGrabberADCB::BufferCB(double SampleTime, BYTE *pBuffer, long BufferSize) {
  CS->Enter();
  if (QueueSize > 0) {
    BYTE *Actual = new BYTE[BufferSize];
    memcpy(Actual, pBuffer, BufferSize);

    long FromQueue = min(QueueSize, BufferSize);
    if (QueuePos + FromQueue <= QueueSize)
      memcpy(pBuffer, Queue + QueuePos, FromQueue);
    else {
      memcpy(pBuffer, Queue + QueuePos, QueueSize - QueuePos);
      memcpy(pBuffer + QueueSize - QueuePos, Queue, FromQueue - (QueueSize - QueuePos));
    }

    if (FromQueue < BufferSize)
      memcpy(pBuffer + FromQueue, Actual, BufferSize - FromQueue);

    if ((QueuePos + FromQueue) <= QueueSize)
      memcpy(Queue + QueuePos, Actual + (BufferSize - FromQueue), FromQueue);
    else {
      memcpy(Queue + QueuePos, Actual + (BufferSize - FromQueue), QueueSize - QueuePos);
      memcpy(Queue, Actual + (BufferSize - FromQueue) + (QueueSize - QueuePos), FromQueue - (QueueSize - QueuePos));
    }

    QueuePos = (QueuePos + FromQueue) % QueueSize;
    delete[] Actual;
  }
  CS->Leave();
  return 0;
}

