//---------------------------------------------------------------------------
#ifndef MemoryManagerH
#define MemoryManagerH
//---------------------------------------------------------------------------
#include <Windows.h>
#include <vector>
#include <SyncObjs.hpp>

//---------------------------------------------------------------------------
class TMManager {
private:
  TCriticalSection *CS;
  class TBlock {
  public:
    void *Address;
    size_t Size;
  };
  typedef std::vector<TBlock> TBlocks;

  TBlocks FreeBlocks, UsedBlocks;

public:
  TMManager();
  ~TMManager();

  void* GetMem(size_t Size);
  void FreeMem(void *Mem);
  void GC();
};
#endif
