//---------------------------------------------------------------------------
#pragma hdrstop
#include "MemoryManager.h"
#pragma package(smart_init)

//---------------------------------------------------------------------------
TMManager::TMManager() {
  CS = new TCriticalSection();
}

//---------------------------------------------------------------------------
TMManager::~TMManager() {
  if (!UsedBlocks.empty())
    MessageBox(NULL, "Unallocated memory!", "Warning", MB_OK | MB_ICONWARNING);
  for (TBlocks::iterator i = FreeBlocks.begin(); i != FreeBlocks.end(); i++)
    GlobalFree(HGLOBAL(i->Address));
  for (TBlocks::iterator i = UsedBlocks.begin(); i != UsedBlocks.end(); i++)
    GlobalFree(HGLOBAL(i->Address));
  delete CS;
}

//---------------------------------------------------------------------------
void* TMManager::GetMem(size_t Size) {
  CS->Enter();
  for (TBlocks::iterator i = FreeBlocks.begin(); i != FreeBlocks.end(); i++) {
    if (i->Size == Size) {
      UsedBlocks.push_back(*i);
      FreeBlocks.erase(i);
      void *Address = UsedBlocks.back().Address;
      CS->Leave();
      return Address;
    }
  }
  TBlock Block;
  Block.Address = (void*)GlobalAlloc(GMEM_FIXED, Size);
  Block.Size = Size;
  UsedBlocks.push_back(Block);
  CS->Leave();
  return Block.Address;
}

//---------------------------------------------------------------------------
void TMManager::FreeMem(void *Mem) {
  CS->Enter();
  for (TBlocks::iterator i = UsedBlocks.begin(); i != UsedBlocks.end(); i++) {
    if (i->Address == Mem) {
      FreeBlocks.push_back(*i);
      UsedBlocks.erase(i);
      break;
    }
  }
  CS->Leave();
}

//---------------------------------------------------------------------------
void TMManager::GC() {
  CS->Enter();
  for (TBlocks::iterator i = FreeBlocks.begin(); i != FreeBlocks.end(); i++)
    GlobalFree(HGLOBAL(i->Address));
  FreeBlocks.clear();
  CS->Leave();
}

