//---------------------------------------------------------------------------
#ifndef FrameServerH
#define FrameServerH
//---------------------------------------------------------------------------
#include <vector>
#include <Classes.hpp>
#include <SyncObjs.hpp>
#include <Image.h>
#include "ImageFun2.h"

//---------------------------------------------------------------------------
class TAVSource;
class TBuffer;

//---------------------------------------------------------------------------
typedef int (__closure *TFramesCallback)(int Time, ImageStruct *Image, unsigned int Dropped);
typedef int (__closure *TFramesCallback2)(int Time, TBuffer *Buffer, int Width, int Height, unsigned int Dropped);

//---------------------------------------------------------------------------
class TFrameServer: public TThread {
private:
  std::vector<TAVSource*> AVSources;
  std::vector<double> ProcessTimes;
  TCriticalSection *AVSourcesCS, *QualityCS;
  ImageStruct *Image;
  TBuffer *LastBuffer;
  int LastWidth, LastHeight;
  int Time;
  unsigned int Dropped;
  bool HalfHeight;

  TFramesCallback Frames;
  TFramesCallback2 Frames2;        
  void __fastcall SendFrame();
  void __fastcall SendFrame2();
public:
	TFrameServer();
  __fastcall ~TFrameServer();

  void AddAVSource(TAVSource *AVSource);
  void RemoveAVSource(TAVSource *AVSource);

  void __fastcall Execute();
  void SetCallback(TFramesCallback Frames) { this->Frames = Frames; };
  void SetCallback2(TFramesCallback2 Frames2) { this->Frames2 = Frames2; };
  void SetQuality(bool Half);
};
#endif
