//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include <time.h>
#pragma hdrstop
#include "FrameServer.h"
#include "AVSource.h"
#include "SampleGrabberCB.h"
#include "Logging.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TFrameServer::TFrameServer(): TThread(true) {
	FreeOnTerminate = false;
  AVSourcesCS = new TCriticalSection();
  QualityCS = new TCriticalSection();
  Frames = NULL;
  Frames2 = NULL;
  Image = NULL;
  LastBuffer = NULL;
  HalfHeight = false;
}

//---------------------------------------------------------------------------
__fastcall TFrameServer::~TFrameServer() {
  delete AVSourcesCS;
  FREE_IMAGE(Image);
  if (LastBuffer)
    delete LastBuffer;
}

//---------------------------------------------------------------------------
void __fastcall TFrameServer::SendFrame() {
	if (Frames != NULL)
  	Frames(Time, Image, Dropped);
}

//---------------------------------------------------------------------------
void __fastcall TFrameServer::SendFrame2() {
  if (Frames2 != NULL) {
    Frames2(Time, LastBuffer, LastWidth, LastHeight, Dropped);
    LastBuffer = NULL;
  }
}

//---------------------------------------------------------------------------
void __fastcall TFrameServer::Execute() {
	HANDLE EventArray[MAXIMUM_WAIT_OBJECTS];

	while (!Terminated) {
    AVSourcesCS->Enter();
    if (AVSources.size() > 0) {
      for (unsigned int i = 0; i < AVSources.size(); i++)
        EventArray[i] = AVSources[i]->SampleGrabberCB->Buffers.Event;

      int ret = WaitForMultipleObjects(AVSources.size(), EventArray, FALSE, 500);
      if (ret == WAIT_FAILED) {
        AVSourcesCS->Leave();
        break;
      }
      if (ret != WAIT_TIMEOUT) {
        for (unsigned int i = 0; i < AVSources.size(); i++) {
          if (WaitForSingleObject(EventArray[i], 0) == WAIT_OBJECT_0) {
            TAVSource *AVSource = AVSources[i];
            TBuffers &Buffers = AVSource->SampleGrabberCB->Buffers;

            AVSource->SampleGrabberCB->SetDrop(10000000);

            Buffers.Enter();
            if (!Buffers.empty()) {
              TBuffer *Buffer = Buffers.pop_front();
              Dropped = AVSource->SampleGrabberCB->Buffers.size();
              Buffers.clear();
              Buffers.Leave();

              Dropped = AVSource->SampleGrabberCB->GetDropped();

              /*
              if (Dropped > 0)
              	Dropped = AVSource->SampleGrabberCB->IncDrop(Dropped);
              else {
              	Dropped = AVSource->SampleGrabberCB->GetDrop();
                if (Dropped > 0 && ProcessTimes[i] < (Dropped - 0.5) * 40.0) {
	                AVSource->SampleGrabberCB->IncDrop(-1);
                }
              }
              */

							clock_t Start = clock();
              Time = 1000.0 * Buffer->SampleTime;
              unsigned int Height = AVSource->VideoHeight;
              if (HalfHeight)
              	Height /= 2;

              if (Image)
                FREE_IMAGE(Image);
              if (LastBuffer)
                delete LastBuffer;
/*
              if (AVSource->VideoHeight > 0)
                Image = NewImageReferenceExternal(AVSource->VideoWidth, AVSource->VideoHeight, 4, -AVSource->VideoWidth * 4, ImageRGBLinear, Buffer->pBuffer + (AVSource->VideoHeight - 1) * AVSource->VideoWidth * 4, NULL, 0, NULL, NULL);
*/
              LastBuffer = Buffer;
              LastWidth = AVSource->VideoWidth;
              LastHeight = AVSource->VideoHeight;
//              Synchronize(SendFrame);
              Log(AnsiString(this->ClassName()).c_str(), "Time: %d Timestamp: %d", int(1000.0 * clock() / CLK_TCK), Time);
              Synchronize(SendFrame2);
              ProcessTimes[i] = 1000.0 * (clock() - Start) / CLK_TCK;
            } else
          		Buffers.Leave();

            AVSource->SampleGrabberCB->SetDrop(0);
          }
        }
      }
    } else
    	Sleep(500);
    AVSourcesCS->Leave();
  }
}

//---------------------------------------------------------------------------
void TFrameServer::AddAVSource(TAVSource *AVSource) {
	AVSourcesCS->Enter();
	AVSources.push_back(AVSource);
  ProcessTimes.push_back(0);
  AVSourcesCS->Leave();
}

//---------------------------------------------------------------------------
void TFrameServer::RemoveAVSource(TAVSource *AVSource) {
	AVSourcesCS->Enter();
  std::vector<TAVSource*>::iterator i = std::find(AVSources.begin(), AVSources.end(), AVSource);
  if (i != AVSources.end()) {
  	ProcessTimes.erase(ProcessTimes.begin() + (i - AVSources.begin()));
  	AVSources.erase(i);
  }
  AVSourcesCS->Leave();
}

//---------------------------------------------------------------------------
void TFrameServer::SetQuality(bool Half) {
	QualityCS->Enter();
  HalfHeight = Half;
  QualityCS->Leave();
}

