//---------------------------------------------------------------------------
#ifndef BuffersH
#define BuffersH

//---------------------------------------------------------------------------
#include <deque>
#include <SyncObjs.hpp>
#include "MemoryManager.h"

//---------------------------------------------------------------------------
class TBuffer {
private:
  void* GetMem(size_t Size);
  void FreeMem(void *Mem);
public:
  static TMManager *MemoryManager;

  double SampleTime;
  BYTE *pBuffer;
  long BufferSize;
  TBuffer();
  TBuffer(double SampleTime, BYTE *pBuffer, long BufferSize);
  TBuffer(const TBuffer &Buffer);
  ~TBuffer();
	TBuffer& operator =(TBuffer& Buffer);
  TBuffer& operator =(TBuffer Buffer);
};

//---------------------------------------------------------------------------
class TBuffers {
private:
	TCriticalSection *CS;
  std::deque<TBuffer*> Buffers;
public:
	HANDLE Event;
  TBuffers();
  ~TBuffers();
  void push_back(TBuffer *Buffer);
  TBuffer* pop_front();
  TBuffer* pop_back();
  void clear();
  bool empty();
  size_t size();
  void Enter();
  void Leave();
};
#endif
