//---------------------------------------------------------------------------
#pragma hdrstop
#include "Buffers.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TMManager *TBuffer::MemoryManager = NULL;

//---------------------------------------------------------------------------
TBuffer::TBuffer() {
	SampleTime = 0;
  pBuffer = NULL;
  BufferSize = 0;
}

//---------------------------------------------------------------------------
TBuffer::TBuffer(double SampleTime, BYTE *pBuffer, long BufferSize) {
	this->SampleTime = SampleTime;
  this->BufferSize = BufferSize;
  this->pBuffer = (BYTE*)GetMem(BufferSize);
  memcpy(this->pBuffer, pBuffer, BufferSize);
}

//---------------------------------------------------------------------------
TBuffer::TBuffer(const TBuffer &Buffer) {
	SampleTime = Buffer.SampleTime;
  BufferSize = Buffer.BufferSize;
  if (Buffer.pBuffer) {
  	pBuffer = (BYTE*)GetMem(Buffer.BufferSize);
    memcpy(pBuffer, Buffer.pBuffer, Buffer.BufferSize);
  } else
  	pBuffer = NULL;
}

//---------------------------------------------------------------------------
TBuffer& TBuffer::operator =(TBuffer& Buffer) {
	SampleTime = Buffer.SampleTime;
  BufferSize = Buffer.BufferSize;
  if (pBuffer) {
  	FreeMem(pBuffer);
    pBuffer = NULL;
  }
  if (Buffer.pBuffer) {
  	pBuffer = (BYTE*)GetMem(Buffer.BufferSize);
    memcpy(pBuffer, Buffer.pBuffer, Buffer.BufferSize);
  } else
  	pBuffer = NULL;
	return *this;
}

//---------------------------------------------------------------------------
TBuffer& TBuffer::operator =(TBuffer Buffer) {
	SampleTime = Buffer.SampleTime;
  BufferSize = Buffer.BufferSize;
  if (pBuffer) {
  	FreeMem(pBuffer);
    pBuffer = NULL;
  }
  if (Buffer.pBuffer) {
  	pBuffer = (BYTE*)GetMem(Buffer.BufferSize);
    memcpy(pBuffer, Buffer.pBuffer, Buffer.BufferSize);
  } else
  	pBuffer = NULL;
	return *this;
}

//---------------------------------------------------------------------------
TBuffer::~TBuffer() {
	if (pBuffer)
  	FreeMem(pBuffer);
}

//---------------------------------------------------------------------------
void* TBuffer::GetMem(size_t Size) {
  if (MemoryManager)
    return (void*)MemoryManager->GetMem(Size);
  else
    return (void*)GlobalAlloc(GMEM_FIXED, Size);
}

//--------------------------------------------------------------------------
void TBuffer::FreeMem(void *Mem) {
  if (MemoryManager)
    MemoryManager->FreeMem(Mem);
  else
    GlobalFree(HGLOBAL(Mem));
}


//---------------------------------------------------------------------------
TBuffers::TBuffers() {
	Event = CreateEvent(NULL, TRUE, FALSE, NULL);
  if (Event == NULL)
  	throw Exception("CreateEvent failed!"); 
  CS = new TCriticalSection();
}

//---------------------------------------------------------------------------
TBuffers::~TBuffers() {
	clear();
  CloseHandle(Event);
  delete CS;
}

//---------------------------------------------------------------------------
void TBuffers::clear() {
	CS->Enter();
  while (!Buffers.empty()) {
  	delete Buffers.front();
  	Buffers.pop_front();
  }
  ResetEvent(Event);
  CS->Leave();
}

//---------------------------------------------------------------------------
void TBuffers::push_back(TBuffer *Buffer) {
	CS->Enter();
  Buffers.push_back(Buffer);
  SetEvent(Event);
  CS->Leave();
}

//---------------------------------------------------------------------------
TBuffer* TBuffers::pop_front() {
  CS->Enter();
  TBuffer *Buffer = Buffers.front();
  Buffers.pop_front();
  if (Buffers.empty())
  	ResetEvent(Event);
  CS->Leave();
	return Buffer;
}

//---------------------------------------------------------------------------
TBuffer* TBuffers::pop_back() {
  CS->Enter();
  TBuffer *Buffer = Buffers.back();
  Buffers.pop_back();
  if (Buffers.empty())
  	ResetEvent(Event);
  CS->Leave();
	return Buffer;
}

//---------------------------------------------------------------------------
bool TBuffers::empty() {
	CS->Enter();
	bool Empty = Buffers.empty();
  CS->Leave();
	return Empty;
}

//---------------------------------------------------------------------------
size_t TBuffers::size() {
	CS->Enter();
	size_t Size = Buffers.size();
  CS->Leave();
	return Size;
}

//---------------------------------------------------------------------------
void TBuffers::Enter() {
	CS->Enter();
}

//---------------------------------------------------------------------------
void TBuffers::Leave() {
	CS->Leave();
}
