//---------------------------------------------------------------------------
#ifndef AudioServerH
#define AudioServerH
//---------------------------------------------------------------------------
#include <string>
#include <vector>
#include <Classes.hpp>
#include <SyncObjs.hpp>
//---------------------------------------------------------------------------
#define MAXIMSG 1024

//---------------------------------------------------------------------------
class TAVSource;
typedef int (__closure *TResultsCallback)(int Time, unsigned int Length, char *Data);
typedef int (__closure *TResultsCallback2)(unsigned char Message, void *Data, unsigned int Length);

//---------------------------------------------------------------------------
class TAudioServer: public TThread {
private:
	int Socket;
  bool Connected;
  bool Init;

	struct Connection {
    int Socket;
    bool Disconect;
    unsigned int State, Cnt;
    int Time;
    unsigned int Length;
    char *Data;
    unsigned char Message;
  };
  std::vector<Connection> Connections;

  std::vector<TAVSource*> AVSources;
  TCriticalSection *AVSourcesCS, *AVSourcesCS2;

  TResultsCallback Results;
  TResultsCallback2 Results2;

  int LastTime;

  int Select(int Wait);
  int Read(int Index);
  void __fastcall SendResults();
  int SendWave(int Time, unsigned int Source, unsigned int Rate, unsigned int Channels, unsigned int Length, char *Data);
  int SendInit();
public:
  TAudioServer();
  __fastcall ~TAudioServer();

  int Connect(unsigned int inaddr, unsigned short port);
  void Disconnect();

  void AddAVSource(TAVSource *AVSource);
  void RemoveAVSource(TAVSource *AVSource);

  void __fastcall Execute();
  void SetCallback(TResultsCallback Results) { this->Results = Results; };
  void SetCallback2(TResultsCallback2 Results2) { this->Results2 = Results2; };
  void InitClients();

  int GetLastTime();
};
#endif
