//---------------------------------------------------------------------------
#include "dshow_hack.h"
#include <winsock2.h>
#include <algorithm>
#include <time.h>
#pragma hdrstop
#include "SampleGrabberADCB.h"
#include "AudioServer.h"
#include "AVSource.h"
#include "SampleGrabberCB.h"
#include "TCPMessages.h"
#include "Logging.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TAudioServer::TAudioServer(): TThread(true) {
	FreeOnTerminate = false;
	Connected = false;
  WSADATA WSAData;
	if (WSAStartup(MAKEWORD(2, 2), &WSAData) != 0)
  	throw Exception("WSAStartup failed!");
  AVSourcesCS = new TCriticalSection();
  AVSourcesCS2 = new TCriticalSection();
  Results = NULL;
  Init = false;
  LastTime = 0;
}

//---------------------------------------------------------------------------
__fastcall TAudioServer::~TAudioServer() {
	Disconnect();
  WSACleanup();
  delete AVSourcesCS;
  delete AVSourcesCS2;
}

//---------------------------------------------------------------------------
int TAudioServer::Connect(unsigned int inaddr, unsigned short port) {
	Disconnect();

  Socket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (Socket < 0)
  	return 1;

  struct sockaddr_in name;
  name.sin_family = AF_INET;
  name.sin_port = htons(port);
  name.sin_addr.s_addr = htonl(inaddr);
  if (bind(Socket, (struct sockaddr *) &name, sizeof(name)) != 0) {
  	closesocket(Socket);
    return 2;
  }

  if (listen(Socket, 1) != 0) {
  	closesocket(Socket);
    return 2;
  }

	Connected = true;
	return 0;
}

//---------------------------------------------------------------------------
void TAudioServer::Disconnect() {
	if (Connected) {
    for (unsigned int i=0; i<Connections.size(); i++) {
    	closesocket(Connections[i].Socket);
      if (Connections[i].Data)
      	delete[] Connections[i].Data;
    }
    Connections.clear();
    closesocket(Socket);
  	Connected = false;
  }
}

//---------------------------------------------------------------------------
int TAudioServer::Select(int Wait) {
  fd_set read_fd_set;
  FD_ZERO(&read_fd_set);
  FD_SET(Socket, &read_fd_set);

  for (unsigned int i = 0; i < Connections.size(); i++)
    FD_SET(Connections[i].Socket, &read_fd_set);

  struct sockaddr_in clientname;
	struct timeval tv;
  tv.tv_sec = Wait / 1000;
  tv.tv_usec = (Wait % 1000) * 1000;

  int retval = select(FD_SETSIZE, &read_fd_set, NULL, NULL, (Wait < 0) ? NULL : &tv);
  if (retval <= 0)
    return retval;

  // pripojeni noveho klienta
  if (FD_ISSET(Socket, &read_fd_set)) {
    int size = sizeof(clientname);
    int NewSocket = accept(Socket, (struct sockaddr *) &clientname, &size);
    if (NewSocket >= 0)
      if (Connections.empty()) {
        Connection Con;
        Con.Socket = NewSocket;
        Con.State = Con.Cnt = 0;
        Con.Data = NULL;
        Con.Disconect = false;
        Connections.push_back(Con);
      } else {
        closesocket(NewSocket);
      }
  }

  // obsluha pozadavku od klientu
  for (unsigned int i = 0; i < Connections.size(); i++)
    if (FD_ISSET(Connections[i].Socket, &read_fd_set) && !Connections[i].Disconect)
      if (Read(i) < 0)
        Connections[i].Disconect = true;

  // odpojeni klientu
  for (unsigned int i = 0; i < Connections.size();)
    if (Connections[i].Disconect) {
      closesocket(Connections[i].Socket);
      if (Connections[i].Data)
      	delete[] Connections[i].Data;
      Connections.erase(Connections.begin() + i);
    } else
      i++;

  return retval;
}

//---------------------------------------------------------------------------
int TAudioServer::Read(int Index) {
  char buffer[MAXIMSG];
  Connection &Con = Connections[Index];
  int nbytes = recv(Con.Socket, buffer, MAXIMSG, 0);

  if (nbytes <= 0)
    return -1;
  else {
    int i=0;
    while (i < nbytes) {
    	char b = buffer[i];
    	switch (Con.State) {
        case 0:
          Con.Message = (unsigned char)b;
          if (Con.Message == CLN_OLD)
            Con.State = 100;
          else
            Con.State = 200;
          break;

        case 200:
          ((char*)&Con.Length)[Con.Cnt++] = b;
      		if (Con.Cnt == sizeof(Con.Length)) {
          	Con.Cnt = 0;
          	Con.State++;
            Con.Data = new char[Con.Length];
            if (Con.Cnt == Con.Length) {
              Synchronize(SendResults);
              Con.State = Con.Cnt = 0;
              delete[] Con.Data;
              Con.Data = NULL;
            }
          }
          break;

  			case 201:
        	Con.Data[Con.Cnt++] = b;
          if (Con.Cnt == Con.Length) {
          	Synchronize(SendResults);
          	Con.State = Con.Cnt = 0;
            delete[] Con.Data;
            Con.Data = NULL;
          }
          break;


			 	case 100:
        	((char*)&Con.Time)[Con.Cnt++] = b;
      		if (Con.Cnt == sizeof(Con.Time)) {
          	Con.Cnt = 0;
          	Con.State = 1;
          }
          break;

			 	case 1:
        	((char*)&Con.Length)[Con.Cnt++] = b;
      		if (Con.Cnt == sizeof(Con.Length)) {
          	Con.Cnt = 0;
          	Con.State++;
            Con.Data = new char[Con.Length];
            if (Con.Cnt == Con.Length) {
              Synchronize(SendResults);
              Con.State = Con.Cnt = 0;
              delete[] Con.Data;
              Con.Data = NULL;
            }
          }
          break;

				case 2:
        	Con.Data[Con.Cnt++] = b;
          if (Con.Cnt == Con.Length) {
          	Synchronize(SendResults);
          	Con.State = Con.Cnt = 0;
            delete[] Con.Data;
            Con.Data = NULL;
          }
          break;

      	default:
      		if (Con.Data)
          	delete[] Con.Data;
        	Con.State = Con.Cnt = 0;
          Con.Data = NULL;
          break;
      }
      i++;
    }
    return 0;
  }
}

//---------------------------------------------------------------------------
int TAudioServer::SendInit() {
	if (!Connected)
  	return 1;

  for (unsigned int i = 0; i < Connections.size(); i++) {
    char Msg = SRV_INIT;
    if (send(Connections[i].Socket, &Msg, sizeof(Msg), 0) != sizeof(Msg))
      return 2;
  }
  return 0;
}

//---------------------------------------------------------------------------
int TAudioServer::SendWave(int Time, unsigned int Source, unsigned int Rate, unsigned int Channels, unsigned int Length, char *Data) {
	if (!Connected)
  	return 1;

  for (unsigned int i = 0; i < Connections.size(); i++) {
    char Msg = SRV_DATA;
    if (send(Connections[i].Socket, &Msg, sizeof(Msg), 0) != sizeof(Msg))
      return 8;
    if (send(Connections[i].Socket, (char*)&Time, sizeof(Time), 0) != sizeof(Time))
    	return 2;
    if (send(Connections[i].Socket, (char*)&Source, sizeof(Source), 0) != sizeof(Source))
    	return 3;
    if (send(Connections[i].Socket, (char*)&Rate, sizeof(Rate), 0) != sizeof(Rate))
  		return 4;
    if (send(Connections[i].Socket, (char*)&Channels, sizeof(Channels), 0) != sizeof(Channels))
    	return 5;
    if (send(Connections[i].Socket, (char*)&Length, sizeof(Length), 0) != sizeof(Length))
    	return 6;
    if (send(Connections[i].Socket, Data, Length, 0) != (int)Length)
    	return 7;
  }
  return 0;
}

//---------------------------------------------------------------------------
void __fastcall TAudioServer::SendResults() {
  for (unsigned int i = 0; i < Connections.size(); i++) {
    Connection &Con = Connections[i];
    if (Results != NULL && Con.State == 2 && Con.Cnt == Con.Length)
      Results(Con.Time, Con.Length, Con.Data);

    if (Results2 != NULL && Con.State == 201 && Con.Cnt == Con.Length)
      Results2(Con.Message, Con.Data, Con.Length);
  }
}

//---------------------------------------------------------------------------
void __fastcall TAudioServer::Execute() {
  WSAEVENT EventArray[WSA_MAXIMUM_WAIT_EVENTS];
  EventArray[0] = WSACreateEvent();

	while (!Terminated) {
  	int Count = 1;
    AVSourcesCS->Enter();
    for (unsigned int i = 0; i < AVSources.size(); i++) {
    	EventArray[Count] = AVSources[i]->SampleGrabberCB->Buffers.Event;
    	Count++;
    }

    WSAEventSelect(Socket, EventArray[0], FD_READ|FD_ACCEPT);
    for (unsigned int i = 0; i < Connections.size(); i++)
    	WSAEventSelect(Connections[i].Socket, EventArray[0], FD_READ|FD_CLOSE);

  	int ret = WSAWaitForMultipleEvents(Count, EventArray, FALSE, 500, FALSE);
    if (ret == WSA_WAIT_FAILED) {
    	AVSourcesCS->Leave();
    	break;
    }
    if (ret != WSA_WAIT_TIMEOUT) {
    	WSAEventSelect(Socket, NULL, 0);
      unsigned long p = 0;
      ioctlsocket(Socket, FIONBIO, &p);

    	if (WaitForSingleObject(EventArray[0], 0) == WAIT_OBJECT_0) {
        WSAResetEvent(EventArray[0]);
        if (Select(0) < 0) {
        	AVSourcesCS->Leave();
          break;
        }
      }

      for (unsigned int i = 0; i < Connections.size(); i++) {
    		WSAEventSelect(Connections[i].Socket, NULL, 0);
        unsigned long p = 0;
        ioctlsocket(Connections[i].Socket, FIONBIO, &p);
      }

      if (Init) {
        SendInit();
        Init = false;
      }

      for (int i = 1; i < Count; i++) {
      	if (WaitForSingleObject(EventArray[i], 0) == WAIT_OBJECT_0) {
        	TAVSource *AVSource = AVSources[i - 1];
          TBuffers &Buffers = AVSource->SampleGrabberCB->Buffers;

          Buffers.Enter();
          if (!Buffers.empty()) {
          	TBuffer *Buffer = Buffers.pop_front();
            Buffers.Leave();
            AVSourcesCS2->Enter();
            LastTime = 1000.0 * Buffer->SampleTime;
            AVSourcesCS2->Leave();
            Log(AnsiString(this->ClassName()).c_str(), "Time: %d Timestamp: %d Source: %d", int(1000.0 * clock() / CLK_TCK), int(1000.0 * Buffer->SampleTime), i);
            SendWave(1000.0 * Buffer->SampleTime, i - 1, AVSource->AudioRate, AVSource->AudioChannels, Buffer->BufferSize, Buffer->pBuffer);
            delete Buffer;
          } else
          	Buffers.Leave();
        }
      }
    }
    AVSourcesCS->Leave();
  }
  WSACloseEvent(EventArray[0]);
}

//---------------------------------------------------------------------------
int TAudioServer::GetLastTime() {
  int t;
	AVSourcesCS2->Enter();
	t = LastTime;
  AVSourcesCS2->Leave();
  return t;
}

//---------------------------------------------------------------------------
void TAudioServer::AddAVSource(TAVSource *AVSource) {
	AVSourcesCS->Enter();
	AVSources.push_back(AVSource);
  AVSourcesCS->Leave();
}

//---------------------------------------------------------------------------
void TAudioServer::RemoveAVSource(TAVSource *AVSource) {
	AVSourcesCS->Enter();
  std::vector<TAVSource*>::iterator i = std::find(AVSources.begin(), AVSources.end(), AVSource);
  if (i != AVSources.end())
  	AVSources.erase(i);
  AVSourcesCS->Leave();
}

//---------------------------------------------------------------------------
void TAudioServer::InitClients() {
	AVSourcesCS->Enter();
  Init = true;
  AVSourcesCS->Leave();
}

