//---------------------------------------------------------------------------
#ifndef AVSourceH
#define AVSourceH
//---------------------------------------------------------------------------
#include "DSTools.h"
#pragma option push -VF -VM
//---------------------------------------------------------------------------
class TSampleGrabberCB;
class TSampleGrabberADCB;

//---------------------------------------------------------------------------
class TAVSource {
public:
  int Type;
  int VideoFormat;
  AnsiString File;
  bool VideoPreview, AudioPreview, FileSource;
//  std::vector<TFrame*> PreviewFrames;
//  std::vector<AnsiString> AudioChannels;
//  std::vector<AnsiString> VideoChannels;
//  TIBaseFilters VideoPreviewFilters, VideoPreviewFilters2, AudioPreviewFilters;

	IBaseFilter *pCap;
  IBaseFilter *pDVSplit;
  IBaseFilter *pInfTee;
  IBaseFilter *pAudioDelay;
  IBaseFilter *pInfTeeAudio;
  IBaseFilter *pAVIMux;
  IBaseFilter *pFileWriter;
  IBaseFilter *pDVDecoder;
  IBaseFilter *pVideoRenderer;
  IBaseFilter *pScope;
  IBaseFilter *pAudioRenderer;
  IBaseFilter *pDVDecoder2;
  IBaseFilter *pVideoRenderer2;

  IBaseFilter *pMPEG2TSDemux;
  IBaseFilter *pMPEG2TSDemux2;
  IBaseFilter *pMPEG2TSDemux3;

  IBaseFilter *pMPEG2TSOutputDemux;

  IBaseFilter *pWAVEDst;

  IBaseFilter *pSampleGrabber;
  IBaseFilter *pNullRenderer;

  IBaseFilter *pPreviewAudioDecoder;

  TSampleGrabberCB *SampleGrabberCB;
  TSampleGrabberADCB *SampleGrabberADCB;
  unsigned int AudioRate, AudioBits, AudioChannels, VideoWidth, VideoHeight;

  void Init() {
    FileSource = false;

    pCap = NULL;
    pDVSplit = NULL;
    pInfTee = NULL;
    pInfTeeAudio = NULL;
    pAVIMux = NULL;
    pFileWriter = NULL;
    pDVDecoder = NULL;
    pVideoRenderer = NULL;
    pScope = NULL;
    pAudioRenderer = NULL;
    pDVDecoder2 = NULL;
    pVideoRenderer2 = NULL;

    pMPEG2TSDemux = NULL;
    pMPEG2TSDemux2 = NULL;
    pMPEG2TSDemux3 = NULL;

    pWAVEDst = NULL;

  	pSampleGrabber = NULL;
  	pNullRenderer = NULL;

    pMPEG2TSOutputDemux = NULL;
    SampleGrabberCB = NULL;
    SampleGrabberADCB = NULL;

    pPreviewAudioDecoder = NULL;
    pAudioDelay = NULL;
  };

  void Release(IGraphBuilder *pGraph) {
    SAFE_REMOVE(pGraph, pCap);
    SAFE_REMOVE(pGraph, pDVSplit);
    SAFE_REMOVE(pGraph, pInfTee);
    SAFE_REMOVE(pGraph, pInfTeeAudio);
    SAFE_REMOVE(pGraph, pAVIMux);
    SAFE_REMOVE(pGraph, pFileWriter);
    SAFE_REMOVE(pGraph, pDVDecoder);
    SAFE_REMOVE(pGraph, pVideoRenderer);
    SAFE_REMOVE(pGraph, pScope);
    SAFE_REMOVE(pGraph, pAudioRenderer);
    SAFE_REMOVE(pGraph, pDVDecoder2);
    SAFE_REMOVE(pGraph, pVideoRenderer2);

    SAFE_REMOVE(pGraph, pMPEG2TSDemux);
    SAFE_REMOVE(pGraph, pMPEG2TSDemux2);
    SAFE_REMOVE(pGraph, pMPEG2TSDemux3);

    SAFE_REMOVE(pGraph, pWAVEDst);
  	SAFE_REMOVE(pGraph, pSampleGrabber);
  	SAFE_REMOVE(pGraph, pNullRenderer);

    SAFE_REMOVE(pGraph, pMPEG2TSOutputDemux);
    SAFE_REMOVE(pGraph, pAudioDelay);

    SAFE_REMOVE(pGraph, pPreviewAudioDecoder);

    if (SampleGrabberCB)
    	delete SampleGrabberCB;
    if (SampleGrabberADCB)
      delete SampleGrabberADCB;
  }

  void Update();
};
#pragma option pop
#endif
