//---------------------------------------------------------------------------
#ifndef FrameQueueH
#define FrameQueueH
//---------------------------------------------------------------------------
#include <deque>
#include "Image.h"
#include "Buffers.h"
#include "MemoryManager.h"

#ifdef TRACKER_DLL
#include "MountDllTracker.h"
#else
#include "tracker.h"
#endif

#define PERSON_COUNT 4
#define TRACKER_OBJECT_COUNT 100

//---------------------------------------------------------------------------
class TFrameBuffer {
private:
  void* GetMem(size_t Size);
  void FreeMem(void *Mem);
public:
  static TMManager *MemoryManager;

  TBuffer *Buffer;
  ImageStruct *Image, *Image2, *Gray, *Trans, *Persons[PERSON_COUNT];
  int Time;

  TResult TrackerObjects[PERSON_COUNT][TRACKER_OBJECT_COUNT];
  int TrackerObjectsCount[PERSON_COUNT];

  TFrameBuffer(TBuffer *Buffer, int Width, int Height, int Time);
  ~TFrameBuffer();

  ImageStruct* AllocImageRGB(int Width, int Height);
  ImageStruct* AllocImage8(int Width, int Height);
  void FreeImageRGB(ImageStruct *Image);
  void FreeImage8(ImageStruct *Image);
};

//---------------------------------------------------------------------------
class TFrameQueue {
private:
  std::deque<TFrameBuffer*> Buffers;
public:
  void push_back(TFrameBuffer *Buffer);
  TFrameBuffer* pop_front();
  TFrameBuffer* back();
  TFrameBuffer* at(size_t n);
  size_t size();
  void clear(); 
};
#endif
