//---------------------------------------------------------------------------
#pragma hdrstop
#include "FrameQueue.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
TMManager *TFrameBuffer::MemoryManager = NULL;

//---------------------------------------------------------------------------
TFrameBuffer::TFrameBuffer(TBuffer *Buffer, int Width, int Height, int Time) {
  this->Buffer = Buffer;
  Image = NewImageReferenceExternal(Width, Height, 4, -Width * 4, ImageRGBLinear, Buffer->pBuffer + (Height - 1) * Width * 4, NULL, 0, NULL, NULL);
  this->Time = Time;
  Trans = NULL;
  Gray = NULL;

  Image2 = NewImageReference(Image, Image->XSize / 2 - Image->YSize / 2, 0, Image->YSize, Image->YSize);
//  Image2 = NewImageReference(Image, 0, 0, Image->XSize, Image->YSize);

  for (int i = 0; i < PERSON_COUNT; i++) {
    Persons[i] = NULL;
    TrackerObjectsCount[i] = 0;
  }
}

//---------------------------------------------------------------------------
TFrameBuffer::~TFrameBuffer() {
  for (int i = 0; i < PERSON_COUNT; i++)
    DeleteImage(Persons[i]);

  DeleteImage(Image2);
  DeleteImage(Image);
  delete Buffer;
  if (Trans)
    FreeImageRGB(Trans);
  if (Gray)
    FreeImage8(Gray);
}

//---------------------------------------------------------------------------
void* TFrameBuffer::GetMem(size_t Size) {
  if (MemoryManager)
    return (void*)MemoryManager->GetMem(Size);
  else
    return (void*)GlobalAlloc(GMEM_FIXED, Size);
}

//--------------------------------------------------------------------------
void TFrameBuffer::FreeMem(void *Mem) {
  if (MemoryManager)
    MemoryManager->FreeMem(Mem);
  else
    GlobalFree(HGLOBAL(Mem));
}


//--------------------------------------------------------------------------
ImageStruct* TFrameBuffer::AllocImageRGB(int Width, int Height) {
  char *Raster = (char*)GetMem(4 * Width * Height);
  if (Raster)
    return NewImageReferenceExternal(Width, Height, 4, -Width * 4, ImageRGBLinear, Raster + (Height - 1) * Width * 4, NULL, 0, NULL, NULL);
  else
    return NULL;
}

//--------------------------------------------------------------------------
ImageStruct* TFrameBuffer::AllocImage8(int Width, int Height) {
  char *Raster = (char*)GetMem(Width * Height);
  if (Raster)
    return NewImageReferenceExternal(Width, Height, 1, Width, ImageRGBLinear, Raster, NULL, 0, NULL, NULL);
  else
    return NULL;
}

//--------------------------------------------------------------------------
void TFrameBuffer::FreeImageRGB(ImageStruct *Image) {
  char *Raster = Image->Raster - + (Image->YSize - 1) * Image->XSize * 4;
  DeleteImage(Image);
  FreeMem(Raster);
}

//--------------------------------------------------------------------------
void TFrameBuffer::FreeImage8(ImageStruct *Image) {
  char *Raster = Image->Raster;
  DeleteImage(Image);
  FreeMem(Raster);
}

//---------------------------------------------------------------------------
void TFrameQueue::push_back(TFrameBuffer *Buffer) {
  Buffers.push_back(Buffer);
}

//---------------------------------------------------------------------------
TFrameBuffer* TFrameQueue::pop_front() {
  TFrameBuffer *Buffer = Buffers.front();
  Buffers.pop_front();
  return Buffer;
}

//---------------------------------------------------------------------------
TFrameBuffer* TFrameQueue::back() {
  return Buffers.back();
}

//---------------------------------------------------------------------------
TFrameBuffer* TFrameQueue::at(size_t n) {
  return Buffers.at(n); 
}

//---------------------------------------------------------------------------
size_t TFrameQueue::size() {
  return Buffers.size();
}

//---------------------------------------------------------------------------
void TFrameQueue::clear() {
  while (!Buffers.empty()) {
  	delete Buffers.front();
  	Buffers.pop_front();
  }
}

