//---------------------------------------------------------------------------
#include <vcl.h>
#include <vfw.h>
#pragma hdrstop
#include "DDImageControl.h"
#pragma package(smart_init)

//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void ValidCtrCheck(TDDImageControl *)
{
  new TDDImageControl(NULL);
}

//---------------------------------------------------------------------------
const int InfoPosX = 8;
const int InfoPosY = 8;

//---------------------------------------------------------------------------
__fastcall TDDImageControl::TDDImageControl(TComponent* Owner): TGraphicControl(Owner)
{
  ControlStyle<<csOpaque;
  hdd = DrawDibOpen();
  FImage = NULL;
  FShowInfo = false;
}

//---------------------------------------------------------------------------
__fastcall TDDImageControl::~TDDImageControl() {
  if (hdd)
    DrawDibClose(hdd);
}

//---------------------------------------------------------------------------
void __fastcall TDDImageControl::SetImage(ImageStruct *Value) {
  FImage = Value;
  Invalidate();
}

//---------------------------------------------------------------------------
void __fastcall TDDImageControl::SetShowInfo(bool Value) {
	FShowInfo = Value;
  Invalidate();
}

//---------------------------------------------------------------------------
void __fastcall TDDImageControl::Paint() {
  if (FImage && FImage->PixelType == ImageRGBLinear) {
    char *Raster;
    int XOffset = 0;
    if (FImage->Optional.Reference.Referenced) {
      if (FImage->Optional.Reference.Referenced->YOffset < 0)
        Raster = FImage->Optional.Reference.Referenced->Raster + (FImage->Optional.Reference.Referenced->YSize - 1) * FImage->Optional.Reference.Referenced->YOffset;
      else
        Raster = FImage->Optional.Reference.Referenced->Raster;
      XOffset = (FImage->Raster - FImage->Optional.Reference.Referenced->Raster) / 4;
    } else {
      if (FImage->YOffset < 0)
        Raster = FImage->Raster + (FImage->YSize - 1) * FImage->YOffset;
      else
        Raster = FImage->Raster;
    }

    BITMAPINFOHEADER h;
    h.biSize = sizeof(h);
    h.biWidth = abs(FImage->YOffset / 4);
    h.biHeight = FImage->YSize;
    h.biPlanes = 1;
    h.biBitCount = 32;
    h.biCompression = BI_RGB;
    h.biSizeImage = 0;
    h.biXPelsPerMeter = 0;
    h.biYPelsPerMeter = 0;
    h.biClrUsed = 0;
    h.biClrImportant = 0;

    DrawDibDraw(hdd, Canvas->Handle, 0, 0, Width, Height, &h, Raster, XOffset, 0, FImage->XSize, FImage->YSize, 0);

    if (FShowInfo) {
    	AnsiString Info;
      Info.printf("%dx%d", FImage->XSize, FImage->YSize);
      Canvas->Brush->Style = bsClear;
      Canvas->Font->Style = TFontStyles()<<fsBold;
      Canvas->Font->Name = "Arial";
  		Canvas->Font->Size = 12;
      Canvas->Font->Color = clWhite;
      Canvas->TextOut(InfoPosX - 1, InfoPosY - 1, Info);
      Canvas->TextOut(InfoPosX + 1, InfoPosY - 1, Info);
      Canvas->TextOut(InfoPosX - 1, InfoPosY + 1, Info);
      Canvas->TextOut(InfoPosX + 1, InfoPosY + 1, Info);
      Canvas->Font->Color = clBlack;
      Canvas->TextOut(InfoPosX, InfoPosY, Info);
    }
  } else {
    Canvas->Brush->Style = bsSolid;
    Canvas->Brush->Color = clRed;
    Canvas->FillRect(Canvas->ClipRect);
  }
  if (FOnPaint)
    FOnPaint(this);
}

//---------------------------------------------------------------------------
namespace Ddimagecontrol {
  void __fastcall PACKAGE Register() {
     TComponentClass classes[1] = {__classid(TDDImageControl)};
     RegisterComponents("AMI", classes, 0);
  }
}
//---------------------------------------------------------------------------

