#ifndef CUDA_NONNEGATIVE_TENSOR_FACTORIZATION_H
#define CUDA_NONNEGATIVE_TENSOR_FACTORIZATION_H

extern "C" {

//Initial value specification
typedef enum cuntfInit_t
{
    CUNTF_INIT_COPY,//initial values are passed in U, V and W arrays
    CUNTF_INIT_RAND//initial values are generated randomly in the interval <0, 1>
} cuntfInit;
    
typedef enum cuntfResult_t
{
    CUNTF_SUCCESS = 0,
    CUNTF_ALLOC_FAILED,
    CUNTF_ERROR
} cuntfResult;

cuntfResult cuntfFloat(
        const float * G,//input array float[R*S*T]
        const unsigned R, const unsigned S, const unsigned T,//tensor dimensions
        const unsigned rank, const unsigned iterations, const cuntfInit init,
        float * U, float * V, float * W//output arrays float[R*rank] float[S*rank] float[T*rank]
        );

cuntfResult cuntfDouble(
        const double * G,
        const unsigned R, const unsigned S, const unsigned T,
        const unsigned rank, const unsigned iterations, const cuntfInit init,
        double * U, double * V, double * W
        );

};//extern "C"

#endif
