/*
*	This file contains override operators NEW,DELETE for memory allocation.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <cstdlib>

#ifndef _MEMORYALLOC_HH_
#define _MEMORYALLOC_HH_

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TMemoryAllocStats

/** Tato trid slouzi pro alokaci a dealokaci pameti.
*
*	Ve skutecnosti trida pouze zapouzdruje volani standardnich alokacnich operatoru
*	new a delete. Diky tomuto zapouzdreni je mozne kontrolovat mnozstvi alokaci a dealokaci
*	a kontrolovat tak alespon castecne praci s pameti.
*
*	Trida v podstate pouze pocita vyskyty, v souboru MemoryAlloc lze definovat
*	zda budou operatory pretizene nebo ne.
*/
class TMemoryAllocStats
{
//PUBLIC STATIC METHODS
public:
	static void		New_Normal(void) { m_alloc_normal++; };
	static void		New_Array(void) { m_alloc_array++; };
	static void		Delete_Normal(void) { m_alloc_normal--; };
	static void		Delete_Array(void) { m_alloc_array--; };

//PUBLIC STATIC COMPONENTS
public:
	static int		m_alloc_normal;		///< pocet alokaci pomoci operatoru NEW
	static int		m_alloc_array;		///< pocet alokaci pomoci operatoru NEW[]
};

// TMemoryAllocStats
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

#endif