/*
*	This file contains override operators NEW,DELETE for memory allocation.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "MemoryAlloc.h"

int TMemoryAllocStats::m_alloc_normal	= 0;
int TMemoryAllocStats::m_alloc_array	= 0;

/** Pomoci teto podminky definujeme zda budou pretizene peratory zapnute nebo ne.
*/
#if 1		// pouzivame pretizene globalni operatory

/** Global operator new.
*
*	\param size		[in] required memory size in bytes
*/
inline void * operator new(size_t size)
{
	TMemoryAllocStats::New_Normal();

	return malloc( size ) ;
}

/** Global operator new[].
*
*	\param size		[in] required memory size in bytes
*/
inline void * operator new[](size_t size)
{
	TMemoryAllocStats::New_Array();

	return malloc( size );
}

/** Global operator delete.
*
*	\param ptr	[in] pointer to memory to release
*/
inline void operator delete(void * ptr)
{
	TMemoryAllocStats::Delete_Normal();

	return free( ptr );
}

/** Global operator delete[].
*
*	\param ptr	[in] pointer to memory to release
*/
inline void operator delete[](void * ptr)
{
	TMemoryAllocStats::Delete_Array();

	return free( ptr );
}

#endif