/*
*	This file contains class that represents working class inside
*	TSimpleUnit and returns 
*
*		INTEGER 
*
*	value. Returned class
*	is derived from 
*
*		TUnitRetType_integer 
*
*	class.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <deque>
using namespace std;

namespace NSSimpleUnit
{
	class TUnitRetType_integer_implemented;
	class TSimpleUnitProcessingInterface_integer;
};

#ifndef _SIMPLEUNIT_SIMPLE_INTEGER_HH_
#define _SIMPLEUNIT_SIMPLE_INTEGER_HH_

#include "pipeline/SimpleUnit.h"
#include "simpleunit/Manager.h"

namespace NSSimpleUnit
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TUnitRetType_integer_implemented

/** Tato trida reprezentuje navratovy typ reprezentujici cele cislo.
*
*	Jedina pouzitelna metoda pro vypocetni jednotku je metoda SetValue(int), ktera
*	nastavi novy vysledek do objektu.
*
*	Ostatni nevirtualni metody jsou nepodstatne.
*
*	Objekty z teto tridy jsou vytvarenu v manageru objektu typu TManager<TUnitRetType_integer_implemented>
*	ktery je umisten primo v jednotce typu TSimpleUnitProcessingInterface_integer.
*
*	Po vytvoreni objektu je do nej ulozena informace o jednotce (ukazatel) - pri uvolnovani objektu
*	je tento do jednotky vracen.
*
*	JE VZDY NUTNE REIMPLEMENTOVAT VSECHNY VIRTUALNI METODY Z BAZOVE TRIDY!!!
*/
class TUnitRetType_integer_implemented : public TUnitRetType_integer
{
friend TManager<TUnitRetType_integer_implemented>;
friend TSimpleUnitProcessingInterface_integer;

//PUBLIC OVERRIDEN METHODS
public:
	virtual void			Release(void);
	virtual int				GetValue(void);

//PUBLIC METHODS
public:
	void					SetValue( int value );

//PRIVATE METHODS
private:
							TUnitRetType_integer_implemented(void);
							~TUnitRetType_integer_implemented(void);

	void					AddRefs(void);
	void					Reset(void);
	void					SetParent( TSimpleUnitProcessingInterface_integer * parent);

//PRIVATE FAKE METHODS
private:
							TUnitRetType_integer_implemented( const TUnitRetType_integer_implemented & orig);	///< falesny kopirovaci konstruktor
	void					operator=(  const TUnitRetType_integer_implemented & orig);							///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	DWORD										m_refs;		///< pocet referenci na objekt
	int											m_value;	///< vlastni ulozena hodnota

	TCriticalSection							m_cs;		///< synchronizace pro pocitani referenci

	TSimpleUnitProcessingInterface_integer*		m_parent;	///< jednotka kde byl objekt vytvoren
															///< a kam ma byt vracen
};
//OK 2007-08-25 23:47:53 B04-315B\Tom

/** Virtualni metoda vracejici hodnotu ulozenou v tomto objektu.
*/
inline int TUnitRetType_integer_implemented::GetValue(void)
{
	return m_value;
}
//OK 2007-08-25 23:51:18 B04-315B\Tom

/** Soukromy konstruktor.
*
*	Vytvori objekt s jednou referenci a hodnotou 0.
*
*	METODA JE VOLANA Z MANAGERU TECHTO OBJEKTU VE VYPOCETNI JEDNOTCE DEFINOVANE NIZE.
*/
inline TUnitRetType_integer_implemented::TUnitRetType_integer_implemented(void)
{
	m_refs	= 1;
	m_value	= 0;
}
//OK 2007-08-25 23:51:20 B04-315B\Tom

/** Soukromy destruktor.
*
*	METODA JE VOLANA Z MANAGERU TECHTO OBJEKTU VE VYPOCETNI JEDNOTCE DEFINOVANE NIZE.
*/
inline TUnitRetType_integer_implemented::~TUnitRetType_integer_implemented(void)
{
	//empty
}
//OK 2007-08-25 23:51:21 B04-315B\Tom

/** Nastavi novou hodnotu do tohoto objektu.
*
*	Tato metoda by mela byt pouzita v ramci tridy TSimpleUnitProcessingInterface_integer
*	v metode ProcessFrame, kdy objekt jeste neni zarazen do seznamu vysledku a tedy
*	nad nim pracuje pouze jedno vlakno.
*
*	V metode ProcessFrame je ziskan vysledek, od objektu typu TSimpleUnitProcessingInterface_integer
*	je ziskan novy objekt typu TUnitRetType_integer_implemented pres metodu GetObject() a do tohoto
*	objektu je ulzena hodnota pres tuto metody SetValue().
*
*	\param	value	[in] nova hodnota
*/
inline void TUnitRetType_integer_implemented::SetValue( int value )
{
	m_value = value;
}
//OK 2007-08-25 23:51:23 B04-315B\Tom

/** Pridani reference na objekt.
*/
inline void TUnitRetType_integer_implemented::AddRefs(void)
{
	m_cs.Enter();
		m_refs++;
	m_cs.Leave();
}
//OK 2007-08-25 23:51:26 B04-315B\Tom

/** Tato metoda inicializuje zadany objekt do podoby po vytvoreni.
*
*	Metoda by mela byt volana v manageru objektu pokud byl uz objekt
*	drive pouzit. To znamena, ze objekt je pri zavolani drzen pouze jednim vlaknem
*	a tedy neni potreba synchronizace.
*/
inline void TUnitRetType_integer_implemented::Reset(void)
{
	m_refs	= 1;
	m_value	= 0;
}
//OK 2007-08-25 23:51:28 B04-315B\Tom

/** Nastaveni rodicovske jednotky pro tento objekt.
*
*	Metoda je volana v manageru objektu zadane jednotky a tedy k ni pristupuje pouze
*	jedno vlakno.
*
*	\param	parent	[in] rodicovska jednotka, ktera objekt vlastni a do ktere by mel byt vracen
*/
inline void 
TUnitRetType_integer_implemented::SetParent( TSimpleUnitProcessingInterface_integer * parent)
{
	m_parent = parent;
}
//OK 2007-08-25 23:51:30 B04-315B\Tom

// TUnitRetType_integer_implemented
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TSimpleUnitProcessingInterface_integer

/** Tato jednotka vraci hodnoty typu INTEGER.
*
*	ODVOZENA TRIDA MUSI REIMPLEMENTOVAT METODU PROCESSFRAME()!!!
*/
class TSimpleUnitProcessingInterface_integer : public TSimpleUnitProcessingInterface
{
friend TUnitRetType_integer_implemented;

//PUBLIC OVERRIDEN METHODS
public:
	virtual void						ProcessFrame( const TFrame * frame ) = 0;

	virtual								~TSimpleUnitProcessingInterface_integer(void);
	virtual EnumUnitType				GetType(void) const { return ENUM_UNITTYPE_INTEGER; };
	virtual TUnitRetTypeInterface*		GetResult( DWORD id );

//PUBLIC METHODS
public:
										TSimpleUnitProcessingInterface_integer(void);

//PROTECTED METHODS
protected:
	void								AddResult( DWORD id, TUnitRetType_integer_implemented * res );

	TUnitRetType_integer_implemented*	GetObject(void);
	void								ReturnObject( TUnitRetType_integer_implemented * object );

//PROTECTED FAKE METHODS
protected:
										TSimpleUnitProcessingInterface_integer( const TSimpleUnitProcessingInterface_integer & orig);	///< falesny kopirovaci konstruktor
	void								operator=( const TSimpleUnitProcessingInterface_integer & orig);								///< falesny prirazovaci operator

//PROTECTED COMPONENTS
protected:
	static const DWORD sc_memory = 10;	///< maximalni pocet vysledku, ktere si trida pamatuje

//PRIVATE COMPONENTS
private:
	deque<TUnitRetType_integer_implemented*>	m_results;		///< posledni vysledky
	deque<DWORD>								m_resultsID;	///< identifikatory k vysledkum
																///< identifikator urcuje ID snimku
																///< ktereho se vysledek tyka

	TManager<TUnitRetType_integer_implemented>	m_objects;		///< manager s objekty, neni je nutne
																///< neustale alokovat

	TCriticalSection							m_cs_res;		///< synchronizace pristupu
																///< k vysledkum	
	TCriticalSection							m_cs_manager;	///< synchronizace pristupu k manageru
};
//OK 2007-08-26 00:00:15 B04-315B\Tom

/** Konstruktor.
*/
inline TSimpleUnitProcessingInterface_integer::TSimpleUnitProcessingInterface_integer(void)
{
	//empty
}
//OK 2007-08-26 00:00:17 B04-315B\Tom

/** Virtualni destruktor.
*
*	Smi byt volan v okamziku kdyz uz neexistuji zadne reference na vysledky teto jednotky!!!
*/
inline TSimpleUnitProcessingInterface_integer::~TSimpleUnitProcessingInterface_integer(void)
{
	//odstranime vsechny vysledky
	while ( ! m_results.empty() )
	{
		//muzeme pouzit operator delete, protoze na vysledek uz v aplikaci nejsou reference
		//metoda Release() by vysledek pouze vratila do manageru
		TUnitRetType_integer_implemented * ptr = m_results.front();
		m_results.pop_front();
		delete ptr;
	}
}
//OK 2007-08-26 00:00:19 B04-315B\Tom

/** Ziskani vysledku ze snimku s pozadovanym ID.
*
*	\param	id		[in] identifikator pozadovaneho snimku
*/
inline TUnitRetTypeInterface* TSimpleUnitProcessingInterface_integer::GetResult( DWORD id ) 
{
	//TODO - mozna by se vyplatilo zahodit vsechny vysledky starsi nez ten posledni pozadovany

	TUnitRetType_integer_implemented * res = NULL;

	m_cs_res.Enter();
		//musime nalezt snimek s pozadovanym ID a vratit vysledek
		const size_t size = m_resultsID.size();
		for ( size_t i = 0 ; i < size ; i++ )
		{
			if ( id == m_resultsID[i] )
			{
				//nasli jsme pozadovany vysledek
				res = m_results[i];
				res->AddRefs();
				break;
			}
		}
	m_cs_res.Leave();

	return res; 
};
//OK 2007-08-26 00:00:56 B04-315B\Tom

/** Pridani noveho vysledku do seznamu vysledku.
*
*	Vysledek je pridan na konec seznamu.
*
*	\param	id		[in] identifikace snimku pro nejz je vysledek urcen
*	\param	res		[in] platny vysledek - metoda nezvysuje pocet referenci na nej !!!
*/
inline void 
TSimpleUnitProcessingInterface_integer::AddResult( DWORD id, TUnitRetType_integer_implemented * res )
{
	m_cs_res.Enter();
		m_results.push_back( res );
		m_resultsID.push_back( id );

		//odstranime zastarale prvky
		if ( m_results.size() > sc_memory )
		{
			TUnitRetType_integer_implemented * ptr = m_results.front();
			ptr->Release();

			m_results.pop_front();
			m_resultsID.pop_front();
		}
	m_cs_res.Leave();
}
//OK 2007-08-26 00:01:05 B04-315B\Tom

/** Vrati novy objekt z manageru objektu.
*
*	Tento objekt je dale ve vlastnictvi aplikace dokud jej nevrati zpet do manageru
*	pomoci metody ReturnObject();
*
*	Metoda je volana z metody ProcessFrame().
*/
inline TUnitRetType_integer_implemented*
TSimpleUnitProcessingInterface_integer::GetObject(void)
{
	m_cs_manager.Enter();
		TUnitRetType_integer_implemented * ptr = m_objects.GetItem();
	m_cs_manager.Leave();

	//re-inicializace objektu
	ptr->Reset();

	ptr->SetParent( this );

	return ptr;
}
//OK 2007-08-26 00:01:28 B04-315B\Tom

/** Vrati zpet do manageru objekt ziskany metodou GetObject().
*
*	Metoda by mela byt volana z metody Release() vraceneho objektu.
*
*	\param	object	[in] vraceny objekt - metoda jej zaradi do manageru a pri pristim
*					pouziti jej manager znovu reinicializuje
*/
inline void
TSimpleUnitProcessingInterface_integer::ReturnObject( TUnitRetType_integer_implemented * object )
{
	m_cs_manager.Enter();
		//vratime objekt do manageru
		m_objects.PushItem( object );
	m_cs_manager.Leave();
}
//OK 2007-08-26 00:01:38 B04-315B\Tom

// TSimpleUnitProcessingInterface_integer
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSSimpleUnit
using namespace NSSimpleUnit;

#endif