/*
*	This file contains class that represents working class inside
*	TSimpleUnit and returns 
*
*		IMAGES 
*
*	value. Returned class
*	is derived from 
*
*		TUnitRetType_images
*
*	class.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/
#include "simpleunit/Simple_images.h"

//definice staticke slozky pro manager
DWORD TManager<TUnitRetType_images_rgb_implemented>::ms_alloc_count = 0;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TUnitRetType_images_rgb_implemented

/** Snizeni poctu referenci.
*
*	Jakmile pocet referenci dosahne 0 je objekt okamzite smazan, resp. vracen
*	rodicovske jednotce.
*/
void TUnitRetType_images_rgb_implemented::Release(void)
{
	m_cs.Enter();
		m_refs--;
		DWORD tmp_refs = m_refs;
	m_cs.Leave();

	if ( tmp_refs == 0 )
	{
		//objekt je uvolnen
		m_parent->ReturnObject( this );
	}
}
//OK 2007-08-26 00:21:29 B04-315B\Tom

// TUnitRetType_images_rgb_implemented
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TSimpleUnitProcessingInterface_images_rgb

/** Tato metoda uvolni vsechny vysledky.
*
*	Tyto vysledky drzi reference na objekty z cizich objektu a proto je potreba je odstranit.
*/
void TSimpleUnitProcessingInterface_images_rgb::FreeImageResults(void)
{
	while( ! m_results.empty() )
	{
		m_results.back()->Release();
		m_results.pop_back();
	}
}

// TSimpleUnitProcessingInterface_images_rgb
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
