/*
*	 This file contains class that helps you load working unit from DLL.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "pipeline/UnitLoader.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TUnitLoader

/** Konstruktor.
*/
TUnitLoader::TUnitLoader(void)
{
	m_unit		= NULL;
	m_library	= NULL;
}
//OK 2007-08-25 18:22:54 B04-315B\Tom

/** Destruktor.
*
*	Zavre otevrenou knihovnu (pokud existuje).
*
*	Pred volanim destruktoru musi byt jednotka z dane DLL knihovny znicena.
*/
TUnitLoader::~TUnitLoader(void)
{
	if ( m_library )
	{
		//zavreme knihovnu
		FreeLibrary( m_library );
		m_library = NULL;
	}
}
//OK 2007-08-25 18:22:57 B04-315B\Tom

/** Ziska jednotku ze zadane knihovny.
*
*	Metoda muze vratit ukazatel na drive vracenou jednotku, pokud uz byla nekdy
*	nejaka jednotka uvnitr objektu vytvorena.
*
*	Pri chybe vraci metoda NULL.
*
*	\param	dllName		[in] jmeno souboru s knihovnou
*	\param	dispatcher	[in] ukazatel na platny dispatcher pouzity v aplikaci
*/
TUnitInterface* TUnitLoader::GetUnit_BASIC(const char * dllName , TDispatcherInterface * dispatcher)
{
	// pokud jiz existuje nejaka jednotka pak ji vratime
	if ( m_unit )
	{
		return m_unit;
	}
	else
	{
		//musime jednotku nacist
		m_library = LoadLibrary( dllName );
		if ( ! m_library )
		{
			return NULL;
		}

		//overime typ jednotky
		PTR_DLLTYPE type_ptr = (PTR_DLLTYPE) GetProcAddress( m_library, "GetType" );
		if ( ! type_ptr )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//ziskame typ a overime
		EnumDLLType dllType = (*type_ptr)();
		if ( dllType != ENUM_DLLTYPE_BASIC )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//ziskame objekt z knihovny
		PTR_UNITGET_BASIC fce_ptr = (PTR_UNITGET_BASIC)GetProcAddress( m_library, "CreateUnit" );
		if ( ! fce_ptr )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//vytvorime objekt
		m_unit = (*fce_ptr)( dispatcher );

		if ( ! m_unit )
		{
			FreeLibrary( m_library );
			m_library = NULL;
		}

		return m_unit;
	}
}
//OK 2007-08-25 18:23:20 B04-315B\Tom

/** Ziska jednotku ze zadane knihovny.
*
*	Metoda muze vratit ukazatel na drive vracenou jednotku, pokud uz byla nekdy
*	nejaka jednotka uvnitr objektu vytvorena.
*
*	Pri chybe vraci metoda NULL.
*
*	\param	dllName		[in] jmeno souboru s knihovnou
*	\param	dispatcher	[in] ukazatel na platny dispatcher pouzity v aplikaci
*	\param	str			[in] retezec predany jednotce jako druhy parametr
*/
TUnitInterface* TUnitLoader::GetUnit_STRING(
	const char * dllName ,
	TDispatcherInterface * dispatcher,
	const char * str
	)
{
	// pokud jiz existuje nejaka jednotka pak ji vratime
	if ( m_unit )
	{
		return m_unit;
	}
	else
	{
		//musime jednotku nacist
		m_library = LoadLibrary( dllName );
		if ( ! m_library )
		{
			return NULL;
		}

		//overime typ jednotky
		PTR_DLLTYPE type_ptr = (PTR_DLLTYPE) GetProcAddress( m_library, "GetType" );
		if ( ! type_ptr )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//ziskame typ a overime
		EnumDLLType dllType = (*type_ptr)();
		if ( dllType != ENUM_DLLTYPE_STRING )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//ziskame objekt z knihovny
		PTR_UNITGET_STRING fce_ptr = (PTR_UNITGET_STRING)GetProcAddress( m_library, "CreateUnit" );
		if ( ! fce_ptr )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//vytvorime objekt
		m_unit = (*fce_ptr)( dispatcher, str );

		if ( ! m_unit )
		{
			FreeLibrary( m_library );
			m_library = NULL;
		}

		return m_unit;
	}
}
//OK 2007-08-25 18:23:23 B04-315B\Tom

// TUnitLoader
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
