/*
*	 This file contains class that encapsulate system critical section.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

//FORWARD DECLARATIONS
namespace NSPipeline
{
	class TCriticalSection;
};

#ifndef _PIPELINE_CRITICALSECTION_HH_
#define _PIPELINE_CRITICALSECTION_HH_

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCriticalSection

/**	Trida pro zjednoduseni prace s kritickou sekci.
*
*	V aplikaci musi byt vzdy pouzita dvojice volani TCriticalSection::Enter() 
*	a TCriticalSection::Leave().
*/
class TCriticalSection
{
//PUBLIC METHODS
public:
						TCriticalSection(void);
						~TCriticalSection(void);

	void				Enter(void);
	void				Leave(void);

//PRIVATE FAKE METHODS
private:
						TCriticalSection( const TCriticalSection & orig );	///< falesny kopirovaci konstruktor
	void				operator=( const TCriticalSection & orig );			///< falesny operator prirazeni

//PRIVATE COMPONENTS
private:
	CRITICAL_SECTION	m_section;	///< systemove zavisla kriticka sekce z Windows
};
//OK 2007-08-25 02:21:00 B04-315B\Tom

// TCriticalSection
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

};//end of NSPipeline
using namespace NSPipeline;

#endif