/*
*	 This file contains class that helps you load camera from DLL.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

//FORWARD DECLARATIONS
namespace NSPipeline
{
	class TCameraLoader;
};

#ifndef _PIPELINE_CAMERALOADER_HH_
#define _PIPELINE_CAMERALOADER_HH_

#include "pipeline/CameraAbstract.h"

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraLoader

/** Tato trida nacte kameru ze zadane DLL.
*
*	Vytvoreny objekt v sobe udrzuje nactenou DLL.
*	Jakmile objekt vrati kameru pak je tato ulozena a je vracena vzdy.
*	Pred znicenim tohoto objektu musi byt kamera jim vytvorena take znicena pomoci metody Destroy().
*
*	\note	Kameru lze nacist i beznym zpusobem, pouziti tohoto objektu pouze usnadnuje
*			nacitani.
*/
class TCameraLoader
{
//PUBLIC METHODS
public:
							TCameraLoader(void);
							~TCameraLoader(void);

	TCameraAbstract*		GetCamera_DirectShow( const char * dllName );
	TCameraAbstract*		GetCamera_Image( const char * dllName, const char * filename );
	TCameraAbstract*		GetCamera_Video( const char * dllName, const char * filename );
	TCameraAbstract*		GetCamera_Null( const char * dllName);

//PRIVATE FAKE METHODS
private:
							TCameraLoader( const TCameraLoader & orig );///< falesny kopirovaci konstruktor
	void					operator=( const TCameraLoader & orig );	///< falesny operator prirazeni


//PRIVATE COMPONENTS
private:
	TCameraAbstract*		m_camera;		///< vracena kamera
	HMODULE					m_library;		///< pouzita knihovna
};
//OK 2007-08-25 15:27:32 B04-315B\Tom

// TCameraLoader
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of NSPipeline
using namespace NSPipeline;

#endif