/*
*	This is main file of this project. It contains main function
*	that show example of using entire pipeline.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "pipeline/CameraThread.h"
#include "pipeline/CameraLoader.h"
#include "pipeline/Dispatcher.h"
#include "pipeline/FrameQueue.h"

#include "pipeline/UnitLoader.h"

#include "pipeline/ImagePixelFormats.h"

using namespace NSPipeline;

/** Ukazka pouziti retezce. Pro zjednoduseni neobsahuje detekci chybovych stavu.
*/
int main()
{
#if 0

	//INICIALIZACE RETEZCE

		//nejprve vytvorime staticke prvky (neobsahuji sve vypocetni vlakno) celeho retezce
		TFrameQueue * pipeline_queue	= new TFrameQueue;
		TDispatcher * pipeline_dispatcher = new TDispatcher( pipeline_queue );

		//nyni musime vybrat zdroj obrazovych dat - nacteme tedy kameru ze zvolene DLL
		//musime nacist kameru
		TCameraLoader * pipeline_cameraLoader = new TCameraLoader;
		TCameraAbstract * pipeline_camera = pipeline_cameraLoader->GetCamera_DirectShow( "jmeno_souboru_s_dll_knihovnou_pro_dshow_kameru" );

		//nastavime informace o vlastnostech snimku do dispatcheru, ten bude tyto informace
		//poskytovat vypocetnim jednotkam
		pipeline_dispatcher->SetFramesInfo( pipeline_camera->GetWidth(), pipeline_camera->GetHeight() );

		//vytvorime vlakno pro kameru, ktery bude ziskavat snimky kazdych 40 milisekund (25 FPS)
		//a bude disponovat maximalne 100 snimky, ktere smi poslat do retezce.
		TCameraThread * pipeline_cameraThread	= new TCameraThread( pipeline_dispatcher, pipeline_camera, 40, 100 );

	//RETEZEC JE VYTVOREN - ZDE SE PRIDAVAJI JEDNOTKY

		//objekt pro nacteni jedne jednotky
		TUnitLoader pipeline_unit01_loader;
		
		//budeme nacitat jednotku, ktera neprijima zadne dodatecne parametry
		TUnitInterface * pipeline_unit01 =
			pipeline_unit01_loader.GetUnit_BASIC( "soubor_dll_s_jednotkou", pipeline_dispatcher );

		//muzeme jednotku spustit
		pipeline_unit01->Start();

		//zde lze podobne nacitat dalsi jednotky

	// ZDE SPUSTIME VLAKNO GENERUJICI SNIMKY

		pipeline_cameraThread->Start();

	// ZDE NASLEDUJE SMYCKA ZPRAV APLIKACE VE KTERE SE ZPRACOVAVAJI VYSLEDKY JEDNOTEK
	// A ZOBRAZUJI VYSLEDKY

		//empty

	// UKONCENI APLIKACE

	// NEJPRVE MUSIME UKONCIT VSECHNY JEDNOTKY
		
		pipeline_unit01->Stop();
		pipeline_unit01->Release();
		pipeline_unit01 = NULL;

	// NYNI ZRUSIME CELY VYPOCETNI RETEZEC

		//nejprve zastavime generovani novych snimku
		pipeline_cameraThread->Stop();

		//nyni musime uvolnit vsechny snimky z retezce
		pipeline_queue->Free();
		pipeline_dispatcher->Free();

		//odstranime cely system kamery
		delete pipeline_cameraThread;
		pipeline_camera->Destroy();
		pipeline_camera = NULL;
		delete pipeline_cameraLoader;

		//odstranime staticke slozky retezce
		delete pipeline_dispatcher;
		delete pipeline_queue;

	//APLIKACE JE SPRAVNE UKONCENA

#endif

	return 0;
}