/*
*	This file contains class that represents working class inside
*	TSimpleUnit and returns 
*
*		RECTANGLES 
*
*	value. Returned class
*	is derived from 
*
*		TUnitRetType_rectangles
*
*	class.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <deque>
#include <vector>
using namespace std;

// FORWARD DECLARATIONS
namespace NSSimpleUnit
{
	class TUnitRetType_rectangles_implemented;
	class TSimpleUnitProcessingInterface_rectangles;
};

#ifndef _SIMPLEUNIT_SIMPLE_RECTANGLES_HH_
#define _SIMPLEUNIT_SIMPLE_RECTANGLES_HH_

#include "pipeline/SimpleUnit.h"
#include "simpleunit/Manager.h"

namespace NSSimpleUnit
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TUnitRetType_rectangles_implemented

/** Tato trida reprezentuje navratovy typ, reprezentujici pole obdelniku.
*
*	Jedina pouzitelna metoda pro vypocetni jednotku je metoda InsertRectangle( const TRT_Rect & rect ), ktera
*	nastavi novy vysledek do objektu.
*
*	Ostatni nevirtualni metody jsou nepodstatne.
*
*	JE VZDY NUTNE REIMPLEMENTOVAT VSECHNY VIRTUALNI METODY Z BAZOVE TRIDY!!!
*/
class TUnitRetType_rectangles_implemented : public TUnitRetType_rectangles
{
friend TManager<TUnitRetType_rectangles_implemented>;
friend TSimpleUnitProcessingInterface_rectangles;

//PUBLIC OVERRIDEN METHODS
public:
	virtual void				Release(void);
	virtual DWORD				GetRectangleCount(void);	
	virtual	const TRT_Rect*		GetRectangle( DWORD index );


//PUBLIC METHODS
public:
	void					InsertRectangle( const TRT_Rect & rect );

//PRIVATE METHODS
private:
							TUnitRetType_rectangles_implemented(void);
							~TUnitRetType_rectangles_implemented(void);

	void					AddRefs(void);
	void					Reset(void);
	void					SetParent( TSimpleUnitProcessingInterface_rectangles * parent);

//PRIVATE FAKE METHODS
private:
							TUnitRetType_rectangles_implemented( const TUnitRetType_rectangles_implemented & orig);	///< falesny kopirovaci konstruktor
	void					operator=( const TUnitRetType_rectangles_implemented & orig);							///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	DWORD										m_refs;		///< pocet referenci na objekt

	vector<TRT_Rect>							m_value;	///< vlastni ulozena hodnota
															///< tj. pole obdelniku

	TCriticalSection							m_cs;		///< synchronizace pro pocitani referenci

	TSimpleUnitProcessingInterface_rectangles*	m_parent;	///< jednotka kde byl objekt vytvoren
															///< a kam ma byt vracen
};
//OK 2007-08-26 00:03:58 B04-315B\Tom

/** Virtualni metoda vracejici pocet obdelniku ulozenych v tomto objektu.
*/
inline DWORD TUnitRetType_rectangles_implemented::GetRectangleCount(void)
{
	return (DWORD)m_value.size();
}
//OK 2007-08-26 00:04:00 B04-315B\Tom

/** Virtualni metoda vracejici ukazatel na obdelnik na zadanem indexu.
*
*	Pokud je index mimo pak vraci metoda NULL.
*
*	\param	index	[in] index pozadovaneho obdelniku
*/
inline const TRT_Rect* TUnitRetType_rectangles_implemented::GetRectangle( DWORD index )
{
	if ( index < m_value.size() )
	{
		return & m_value[index];
	}
	else
	{
		return NULL;
	}
}
//OK 2007-08-26 00:04:05 B04-315B\Tom

/** Soukromy konstruktor.
*
*	Vytvori objekt s jednou referenci a zadnyn obdelnikem.
*
*	METODA JE VOLANA Z MANAGERU TECHTO OBJEKTU VE VYPOCETNI JEDNOTCE DEFINOVANE NIZE.
*/
inline TUnitRetType_rectangles_implemented::TUnitRetType_rectangles_implemented(void)
{
	m_refs	= 1;
	
	//m_value;
}
//OK 2007-08-26 00:04:09 B04-315B\Tom

/** Soukromy destruktor.
*
*	METODA JE VOLANA Z MANAGERU TECHTO OBJEKTU VE VYPOCETNI JEDNOTCE DEFINOVANE NIZE.
*/
inline TUnitRetType_rectangles_implemented::~TUnitRetType_rectangles_implemented(void)
{
	//empty
}
//OK 2007-08-26 00:04:16 B04-315B\Tom

/** Prida novy obdelnik do vysledku.
*
*	Tato metoda by mela byt pouzita v ramci tridy TSimpleUnitProcessingInterface_rectangles
*	v metode ProcessFrame, kdy objekt jeste neni zarazen do seznamu vysledku a tedy
*	nad nim pracuje pouze jedno vlakno.
*
*	\param	rect	[in] pridavany obdelnik
*/
inline void TUnitRetType_rectangles_implemented::InsertRectangle( const TRT_Rect & rect )
{
	m_value.push_back( rect );
}
//OK 2007-08-26 00:04:18 B04-315B\Tom

/** Pridani reference na objekt.
*/
inline void TUnitRetType_rectangles_implemented::AddRefs(void)
{
	m_cs.Enter();
		m_refs++;
	m_cs.Leave();
}
//OK 2007-08-26 00:04:30 B04-315B\Tom

/** Tato metoda inicializuje zadany objekt do podoby po vytvoreni.
*
*	Metoda by mela byt volana v manageru objektu pokud byl uz objekt
*	drive pouzit. To znamena, ze objekt je pri zavolani drzen pouze jednim vlaknem
*	a tedy neni potreba synchronizace.
*/
inline void TUnitRetType_rectangles_implemented::Reset(void)
{
	m_refs	= 1;
	m_value.clear();
}
//OK 2007-08-26 00:04:34 B04-315B\Tom

/** Nastaveni rodicovske jednotky pro tento objekt.
*
*	Metoda je volana v manageru objektu zadane jednotky a tedy k ni pristupuje pouze
*	jedno vlakno.
*
*	\param	parent	[in] rodicovska jednotka, ktera objekt vlastni a do ktere by mel byt vracen
*/
inline void 
TUnitRetType_rectangles_implemented::SetParent( TSimpleUnitProcessingInterface_rectangles * parent)
{
	m_parent = parent;
}
//OK 2007-08-26 00:04:40 B04-315B\Tom

// TUnitRetType_rectangles_implemented
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
//TSimpleUnitProcessingInterface_rectangles

/** Tato jednotka vraci hodnoty typu RECTANGLES.
*
*	ODVOZENA TRIDA MUSI REIMPLEMENTOVAT METODU PROCESSFRAME()!!!
*/
class TSimpleUnitProcessingInterface_rectangles : public TSimpleUnitProcessingInterface
{
friend TUnitRetType_rectangles_implemented;

//PUBLIC OVERRIDEN METHODS
public:
	virtual void						ProcessFrame( const TFrame * frame ) = 0;

	virtual								~TSimpleUnitProcessingInterface_rectangles(void);

	/** Typ jednotky a zaroven vysledku.
	*/
	virtual EnumUnitType				GetType(void) const { return ENUM_UNITTYPE_RECTANGLES; };

	virtual TUnitRetTypeInterface*		GetResult( DWORD id );

//PUBLIC METHODS
public:
										TSimpleUnitProcessingInterface_rectangles(void);

//PROTECTED METHODS
protected:
	void								AddResult( DWORD id, TUnitRetType_rectangles_implemented * res );

	TUnitRetType_rectangles_implemented*	GetObject(void);
	void									ReturnObject( TUnitRetType_rectangles_implemented * object );

//PROTECTED FAKE METHODS
protected:
										TSimpleUnitProcessingInterface_rectangles( const TSimpleUnitProcessingInterface_rectangles & orig);	///< falesny kopirovaci konstruktor
	void								operator=( const TSimpleUnitProcessingInterface_rectangles & orig);									///< falesny prirazovaci operator

//PROTECTED COMPONENTS
protected:
	static const DWORD sc_memory = 10;	///< maximalni pocet vysledku, ktere se trida pamatuje

//PRIVATE COMPONENTS
private:
	deque<TUnitRetType_rectangles_implemented*>		m_results;		///< posledni vysledky
	deque<DWORD>									m_resultsID;	///< identifikatory k vysledkum
																	///< identifikator urcuje ID snimku
																	///< ktereho se vysledek tyka

	TManager<TUnitRetType_rectangles_implemented>	m_objects;		///< manager s objekty, neni je nutne
																	///< neustale alokovat

	TCriticalSection							m_cs_res;		///< synchronizace pristupu
																///< k vysledkum	
	TCriticalSection							m_cs_manager;	///< synchronizace pristupu k manageru
};
//OK 2007-08-26 00:05:38 B04-315B\Tom

/** Konstruktor.
*/
inline TSimpleUnitProcessingInterface_rectangles::TSimpleUnitProcessingInterface_rectangles(void)
{
	//empty
}
//OK 2007-08-26 00:05:39 B04-315B\Tom

/** Virtualni destruktor.
*
*	Smi byt volan v okamziku kdyz uz neexistuji zadne reference na vysledky teto jednotky!!!
*/
inline TSimpleUnitProcessingInterface_rectangles::~TSimpleUnitProcessingInterface_rectangles(void)
{
	//odstranime vsechny vysledky
	while ( ! m_results.empty() )
	{
		//muzeme pouzit operator delete, protoze na vysledek uz v aplikaci nejsou reference
		//metoda Release() by vysledek pouze vratila do manageru
		TUnitRetType_rectangles_implemented * ptr = m_results.front();
		m_results.pop_front();
		delete ptr;
	}
}
//OK 2007-08-26 00:05:42 B04-315B\Tom

/** Ziskani vysledku ze snimku s pozadovanym ID.
*
*	\param	id		[in] identifikator pozadovaneho snimku
*/
inline TUnitRetTypeInterface* TSimpleUnitProcessingInterface_rectangles::GetResult( DWORD id ) 
{
	//TODO - mozna by se vyplatilo zahodit vsechny vysledky starsi nez ten posledni pozadovany

	TUnitRetType_rectangles_implemented * res = NULL;

	m_cs_res.Enter();
		//musime nalezt snimek s pozadovanym ID a vratit vysledek
		const size_t size = m_resultsID.size();
		for ( size_t i = 0 ; i < size ; i++ )
		{
			if ( id == m_resultsID[i] )
			{
				//nasli jsme pozadovany vysledek
				res = m_results[i];
				res->AddRefs();
				break;
			}
		}
	m_cs_res.Leave();

	return res; 
};
//OK 2007-08-26 00:05:44 B04-315B\Tom

/** Pridani noveho vysledku do seznamu vysledku.
*
*	Vysledek je pridan na konec seznamu.
*
*	\param	id		[in] identifikace snimku pro nejz je vysledek urcen
*	\param	res		[in] platny vysledek - metoda nezvysuje pocet referenci na nej !!!
*/
inline void 
TSimpleUnitProcessingInterface_rectangles::AddResult( DWORD id, TUnitRetType_rectangles_implemented * res )
{
	m_cs_res.Enter();
		m_results.push_back( res );
		m_resultsID.push_back( id );

		//odstranime zastarale prvky
		if ( m_results.size() > sc_memory )
		{
			TUnitRetType_rectangles_implemented * ptr = m_results.front();
			ptr->Release();

			m_results.pop_front();
			m_resultsID.pop_front();
		}
	m_cs_res.Leave();
}
//OK 2007-08-26 00:05:46 B04-315B\Tom

/** Vrati novy objekt z manageru objektu.
*
*	Tento objekt je dale ve vlastnictvi aplikace dokud jej nevrati zpet do manageru
*	pomoci metody ReturnObject();
*
*	Metoda je volana z metody ProcessFrame().
*/
inline TUnitRetType_rectangles_implemented*
TSimpleUnitProcessingInterface_rectangles::GetObject(void)
{
	m_cs_manager.Enter();
		TUnitRetType_rectangles_implemented * ptr = m_objects.GetItem();
	m_cs_manager.Leave();

	//re-inicializace objektu
	ptr->Reset();

	ptr->SetParent( this );

	return ptr;
}
//OK 2007-08-26 00:05:49 B04-315B\Tom

/** Vrati zpet do manageru objekt ziskany metodou GetObject().
*
*	Metoda by mela byt volana z metody Release() vraceneho objektu.
*
*	\param	object	[in] vraceny objekt - metoda jej zaradi do manageru a pri pristim
*					pouziti jej manager znovu reinicializuje
*/
inline void
TSimpleUnitProcessingInterface_rectangles::ReturnObject( TUnitRetType_rectangles_implemented * object )
{
	m_cs_manager.Enter();
		//vratime objekt do manageru
		m_objects.PushItem( object );
	m_cs_manager.Leave();
}
//OK 2007-08-26 00:05:52 B04-315B\Tom

// TSimpleUnitProcessingInterface_rectangles
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSSimpleUnit
using namespace NSSimpleUnit;

#endif