/*
*	 This file contains class that serves as timestamp for grabbed frames from camera.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <windows.h>

// FORWARD DECLARATIONS
namespace NSPipeline
{
	class TimeStamp;
}

#ifndef _PIPELINE_TIMESTAMP_HH_
#define _PIPELINE_TIMESTAMP_HH_

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TTimeStamp

/** Trida pro reprezentaci casu.
*
*	Dulezity je predevsim operator porovnani dvou casu.
*
*	Pri vytvoreni je v objektu zaznamenan aktualni cas a tento stav je dale nemenny.
*
*	Pro porovnani pomoci operatoru "==" a "!=" se pouziva jedinecny ID ktery je inkrementovan
*	s kazdym novym snimkem. Pro ostatni porovnani je pouzit casovy udaj.
*/
class TTimeStamp
{
//PUBLIC METHODS
public:
					TTimeStamp(void);

	DWORD			GetID(void) const;
	DWORD			GetTime(void) const;

	bool 			operator==(const TTimeStamp & second) const;
	bool 			operator!=(const TTimeStamp & second) const;
	bool 			operator<(const TTimeStamp & second) const;
	bool 			operator>(const TTimeStamp & second) const;
	bool 			operator<=(const TTimeStamp & second) const;
	bool 			operator>=(const TTimeStamp & second) const;

//PRIVATE STATIC MEMBERS
private:
	static DWORD	ms_actualID;		///< jedinecny identifikator pouzity pro pristi vytvareny objekt

//PRIVATE MEMBERS
private:
	DWORD			m_timeElapsed;		///< ziskany cas v dobe vytvoreni
	DWORD			m_id;				///< jedinecny identifikator - lepsi pro porovnani rovnosti
};
//OK 2007-08-25 15:33:54 B04-315B\Tom

/** Konstruktor.
*
*	Zaznamenava cas v dobe vytvoreni objektu a take uklada jedinecne ID.
*/
inline TTimeStamp::TTimeStamp(void)
{
	m_id			= ms_actualID;
	ms_actualID++;

	m_timeElapsed	= GetTickCount();
}
//OK 2007-08-25 15:33:56 B04-315B\Tom

/** Vrati ID teto casove znacky.
*/
inline DWORD TTimeStamp::GetID(void) const
{
	return m_id;
}
//OK 2007-08-25 15:33:59 B04-315B\Tom

/** Vrati cas ulozeny v objektu.
*
*	Cas je udaj v milisekundach reprezentujici pocet milisekund od spusteni
*	systemu.
*/
inline DWORD TTimeStamp::GetTime(void) const
{
	return m_timeElapsed;
}
//OK 2007-08-25 15:36:36 B04-315B\Tom

/** Operator porovnani.
*
*	Objekty se porovnavaji podle ID.
*
*	\param	second	[in] druhy cas k porovnani
*/
inline bool TTimeStamp::operator==(const TTimeStamp & second) const
{
	return m_id == second.m_id;
}
//OK 2007-08-25 15:36:34 B04-315B\Tom

/** Operator nonekvivalence.
*
*	Objekty se porovnavaji podle ID.
*
*	\param	second	[in] druhy cas k porovnani
*/
inline bool TTimeStamp::operator!=(const TTimeStamp & second) const
{
	return m_id != second.m_id;
}
//OK 2007-08-25 15:36:32 B04-315B\Tom

/** Operator mensi.
*
*	Objekty se porovnavaji podle casu.
*
*	\param	second	[in] druhy cas k porovnani
*/
inline bool TTimeStamp::operator<(const TTimeStamp & second) const
{
	return (m_timeElapsed < second.m_timeElapsed);
}
//OK 2007-08-25 15:36:30 B04-315B\Tom

/** Operator vetsi.
*
*	Objekty se porovnavaji podle casu.
*
*	\param	second	[in] druhy cas k porovnani
*/
inline bool TTimeStamp::operator>(const TTimeStamp & second) const
{
	return (m_timeElapsed > second.m_timeElapsed);
}
//OK 2007-08-25 15:36:27 B04-315B\Tom

/** Operator mensi nebo rovno.
*
*	Objekty se porovnavaji podle casu.
*
*	\param	second	[in] druhy cas k porovnani
*/
inline bool TTimeStamp::operator<=(const TTimeStamp & second) const
{
	return (m_timeElapsed <= second.m_timeElapsed);
}
//OK 2007-08-25 15:36:26 B04-315B\Tom

/** Operator vetsi nebo rovno.
*
*	Objekty se porovnavaji podle casu.
*
*	\param	second	[in] druhy cas k porovnani
*/
inline bool TTimeStamp::operator>=(const TTimeStamp & second) const
{
	return (m_timeElapsed >= second.m_timeElapsed);
}
//OK 2007-08-25 15:36:24 B04-315B\Tom

// TTimeStamp
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //end of NSPipeline
using namespace NSPipeline;

#endif