/*
*	This file contains class that represents dispatcher between input (camera), frame queue
*	and working units.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

namespace NSPipeline
{
	class TDispatcher;
};

#ifndef _PIPELINE_DISPATCHER_HH_
#define _PIPELINE_DISPATCHER_HH_

#include "pipeline/Image.h"
#include "pipeline/FrameQueue.h"

namespace NSPipeline
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TDispatcher

/** Tato trida obsahuje naposledy ziskany snimek z kamery.
*
*	Tento snimek musi byt zarazen do fronty snimku (TFrameQueue) a musi byt v TDispatcher k dispozici
*	az do prichodu do noveho snimku. Vypocetni jednotky si mohou tento snimek z TDispatcher vyzadat.
*
*	Snimek ulozeny v TDispatcher ma minimalne jeden zamek!!! a tedy NESMI opustit frontu TFrameQueue!!!
*	Teprve po prichodu noveho snimku je ze stareho snimku uvolnen zamek.
*
*	Dispatcher zaroven obsahuje informace o velikosti poskytovanych snimku.
*	Tato informace je uzitecna pri inicializaci vypocetnich jednotek, ktere takovou
*	informaci mohou vyuzit, protoze se predpoklada, ze za behu aplikace se tato velikost nebude menit.
*	Rozmery snimku musi byt do dispatcheru ulozeny pred vytvorenim prvni vypocetni jednotky, nejlepe
*	ihned jak je to mozne (po vytvoreni kamery).
*
*	\note	Pomoci parametru konstruktoru lze nastavit chovani dispatcheru tak, aby
*			nepreposilal snimky dale do aplikace. Tim je mozne pouzit cely vypocetni retezec
*			bez nutnosti zobrazovani snimku.
*/
class TDispatcher : public TDispatcherInterface
{
//PUBLIC OVERRIDEN METHODS
public:
	virtual DWORD		GetWidth(void);		
	virtual DWORD		GetHeight(void);

	virtual TFrame *	GetFrame(void);
	virtual TFrame *	GetLockedFrame(void);

	virtual				~TDispatcher(void);
//PUBLIC METHODS
public:
						TDispatcher( TFrameQueue * queue );						

	void				SetFramesInfo( DWORD width, DWORD height );

	void				SetFrame( TFrameReal * frame );

	void				Free(void);

//PRIVATE FAKE METHODS
private:
						TDispatcher( const TDispatcher & orig );	///< falesny kopirovaci konstruktor
	void				operator=( const TDispatcher & orig );		///< falesny operator prirazeni

//PRIVATE COMPONENTS
private:
	DWORD				m_width;		///< sirka poskytovanych snimku
	DWORD				m_height;		///< vyska poskytovanych snimku

	TCriticalSection	m_critical;		///< kriticka sekce pro synchronizaci pristupu ke snimku
										///< ulozenem v dispatcheru

	TFrameReal*			m_frame;		///< posledni snimek ulozeny v TDispatcher

	TFrameQueue*		m_queue;		///< ukazatel na frontu celeho retezce - je predana v konstruktoru
										///< pokud je misto fronty predan NULL pak dispatcher nikam snimky neposila

};
//OK 2007-08-25 14:20:30 B04-315B\Tom

// TDispatcher
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //end of NSPipeline
using namespace NSPipeline;

#endif