/*
*	 This file contains class that helps you load camera from DLL.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "pipeline/CameraLoader.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraLoader

/** Konstruktor.
*/
TCameraLoader::TCameraLoader(void)
{
	m_camera	= NULL;
	m_library	= NULL;
}
//OK 2007-08-25 15:27:39 B04-315B\Tom

/** Destruktor.
*
*	Zavre otevrenou knihovnu (pokud existuje).
*
*	\warning Pred volanim destruktoru musi byt kamera z dane DLL knihovny znicena.
*/
TCameraLoader::~TCameraLoader(void)
{
	if ( m_library )
	{
		//zavreme knihovnu
		FreeLibrary( m_library );
		m_library = NULL;
	}
}
//OK 2007-08-25 15:27:48 B04-315B\Tom

/** Ziska prvni DirectShow kameru pomoci zadane knihovny.
*
*	Metoda muze vratit ukazatel na drive vracenou kameru, pokud uz byla nekdy
*	nejaka kamera uvnitr objektu vytvorena.
*
*	Pri chybe vraci metoda NULL.
*
*	\param	dllName		[in] jmeno souboru s knihovnou pro kameru typu DirectShow
*/
TCameraAbstract* TCameraLoader::GetCamera_DirectShow(const char * dllName)
{
	// pokud jiz existuje nejaka kamera pak ji vratime
	if ( m_camera )
	{
		return m_camera;
	}
	else
	{
		//musime kameru nacist
		m_library = LoadLibrary( dllName );
		if ( ! m_library )
		{
			return NULL;
		}

		//ziskame objekt z knihovny
		PTR_CAMERAGET fce_ptr = (PTR_CAMERAGET)GetProcAddress( m_library, "CreateCamera" );
		if ( ! fce_ptr )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//vytvorime objekt
		m_camera = (*fce_ptr)();

		if ( ! m_camera )
		{
			FreeLibrary( m_library );
			m_library = NULL;
		}

		return m_camera;
	}
}
//OK 2007-08-25 15:27:57 B04-315B\Tom

/** Ziska kameru reprezentovanou souborem s obrazkem jehoz typ se urci podle zadane knihovny.
*
*	Metoda muze vratit ukazatel na drive vracenou kameru, pokud uz byla nekdy
*	nejaka kamera uvnitr objektu vytvorena.
*
*	Pri chybe vraci metoda NULL.
*
*	\param	dllName		[in] jmeno souboru s knihovnou
*	\param	filename	[in] cesta k souboru s obrazkem ktery ma byt nacten
*/
TCameraAbstract* TCameraLoader::GetCamera_Image( const char * dllName, const char * filename )
{
	// pokud jiz existuje nejaka kamera pak ji vratime
	if ( m_camera )
	{
		return m_camera;
	}
	else
	{
		//musime kameru nacist
		m_library = LoadLibrary( dllName );
		if ( ! m_library )
		{
			return NULL;
		}

		//ziskame objekt z knihovny
		PTR_CAMERAGETIMAGE fce_ptr = (PTR_CAMERAGETIMAGE)GetProcAddress( m_library, "CreateCamera" );
		if ( ! fce_ptr )
		{
			FreeLibrary( m_library );
			m_library = NULL;

			return NULL;
		}

		//vytvorime objekt
		m_camera = (*fce_ptr)( filename );

		if ( ! m_camera )
		{
			FreeLibrary( m_library );
			m_library = NULL;
		}

		return m_camera;
	}
}
//OK 2007-08-25 15:28:00 B04-315B\Tom

/** Ziska kameru reprezentovanou souborem s videem jehoz typ se urci podle zadane knihovny.
*
*	Metoda muze vratit ukazatel na drive vracenou kameru, pokud uz byla nekdy
*	nejaka kamera uvnitr objektu vytvorena.
*
*	Pri chybe vraci metoda NULL.
*
*	\param	dllName		[in] jmeno souboru s knihovnou  pro tento typ kamery
*	\param	filename	[in] cesta k souboru s videem ktery ma byt nacten
*/
TCameraAbstract* TCameraLoader::GetCamera_Video( const char * dllName, const char * filename )
{
	return this->GetCamera_Image( dllName, filename );
}
//OK 2007-11-16 22:01:48 B04-315A\Tom

/** Ziska null kameru.
*
*	Metoda muze vratit ukazatel na drive vracenou kameru, pokud uz byla nekdy
*	nejaka kamera uvnitr objektu vytvorena.
*
*	Pri chybe vraci metoda NULL.
*
*	\param	dllName		[in] jmeno souboru s knihovnou pro tento typ kamery
*/
TCameraAbstract* TCameraLoader::GetCamera_Null( const char * dllName)
{
	return this->GetCamera_DirectShow( dllName );
}
//OK 2007-11-16 22:01:46 B04-315A\Tom

// TCameraLoader
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////