/*
*	 This file contains class that encapsulates system thread.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include <cassert>

#include "pipeline/Thread.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TThread

/** Spusteni vlakna na prislusne funkci a s pozadovanym parametrem.
*
*	Vlakno lze spustit pouze jednou. Po uspesnem spusteni jiz dalsi
*	volani teto metody vraci TRUE a nic se nedeje.
*
*	Novou funkci lze spustit teprve po uspesnem ukonceni vlakna - tj. metoda IsTerminated()
*	vrati nejprve TRUE a nasledne je pomoci metody Finish() objekt uveden do pocatecniho stavu.
*
*	Metoda vraci TRUE pokud bylo vlakno uspesne spusteno nebo pokud jiz nejake vlakno bezi.
*	Metoda vrati FALSE v pripade, ze nelze vytvorit nove vlakno, coz je kriticka chyba.
*
*	\warning	Funkce spoustena vlaknem musi vracet hodnotu typu DWORD. Tato hodnota
*	nesmi byt v zadnem pripade shodna s hodnotou STILL_ACTIVE. V tom pripade by totiz
*	nebylo mozne rozeznat jiz dokoncenou funkci.
*
*	\param	function	[in] ukazatel na funkci, ktera bude nad vlaknem spustena
*	\param	param		[in] ukazatel na parametry - funkce musi znat spravny
*						typ a podle toho provest pretypovani
*/
BOOL TThread::Run( FUNC_PTR function, void * params )
{
	if( ! m_thread )
	{
		//vlakno spustime pouze pokud jiz nejake pres tento objekt neni spustene

		DWORD id;		
		m_thread = CreateThread(NULL,0,(PTHREAD_START_ROUTINE)function,params,0,&id);

		if( ! m_thread )
		{
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	else
	{
		//vlakno uz bylo spusteno
		return TRUE;
	}
}
//OK 2007-08-25 00:11:43 B04-315B\Tom

/** Metoda urci zda bylo vlakno spusteno.
*
*	\note	Vlakno uz nemusi bezet, metoda pouze detekuje ze vlakno bylo spusteno (vytvoreno).
*/
BOOL TThread::IsRunning(void) const
{
	return  NULL != m_thread;
}
//OK 2007-08-25 00:17:26 B04-315B\Tom

/** Metoda urci zda bylo bezici vlakno ukonceno.
*
*	Pokud vlakno nebylo vubec spusteno pak metoda vrati TRUE.
*	Metoda vraci FALSE pokud vlakno jeste bezi nebo v pripade nejake systemove chyby
*	vznikle v dusledku dotazu na vlakno..
*/
BOOL TThread::IsTerminated(void)
{
	if( m_thread )
	{
		//vlakno bylo spusteno - proverime ukonceni
		DWORD res;
		if( ! GetExitCodeThread( m_thread, &res ) )
		{
			//doslo k chybe, vlakno zrejme stale bezi, ale neni mozne ziskat informace
			//o behu

			assert(false);
			return FALSE;
		}
		else
		{
			return res != STILL_ACTIVE;
		}
	}
	else
	{
		//vlakno nebezi
		return TRUE;
	}
}
//OK 2007-08-25 00:22:53 B04-315B\Tom

/** Metoda ukonci provadeni vlakna.
*
*	Pokud vlakno jeste nebylo ukonceno pak metoda prerusi vlakno.
*
*	Metoda vraci TRUE pokud bylo vlakno radne ukonceno.
*
*	Tato metoda by mela byt volana pouze na vlakno, ktere vraci pri metode
*	TThread::IsTerminated() hodnotu TRUE. To znamena, ze funkce vlakna byla ukoncena
*	navratovou hodnotou a vlakno ceka na ukonceni.
*
*	Pokud je metoda volana na vlakno, ktere stale bezi, pak dojde k ukonceni vlakna behem
*	provadeni, coz muze zpusobit napr. neuvolneni synchronizacnich mechanizmu (kriticke sekce, 
*	semafory, apod).
*/
BOOL TThread::Terminate(void)
{
	if(m_thread)
	{
		if( IsTerminated() )
		{
			//vlakno uz bylo ukonceno
			CloseHandle( m_thread );
			m_thread = NULL;
			return TRUE;
		}
		else
		{
			//musime vlakno ukoncit
			TerminateThread(m_thread, 1);
			CloseHandle( m_thread );
			m_thread = NULL;
			return TRUE;
		}
	}
	else
	{
		//vlakno nebylo vubec vytvoreno
		return TRUE;
	}
}
//OK 2007-08-25 00:26:07 B04-315B\Tom

/** Metoda radne ukonci provadeni dokonceneho vlakna.
*
*	Metoda smi byt volana pouze na ukoncene vlakno - tj. kdyz IsTerminated() vraci TRUE.
*	
*	Metoda vraci TRUE pokud bylo vlakno radne ukonceno, jinak FALSE.
*
*	Po uspesnem zavolani teto metody (TRUE) je mozne spustit novou funkci.
*/
BOOL TThread::Finish(void)
{
	if( m_thread )
	{
		if( IsTerminated() )
		{
			//vlakno uz bylo ukonceno
			CloseHandle( m_thread );
			m_thread = NULL;
			return TRUE;
		}
		else
		{
			//vlakno nebylo ukonceno - nic se nedeje
			return FALSE;
		}
	}
	else
	{
		return TRUE;
	}
}
//OK 2007-08-25 00:26:11 B04-315B\Tom

// TThread
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
