/*
*	This file contains class that load images from specified video sequence.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "CameraAbstract/CameraAbstract.h"

#include "VideoDS.h"

//deklarace funkce pro export tridy ven z DLL
extern "C" __declspec(dllexport) TCameraAbstract*	CreateCamera( const char * filename );

namespace NSCameras
{
	class TCameraVideoFile;
};

#ifndef _CAMERAS_VIDEOFILE_HH_
#define _CAMERAS_VIDEOFILE_HH_

namespace NSCameras
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/** Tato trida reprezentuje kameru ziskavajici snimky ze zadaneho video souboru.
*/
class TCameraVideoFile : public TCameraAbstract
{
//PUBLIC OVERRIDEN METHODS
public:
	virtual DWORD				GetDataSize(void);	
	virtual void				GetData(void * dest);	
														

	virtual int					GetWidth(void);			
	virtual int					GetHeight(void);			

	virtual void				Destroy(void);

//PUBLIC STATIC METHODS
public:
	static TCameraVideoFile*	CreateCamera( const char * filename );

//PRIVATE METHODS
private:
	bool						Initialize( const char * filename );

								TCameraVideoFile(void);
								~TCameraVideoFile(void);

								TCameraVideoFile( const TCameraVideoFile & orig );	///< falesny kopirovaci konstruktor
	void						operator=( const TCameraVideoFile & orig );			///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	TVideoDSFile*				m_source;		///< zdroj videa
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSCameras
using namespace NSCameras;

#endif