/*
*	This file contains class that simulates null camera.
*	This camera always return black image with size 640x480.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "StdAfx.h"
#include "CameraNullSrc.h"

#include <cstdlib>
#include <cstring>
#include <cmath>

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraNull

/** Funkce pro vytvoreni tridy a preneseni ven z DLL.
*
*	\note	Muze vratit NULL pri chybe.
*
*	\param	filename	[in] jmeno souboru s obrazkem
*/
extern "C" TCameraAbstract*	CreateCamera(const char * filename)
{
	return TCameraNull::CreateCamera(filename);
}

/** Tato staticka metoda vytvori kameru.
*
*	\note	Vraci NULL pri chybe.
*
*	\param	filename	[in] jmeno souboru s obrazkem
*/
TCameraNull* TCameraNull::CreateCamera(const char * filename)
{
	//vytvorime objekt
	TCameraNull * cam = new TCameraNull;

	//inicializujeme
	if ( cam->Initialize( filename ) )
	{
		//ok - kamera inicializovana v poradku
		return cam;
	}
	else
	{
		//nejaka chyba
		delete cam;
		return NULL;
	}
}

/** Soukromy konstruktor.
*/
TCameraNull::TCameraNull(void)
{
	m_data = NULL;
}

/** Soukromy destruktor.
*/
TCameraNull::~TCameraNull(void)
{
	delete [] m_data;
	m_data = NULL;
}

/** Tato metoda inicializuje tridu po vytvoreni.
*
*	\param	filename	[in] jmeno souboru s nacitanym obrazkem
*/
bool TCameraNull::Initialize( const char * filename)
{
	//naalokuje pamet pro snimek a vyplnime cernou barvou
	m_width = 640;
	m_height = 480;

	m_data = new unsigned char[m_width * m_height * 3];
	memset( m_data, 0, m_width * m_height * 3 );

	return TRUE;
}

/** Velikost obrazku v bajtech.
*/
DWORD TCameraNull::GetDataSize(void)
{
	return this->GetWidth() * this->GetHeight() * 3;
}

/** Ulozi data do pripraveneho bufferu.
*
*	\param	dest	[in out] buffer pro data obrazku
*/
void TCameraNull::GetData(void * dest)
{
	memcpy( dest, m_data, this->GetDataSize() );
}

/** Vrati sirku obrazku v pixelech.
*/
int TCameraNull::GetWidth(void)
{
	return m_width;
}

/** Vrati vysku obrazku v pixelech.
*/
int TCameraNull::GetHeight(void)
{
	return m_height;
}

/** Zrusi tento objekt.
*/
void TCameraNull::Destroy(void)
{
	delete this;
}

// TCameraNull
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
