/*
*	This file contains class that load images from specified file.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/

#include "CameraAbstract/CameraAbstract.h"

//deklarace funkce pro export tridy ven z DLL
extern "C" __declspec(dllexport) TCameraAbstract*	CreateCamera(const char * filename);

// FORWARD DECLARATIONS
namespace NSCameras
{
	class TCameraImage;
};

#ifndef _CAMERAS_CAMERAIMAGE_HH_
#define _CAMERAS_CAMERAIMAGE_HH_

namespace NSCameras
{

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraImage

/** Tato trida reprezentuje kameru ziskavajici snimky ze zadaneho obrazku.
*
*	Trida plne respektuje pravidla bazove tridy TCameraAbstract a proto by manipulace
*	s vytvorenym objektem mela probihat pouze pres bazovou tridu (rozhrani).
*
*	Protoze se jedna o obrazek, data jsou nactena pouze pri inicializaci a dale
*	jsou pouze vracena pri zadostech o vysledek. Trida sam o sobe tedy neni vypocetne
*	narocna. Vyuzit ji lze v situacich, kdy napr. potrebujeme testovat nejaky algoritmus
*	pouze na zadanem obrazku a v budoucnu chceme algoritmus rozsirit na praci s videem.
*
*	\note Trida vyuziva pro nacitani obrazku knihovnu GDI+, takze je vyzadovana jeji pritomnost
*	v systemu.
*/
class TCameraImage : public TCameraAbstract
{
//PUBLIC OVERRIDEN METHODS
public:
	virtual DWORD				GetDataSize(void);	
	virtual void				GetData(void * dest);	
														

	virtual int					GetWidth(void);			
	virtual int					GetHeight(void);			

	virtual void				Destroy(void);

//PUBLIC STATIC METHODS
public:
	static TCameraImage*		CreateCamera(const char * filename);

//PRIVATE METHODS
private:
	bool						Initialize( const char * filename );

								TCameraImage(void);
								~TCameraImage(void);						

								TCameraImage( const TCameraImage & orig );	///< falesny kopirovaci kontruktor
	void						operator=( const TCameraImage & orig );		///< falesny prirazovaci operator

//PRIVATE COMPONENTS
private:
	int							m_width;		///< sirka nacteneho obrazu
	int							m_height;		///< vyska nacteneho obrazu

	unsigned char*				m_data;			///< pixely obrazu	
};

// TCameraImage
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

}; //END of namespace NSCameras
using namespace NSCameras;

#endif