/*
*	This file contains class that load images from specified video sequence.
*
*	Author:
*			Tomas Mrkvicka
*			xmrkvi03@stud.fit.vutbr.cz
*
*/


#include "StdAfx.h"
#include <tchar.h>
#include <strsafe.h>
#include "Camera.h"

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// TCameraDshow

/** Funkce pro vytvoreni tridy a preneseni ven z DLL.
*
*	\warning	Muze vratit NULL pri chybe.
*/
extern "C" TCameraAbstract*	CreateCamera( void )
{
	return TCameraDshow::CreateCamera();
}

/** Tato staticka metoda vytvori kameru.
*
*	\warning	Vraci NULL pri chybe.
*/
TCameraDshow* TCameraDshow::CreateCamera( void )
{
	//vytvorime objekt
	TCameraDshow * cam = new TCameraDshow;

	//inicializujeme
	if ( cam->Initialize() )
	{
		//ok - kamera inicializovana v poradku
		return cam;
	}
	else
	{
		//nejaka chyba
		delete cam;
		return NULL;
	}
}

/** Soukromy konstruktor.
*
*	\warning Pouze vytvori objekt. Inicializace musi probehnout metodou Initialize() !!!
*/
TCameraDshow::TCameraDshow(void)
{
	m_source = NULL;
}

/** Soukromy destruktor.
*/
TCameraDshow::~TCameraDshow(void)
{
	//odstranime pokud je potreba
	if ( m_source )
	{
		m_source->Destroy();
		delete m_source;
		m_source = NULL;
	}
}

/** Tato metoda inicializuje tridu po vytvoreni.
*
*	Vraci TRUE v pripade uspesne inicializace, jinak FALSE.
*/
bool TCameraDshow::Initialize( void )
{
	m_source = new TVideoDSFile;
	if ( m_source->Initialize() )
	{
		return true;
	}
	else
	{
		delete m_source;
		m_source = NULL;
		
		return false;
	}
}

/** Velikost obrazku v bajtech.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*/
DWORD TCameraDshow::GetDataSize(void)
{
	return this->GetWidth() * this->GetHeight() * 3;
}

/** Ulozi data do pripraveneho bufferu.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*
*	\param	dest	[in out] buffer pro data obrazku s minimalni velikosti TCameraDshow::GetDataSize
*/
void TCameraDshow::GetData(void * dest)
{
	m_source->GetDataRGB( dest );
}

/** Vrati sirku obrazku v pixelech.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*/
int TCameraDshow::GetWidth(void)
{
	return m_source->GetWidth();
}

/** Vrati vysku obrazku v pixelech.
*
*	\warning	Objekt musi byt radne inicializovan!!!
*/
int TCameraDshow::GetHeight(void)
{
	return m_source->GetHeight();
}

/** Zrusi tento objekt.
*/
void TCameraDshow::Destroy(void)
{
	delete this;
}

// TCameraDshow
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////