-- Jiri Granat --
-- demonstracni funkcni jednotka klasifikator pro DX64
-- datum 20.10.2007
--
library ieee;
use ieee.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
--use IEEE.std_logic_arith.all;
use ieee.numeric_std.all;
use work.DX64header.all;
-- pragma translate_off
library UNISIM;
use UNISIM.vcomponents.all;
-- pragma translate_on



entity fu is
   generic (
	    WR_SECTORS_C    : natural := 2;
       WR_ADDR_WIDTH_C : natural := 10
   );

   port(
       DspBus : inout DspBus_T;
       Clock : in std_logic;
       AReset : in std_logic;

       -- Port Write
                 -- jeli "0" muze se do sectoru zapisovat,zprava pro DSP - "1" sektor ma platna data
       WrSectorValid   : out unsigned(WR_SECTORS_C-1 downto 0);       
                 -- jeli "1" tak DSP si uz data precetlo
       WrSectorClear   : in  std_logic;
       WrBramAddr      : out unsigned(WR_ADDR_WIDTH_C-1 downto 0);
       WrBramDataOut   : out unsigned(DSP_DATA_WIDTH_C-1 downto 0);
       WrBramWrite     : out std_logic

       );
   end fu;


architecture RTL of fu is
   ---------------------------------------------------------------------------
   -- Components declaration
   ---------------------------------------------------------------------------
   attribute box_type : string;
   component RAMB16_S18_S18
       generic (
           SIM_COLLISION_CHECK : string := "ALL";
           SRVAL_A : bit_vector := X"00000";
           SRVAL_B : bit_vector := X"00000";
           WRITE_MODE_A : string := "READ_FIRST";
           WRITE_MODE_B : string := "READ_FIRST"
       );
       port (
           DOA   : out std_logic_vector(15 downto 0);
           DOB   : out std_logic_vector(15 downto 0);
           DOPA  : out std_logic_vector(1 downto 0);
           DOPB  : out std_logic_vector(1 downto 0);
           ADDRA : in  std_logic_vector(9 downto 0);
           ADDRB : in  std_logic_vector(9 downto 0);
           CLKA  : in  std_ulogic;
           CLKB  : in  std_ulogic;
           DIA   : in  std_logic_vector(15 downto 0);
           DIB   : in  std_logic_vector(15 downto 0);
           DIPA  : in  std_logic_vector(1 downto 0);
           DIPB  : in  std_logic_vector(1 downto 0);
           ENA   : in  std_ulogic;
           ENB   : in  std_ulogic;
           SSRA  : in  std_ulogic;
           SSRB  : in  std_ulogic;
           WEA   : in  std_ulogic;
           WEB   : in  std_ulogic);
   end component;
   attribute box_type of RAMB16_S18_S18 : component is "black_box";
   ---------------------------------------------------------------------------
   -- End components declaration
   ---------------------------------------------------------------------------


   constant DATA_FU : natural := 34;
   constant ADDR_FU : natural := 35;
   constant CONF_FU  : natural := 36;
   constant SIZE_FU : natural := 37;
   
   --constant KOEF_FU : natural := 38;
   --constant ALPHA_FU : natural := 39;
   --constant R_FU : natural := 40;
   
   
   constant DATA_WIDTH_C : natural := 16;
   -- definuje kolik segmentu se ma ve vyrezu pocitat
   constant SEGMENT_COUNT : natural := 223;
   -- definuje kolik sl. klasifikatoru se bude pocitat
   -- nesmi byt vetsi nez maximalni pocet sl. klasifikatoru
   constant WEAK_COUNT : natural := 183;--183;



   type T_REG is array(3 downto 0) of std_logic_vector (15 downto 0);
   type T_ROM is array(6 downto 0) of std_logic_vector(23 downto 0);
   type T_KOEF is array (1 downto 0) of std_logic_vector(39 downto 0);
   type T_ALPHA is array (1 downto 0) of std_logic_vector(23 downto 0);
   type T_R is array(1 downto 0) of signed (15 downto 0);
   
   type tt_reg is array(1 downto 0) of std_logic_vector (15 downto 0);  
   
   

   signal cnt_mem       : std_logic_vector(15 downto 0);
	signal cnt_mem_ce    : std_logic;
	signal reg_status_fu : std_logic_vector(15 downto 0);
	signal control_word  : std_logic_vector(15 downto 0);
   signal rom : T_ROM;
   signal koef : T_KOEF;
   signal reg : T_REG;
   signal alpha : T_ALPHA;
   signal r : T_R;

   -- signaly automatu
   type fsm_state is (
       INIT,ADDR,SIZEDATA,LOAD,LOAD_INIT,COUNT,MEM,THIRD   );
   type fsm_state_cnt is (
       LD,LD1,LD2,DEC,EX
   );

   signal curr_state,next_state : fsm_state;
   signal curr_state_cnt,next_state_cnt : fsm_state_cnt;
	
	signal status_fu : std_logic_vector (15 downto 0);
   
   -- configuracni registry
   signal vectorA : std_logic_vector (15 downto 0); 
   signal vector12 : tt_reg;
   signal alpha1 : std_logic_vector (15 downto 0);
   signal alpha2 : std_logic_vector (15 downto 0);
   signal r_thr : std_logic_vector (15 downto 0);
   
   -- rizeni nacitani z confBram
   --signal conf_en : std_logic;
   signal conf_res : std_logic;
   signal conf_addr : std_logic_vector(2 downto 0);
   signal seg_conf_addr : std_logic_vector(10 downto 0);
	signal conf_addr_cnt  : std_logic_vector(10 downto 0);


   signal reg_acc : std_logic_vector(16 downto 0);
   signal acc : std_logic_vector(16 downto 0);
   signal mxacc : std_logic_vector(16 downto 0);


   signal reg_treshold : signed(15 downto 0);
   signal treshold : signed(15 downto 0);
           
   --informuje o skutecnosti ze neni v tomto seg nutne dal hledat
   signal nfind : std_logic;
   signal find : std_logic;
   
   signal next_seg : std_logic;
   signal next_seg_1 : std_logic;
   
   signal r_shift : std_logic_vector(1 downto 0);
   
   signal loads : std_logic;
   signal loada : std_logic;
   signal decode : std_logic;
   signal execute : std_logic;
   
   signal addr_en : std_logic;
   signal find_en : std_logic;
   signal koaddr_en : std_logic;   
   
   signal koaddr_end : std_logic;
   signal segment_end : std_logic;
   signal cnt_end : std_logic;
   signal cnt : std_logic;
   signal jmp : std_logic;
   
   signal findregister : std_logic_vector(15 downto 0);

   signal pc : natural range 0 to 255:=0;
   signal koaddr : std_logic_vector(7 downto 0);
   signal segment : std_logic_vector(7 downto 0);
   -- adresa do memoryportu
   signal memaddr : unsigned(WR_ADDR_WIDTH_C-1 downto 0);
   signal mem_end : std_logic;
   signal mem_end_1 : std_logic;
   signal mem_valid : std_logic;
   signal mem_clear : std_logic;

   
   -- instrukcni slovo
   signal inst : std_logic_vector(23 downto 0);

   --signaly RAM Pic
   type BramDataoutArr_T is array (0 to 7) of std_logic_vector(15 downto 0);
   signal brama_dataout :  BramDataoutArr_T;
   signal bramb_dataout :  BramDataoutArr_T;
   signal brama_dataout_or : std_logic_vector(15 downto 0);
   signal bramb_dataout_or : std_logic_vector(15 downto 0);
   signal brama_datain : std_logic_vector(15 downto 0);
   signal brama_addr : std_logic_vector(9 downto 0);
   signal brama_rd_nselect : unsigned(7 downto 0);
   signal brama_wr_select : unsigned(7 downto 0);
   
   --signaly RAM Conf
   type ConfDataoutArr_T is array (0 to 1) of std_logic_vector(15 downto 0);
   signal confa_dataout :  ConfDataoutArr_T;
   signal confb_dataout :  ConfDataoutArr_T;
   signal confa_dataout_or : std_logic_vector(15 downto 0);
   signal confb_dataout_or : std_logic_vector(15 downto 0);
   signal confa_datain : std_logic_vector(15 downto 0);
   signal confa_addr : std_logic_vector(9 downto 0);
   signal confa_rd_nselect : unsigned(1 downto 0);
   signal confa_wr_select : unsigned(1 downto 0);
   
   
   -- registr pro data vypisovana pres sbernici DSPBus
   signal data_out : unsigned(15 downto 0);


   --signaly od DSP
   signal sel_data : std_logic;
   signal sel_addr : std_logic;   
   signal sel_size : std_logic;
   signal sel_conf : std_logic;   
   
   

   --12 az 10 vyber BRAM 1 ze 8, 9 az 0 adresa do BRAM
   signal fu_addr : std_logic_vector(12 downto 0);
   signal dsp_addr : unsigned(12 downto 0);
   -- ukazatel do cyklickeho bufferu
   signal adr_cycl_buff : std_logic_vector(12 downto 0);

   -- pro prenos dat do BRAM
   -- velikost bloku
   signal size : std_logic_vector(12 downto 0);
   -- pocet prenesenych slov
   signal cnt_size : std_logic_vector(12 downto 0);	
	


   begin
	
	

 -----------------------------------------------------------------------------------------------
 -- BRAM instance ------------------------------------------------------------------------------
 -----------------------------------------------------------------------------------------------
   Memory_Pic: for i in 0 to 7 generate


       -----------------------------------------------------------------------
       -- DATA_WIDTH_C = 16
       -----------------------------------------------------------------------
       MemoryWidth16_Pic: if DATA_WIDTH_C = 16 generate

           RAMB16_S18_S18_G : RAMB16_S18_S18
               generic map (
                   SRVAL_A  => X"0000",
                   SRVAL_B  => X"0000",
                   WRITE_MODE_A => "WRITE_FIRST",
                   WRITE_MODE_B => "WRITE_FIRST"
               )
               port map (
                   DOA   => brama_dataout(i),
                   DOB   => bramb_dataout(i),
                   DOPA  => OPEN,
                   DOPB  => OPEN,
                   ADDRA => brama_addr,
                   ADDRB => brama_addr,
                   CLKA  => Clock,
                   CLKB  => Clock,
                   DIA   => brama_datain,
                   DIB   => brama_datain,
                   DIPA  => "00",
                   DIPB  => "00",
                   ENA   => '1',
                   ENB   => '0',
                   SSRA  => brama_rd_nselect(i),
                   SSRB  => '1',
                   WEA   => brama_wr_select(i),
                   WEB   => '1'
               );
       end generate MemoryWidth16_Pic;

   end generate Memory_Pic;
   
   Memory_Conf: for i in 0 to 1 generate


       -----------------------------------------------------------------------
       -- DATA_WIDTH_C = 16
       -----------------------------------------------------------------------
       MemoryWidth16_Conf: if DATA_WIDTH_C = 16 generate

           RAMB16_S18_S18_G : RAMB16_S18_S18
               generic map (
                   SRVAL_A  => X"0000",
                   SRVAL_B  => X"0000",
                   WRITE_MODE_A => "WRITE_FIRST",
                   WRITE_MODE_B => "WRITE_FIRST"
               )
               port map (
                   DOA   => confa_dataout(i),
                   DOB   => confb_dataout(i),
                   DOPA  => OPEN,
                   DOPB  => OPEN,
                   ADDRA => confa_addr,
                   ADDRB => confa_addr,
                   CLKA  => Clock,
                   CLKB  => Clock,
                   DIA   => confa_datain,
                   DIB   => confa_datain,
                   DIPA  => "00",
                   DIPB  => "00",
                   ENA   => '1',
                   ENB   => '0',
                   SSRA  => confa_rd_nselect(i),
                   SSRB  => '1',
                   WEA   => confa_wr_select(i),
                   WEB   => '1'
               );
       end generate MemoryWidth16_Conf;

   end generate Memory_Conf;
 ------------------------------------------------------------------------------------------------
 --- end BRAM instance --------------------------------------------------------------------------
 ------------------------------------------------------------------------------------------------

     --ridici mikroprogram
   rom(0) <= X"710000";
   rom(1) <= X"550000";
   rom(2) <= X"600000";
   rom(3) <= X"511000";
   rom(4) <= X"651000";
   rom(5) <= X"580000";
   rom(6) <= X"480000";
        


 ----------------------------------------------------------------------------------------------
 -- FSM present state register ----------------------------------------------------------------
 ----------------------------------------------------------------------------------------------

   sync_logic : process(Clock, AReset)
   begin
     if (AReset = '1') then
       curr_state <= INIT;
     elsif (Clock'event AND Clock = '1') then
       curr_state <= next_state;
     end if;
   end process sync_logic;

   sync_logic_cnt : process(Clock, AReset)
   begin
     if (AReset = '1') then
       curr_state_cnt <= LD;
     elsif (Clock'event AND Clock = '1') then
       curr_state_cnt <= next_state_cnt;
     end if;
   end process sync_logic_cnt;

  -------------------------------------------------------------------------
  -- FSM next state logic -------------------------------------------------
  -------------------------------------------------------------------------

  next_state_logic : process(curr_state,sel_addr,sel_data,sel_size,DspBus,cnt_end)
  begin
    case curr_state is
      -- ------------------------------------------
      when INIT =>
          if (sel_addr = '1' and DspBus.Write = '1') then
              next_state <= ADDR;
          else
              next_state <= INIT;
          end if;
      -- ------------------------------------------
      when ADDR =>
          if (sel_size = '1' and DspBus.Write = '1') then
              next_state <= SIZEDATA;
          else
              next_state <= ADDR;
          end if;
      -- ------------------------------------------
      when SIZEDATA =>
          if (DspBus.Write = '1') then
            if(sel_conf = '1') then
              next_state <= LOAD_INIT;
            elsif(sel_data = '1') then
              next_state <= LOAD;
				else
              next_state <= SIZEDATA;
            end if;
          else
              next_state <= SIZEDATA;
          end if; 
      -- ------------------------------------------
      when LOAD_INIT =>
          if (cnt_size < size) then

              next_state <= LOAD_INIT;
          else
              next_state <= INIT;
          end if; 
      -- ------------------------------------------
      when LOAD =>
          if (cnt_size < size) then

              next_state <= LOAD;
          else
              next_state <= COUNT;
          end if;
      -- ------------------------------------------
      when COUNT =>
          if (cnt_end = '1') then
              next_state <= MEM;
          else
              next_state <= COUNT;
          end if;
      -- ------------------------------------------
      when MEM =>
          --if (1) then
              next_state <= THIRD;
          --end if;
      -- ------------------------------------------
      when THIRD =>
          --if (1) then
              next_state <= INIT;
          --end if;
      -- ------------------------------------------
    end case;
  end process next_state_logic;

  next_state_logic_cnt : process(curr_state,curr_state_cnt,jmp,find)
  begin
    case curr_state_cnt is
      -- ------------------------------------------
      when LD =>
          if (curr_state = COUNT) then
              --if(find = '1')then
                --next_state_cnt <= LD;
              --else    
                next_state_cnt <= LD1;
              --end if;
          else
              next_state_cnt <= LD;
          end if;
      -- ------------------------------------------
      when LD1 =>
          if (curr_state = COUNT) then
              next_state_cnt <= LD2;
          else
              next_state_cnt <= LD1;
          end if;
      -- ------------------------------------------
      when LD2 =>
          if (curr_state = COUNT) then
              next_state_cnt <= DEC;
          else
              next_state_cnt <= LD2;
          end if;
      -- ------------------------------------------
      when DEC =>
          if (curr_state = COUNT) then
              next_state_cnt <= EX;
          else
              next_state_cnt <= LD;
          end if;
      -- ------------------------------------------
      when EX =>
          if (curr_state = COUNT) then
            if (jmp = '1' ) then
              next_state_cnt <= LD;
            else
              next_state_cnt <= DEC;
            end if;
          else
              next_state_cnt <= LD;
          end if;
      -- ------------------------------------------
    end case;
  end process next_state_logic_cnt;

------------------------------------------------------------------------------------------------
-- Vypocty -------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------

  -- Nacitani instrukci ---------------------------------------------------
  inst <= rom(pc);
  

  -- vystupni logika stavoveho automatu -----------------------------------
  output_logic : process(curr_state)
  begin
      cnt <= '0';      
      mem_end <= '0';		
		status_fu <= (others => '0'); 
		
		
      case curr_state is
      -- ------------------------------------------
        when INIT => status_fu(15) <= '1';
      -- ------------------------------------------
        when ADDR => status_fu(14) <= '1';
      -- ------------------------------------------
        when SIZEDATA => status_fu(13) <= '1';
      -- ------------------------------------------
        when LOAD_INIT => status_fu(12) <= '1';
      -- ------------------------------------------
        when LOAD => status_fu(11) <= '1';
      -- ------------------------------------------
        when COUNT =>
		      status_fu(10) <='1';
            cnt <= '1';
      -- ------------------------------------------
        when MEM =>
		    status_fu(9) <= '1';
			
          mem_end <= '1';          
      -- ------------------------------------------
        when THIRD => status_fu(8) <= '1';

      -- ------------------------------------------

      end case;
  end process output_logic;
  
  
--------------------------------------------------------------------------------------
-------------------------------- testovani -------------------------------------------
  outputmartin_logic : process(curr_state_cnt)
  begin
       
		cnt_mem_ce <= '0';
		
      case curr_state_cnt is
      -- ------------------------------------------
       
        when EX =>
		   
			 cnt_mem_ce <= '1';
              
      -- ------------------------------------------
        when others =>
      -- ------------------------------------------
      end case;
  end process;
  
  process(Clock, Areset)
  begin
  if (Areset = '1') then 
      reg_status_fu <= (others => '0');
	elsif (clock'event and clock='1') then
	     for i in 0 to 15 loop
		      if (status_fu(i) = '1') then
	            reg_status_fu(i) <= '1';
				end if;
		  end loop;
  end if;
  end process;
  
  process(Clock, Areset)
  begin
  if (Areset = '1') then 
      cnt_mem <= (others => '0');
  elsif (clock'event and clock='1') then
     if (cnt_mem_ce = '1') then
	     cnt_mem <= cnt_mem + 1;
	  end if;
  end if;
  end process;
  
  control_word <= cnt_mem;
  
--------------------------------------------------------------------------------------
-------------------------------- testovani -------------------------------------------
---------------------------------- konec ---------------------------------------------


  output_logic_cnt : process(curr_state_cnt,inst,koaddr_end,nfind,segment_end)
  begin
      loada <= '0';
      loads <= '0';
      decode <= '0';
      execute <= '0';
      addr_en <= '0';
      koaddr_en <= '0';
      next_seg <= '0';
      cnt_end <= '0';
      jmp <= '0';
      find_en <= '0';
      case curr_state_cnt is
      -- ------------------------------------------
        when LD =>
            loads <= '1';        
            
        when LD1 =>    
      -- ------------------------------------------
        when LD2 =>
            loada <= '1';
            addr_en <= '1';
      -- ------------------------------------------
        when DEC =>
            decode <= '1';
            cnt_end <= '0';
      -- ------------------------------------------
        when EX =>
            execute <= '1';
            addr_en <= '1';
            if (inst(23 downto 20) = "0100" ) then
                koaddr_en <= '1';
                jmp <= '1';
                find_en <= '1';                                         

                if (koaddr_end = '1') or (nfind = '1') then
                    next_seg <= '1';
                    if (segment_end = '1') then
                        cnt_end <= '1';
                    end if;
                end if;
            end if;
      -- ------------------------------------------
      end case;
  end process output_logic_cnt;


  
  
-- Spozdovaci prvek pro next_seg -----------------------------------------  
  process (Clock, AReset)  
  begin    
    if (AReset = '1') then
       next_seg_1 <=  '0';
		 mem_end_1 <= '0';
    elsif (Clock = '1' and Clock'event) then
      -- ------------------------------------------         
         next_seg_1 <= next_seg;
         mem_end_1 <= mem_end;
      -- ------------------------------------------
    end if;
  end process;
   
   

-- Predani vysledku do memoryportu -----------------------------------
  send_mem_port : process(Clock, AReset)
  begin
      if (AReset = '1') then
          memaddr <= (others => '0');
      elsif (Clock = '1' and Clock'event) then
        -- ------------------------------------------
        if (nfind = '1' and next_seg_1 = '1') then
          memaddr <= memaddr + 1;
        elsif (mem_end_1 = '1') then
          memaddr <= (others => '0');
        end if;
        -- ------------------------------------------
      end if;
  end process send_mem_port;

  -- Validita memory portu ----------------------------------------------
  valid_mem_port : process(Clock, AReset)
  begin
      if (AReset = '1') then
          mem_valid <= '0';
			 --status_fu(9) <= '0';
      elsif (Clock = '1' and Clock'event) then
        -- ------------------------------------------
        if (mem_clear = '1') then
          mem_valid <= '0';	
          --status_fu(9) <= '1';			 
        elsif  (mem_end_1 = '1') then		    
          mem_valid <= '1';		  
        end if;
        -- ------------------------------------------
      end if;
  end process valid_mem_port;
  -- pevna prirazeni -------------------------------------------------------
  WrBramDataOut <= "00000000" & unsigned(segment) when mem_end_1 = '0' else X"ffff"; 
  --WrBramDataOut <= unsigned(reg_acc(15 downto 0)) when mem_end_1 = '0'; --else X"ffff"; 
  WrBramAddr <= memaddr;  --"0" & (unsigned(koaddr)+unsigned(segment & '0'));
  WrBramWrite <= '1' when (nfind = '1' and next_seg_1 = '1') or (mem_end_1 = '1') else '0';
  --WrBramWrite <= '1' when (jmp = '1') or (mem_end_1 = '1') else '0';
  --WrBramWrite <= '1' when jmp = '1'  else '0';
  WrSectorValid(0) <= mem_valid;
  WrSectorValid(WR_SECTORS_C-1 downto 1) <= (others => '0');   
  mem_clear <= WrSectorClear;
  
  
  -- generovani adresy pro vytvoreni cyklickeho bufferu --------------------------
  gen_cycl_buff : process(Clock,AReset)
  begin
      if (AReset = '1') then
          adr_cycl_buff <= (others => '0');
      elsif (Clock'event and Clock = '1') then
          -- ------------------------------------------
          if (mem_end = '1') then  
              -- zmena 256 -> 512			 
              adr_cycl_buff <= adr_cycl_buff + 512;            
			 else
			     adr_cycl_buff <= adr_cycl_buff;
          end if;          
          
          -- ------------------------------------------
      end if;
  end process gen_cycl_buff;


  -- Generovani adres pro BRAM --------------------
  gen_fu_addr : process (Clock, AReset)
  begin
    if (AReset = '1') then
      fu_addr <= (others => '0');
    elsif Clock='1' and Clock'event then
      -- ------------------------------------------
      if (addr_en = '1') then
        if (loada = '1') then
           -- pridani adr_cycl_buff -> rizeni cyklickeho bufferu
           fu_addr <= adr_cycl_buff + segment + vectorA(12 downto 0);
			  --fu_addr <= segment + vectorA(12 downto 0);
        elsif (inst(19) = '0') then
           if (inst(12) = '0') then
              fu_addr <= fu_addr + vector12(to_integer(unsigned(inst(17 downto 16))))(12 downto 0);
           else
              fu_addr <= fu_addr - vector12(to_integer(unsigned(inst(17 downto 16))))(12 downto 0);
           end if;
        end if;
      end if;
      -- ------------------------------------------
    end if;
  end process gen_fu_addr;

  -- Generovani adresy slabeho klasifikatoru -------------
  gen_koaddr : process (Clock, AReset)
  begin
    if (AReset = '1') then
      koaddr <= (others => '0');  
      seg_conf_addr <= (others => '0');              
    elsif (Clock = '1') and Clock'event then
      -- ------------------------------------------
      if (koaddr_en = '1') then
        if (next_seg = '1') then
           koaddr <= (others => '0');  
           seg_conf_addr <= (others => '0');                            
        else
           koaddr <= koaddr + 1;
           seg_conf_addr <= seg_conf_addr + 6;                               
        end if;
      end if;
      -- ------------------------------------------
    end if;
  end process gen_koaddr;

  koaddr_end <= '1' when (koaddr = WEAK_COUNT) else '0';
  
  -- Generovani adresy pro ziskani featur z confBram -------------
  gen_conf_addr : process (Clock, AReset)
  begin
    if (AReset = '1') then
      conf_addr <= (others => '0');                
    elsif (Clock = '1') and Clock'event then
      -- ------------------------------------------
      if (cnt = '1') then
        if (conf_res = '1' or jmp = '1') then
           conf_addr <= (others => '0');                               
        else
           conf_addr <= conf_addr + 1;                               
        end if;
      end if;
      -- ------------------------------------------
    end if;
  end process gen_conf_addr;
  
  conf_res <= '1' when conf_addr = "101" else '0';

  -- Generovani adresy segmentu ve vyrezu -----------------
  gen_segment : process (Clock, AReset)
  begin
    if AReset = '1' then
      segment <= (others => '0');                
    elsif Clock = '1' and Clock'event then
      -- ------------------------------------------
      if (mem_end_1 = '1' ) then
         segment <= (others => '0');
      end if; 
      if (next_seg_1 = '1') then
		   -- zmena 1 -> 2
         segment <= segment + 2;                               
      end if;      
    -- ------------------------------------------
    end if;
  end process gen_segment;
  
  -- zmena =  -> >=
  segment_end <= '1' when (segment >= SEGMENT_COUNT) else '0';


  -- generovani programoveho citace --------------------------
  gen_pc : process(Clock,AReset)
  begin
      if (AReset = '1') then
          pc <= 0;
      elsif (Clock'event and Clock = '1') then
          -- ------------------------------------------
          if (execute = '1') then
            if (jmp = '1') then
              pc <= 0;
            else
              pc <= pc + 1;
            end if;
          end if;
          
          if (find= '1')then
              pc <= 0;
          end if;
          -- ------------------------------------------
      end if;
  end process gen_pc;



  ----------------------------------------------------------------------------------------------
  -- Provedeni instrukci -----------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------

  alu_dec : process(Clock,AReset)
  begin
      if AReset = '1' then
          reg_treshold <= (others => '0');
      elsif (Clock'event and Clock = '1') then
          -- ------------------------------------------
          if(next_seg_1 = '1')then
              reg_treshold <= (others => '0');
          elsif(inst(23 downto 20) = "0100" and decode = '1' )then
              reg_treshold <= treshold;
          else
              reg_treshold <= reg_treshold;
          end if;
          -- ------------------------------------------
      end if;
  end process alu_dec;  


  --treshold <= reg_treshold + signed(alpha2) when reg_acc(16)='0' else
    treshold <= reg_treshold + signed(alpha2) when reg_acc(15)='0' else
              reg_treshold + signed(alpha1);



--------------------------------------------------------------------------------------------------
-- Faze execute ----------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------
  count_ex : process(Clock,AReset)
  begin
     if AReset = '1' then
          reg_acc <= (others => '0');
     elsif (Clock'event and Clock = '1') then
          -- ------------------------------------------
          if (execute = '1')then
            reg_acc <= acc;
			 else
			   reg_acc <= reg_acc;
          end if;
          -- ------------------------------------------
     end if;
  end process count_ex;


  mxacc <= '0' & brama_dataout_or when inst(18) = '0' else
                 brama_dataout_or & '0';
       --mxacc <= X"0001";

  with inst(23 downto 20) select
     acc <= reg_acc + mxacc when "0110",
            reg_acc - mxacc when "0101",
            mxacc           when "0111",
            reg_acc         when others;

  -------------------------------------------------------------------------
  treshold_ex : process(Clock,AReset)
  begin
     if AReset = '1' then
          nfind <= '0';
          find <= '0';
     elsif (Clock'event and Clock = '1') then
     -- ------------------------------------------
       nfind <= '0';
       find <= '0';
       if (find_en = '1') then         
			if (reg_treshold > signed(r_thr)) then  
           nfind <= '1';
           find <= '0';
         else
           nfind <= '0';
           find <= '1';
         end if;
       end if;
       -- ------------------------------------------
     end if;
  end process treshold_ex;

--------------------------------------------------------------------------------------------------
-- Naplneni koeficientu definujicich featury z confBram  -----------------------------------------------------------
--------------------------------------------------------------------------------------------------
load_config : process(Clock,AReset)
begin
    if (AReset = '1') then
             vectorA <= (others => '0');
             vector12(1) <= (others => '0'); -- v1
             vector12(0) <= (others => '0'); -- v2
             alpha1 <= (others => '0');
             alpha2 <= (others => '0');
             r_thr <= (others => '0');
    elsif (Clock'event and Clock = '1') then
       case conf_addr is
          when "001" => vectorA <= confa_dataout_or;
          when "010" => vector12(1) <= confa_dataout_or;
          when "011" => vector12(0) <= confa_dataout_or;
          when "100" => alpha1 <= confa_dataout_or;
          when "101" => alpha2 <= confa_dataout_or;
          when "000" => r_thr <= confa_dataout_or;
          when others => null;       
       end case;
    end if;    
end process load_config;


--------------------------------------------------------------------------------------------------
-- Prenos dat do a z funkcni jednotky ------------------------------------------------------------
--------------------------------------------------------------------------------------------------

  transfer_in : process(Clock,AReset)
  begin
      if (AReset = '1') then
              dsp_addr <= (others => '0');
              cnt_size <= (others => '0');
      elsif (Clock'event and Clock='1') then
          if (DspBus.Write = '1' and sel_addr = '1') then
              dsp_addr <= DspBus.DataIn(12 downto 0);
          elsif (DspBus.Write = '1' and (sel_data = '1' or sel_conf = '1'))  then
              dsp_addr <= dsp_addr + 1;
              cnt_size <= cnt_size + 1;
          elsif (DspBus.Write = '1' and sel_size = '1') then
              size <= std_logic_vector(DspBus.DataIn(12 downto 0));
              cnt_size <= (others => '0');
          end if;
      end if;

  end process transfer_in;
  
  -- vystup testovacich hodnout pres DspBus
  transfer_out : process(Clock,AReset)
   begin
      if AReset = '1' then

      elsif Clock'event and Clock='1' then
          if (DspBus.Read = '1') and (sel_data = '1') then
            data_out <= "000" & unsigned(adr_cycl_buff);				
            --data_out <= "000" & unsigned(size);
            --data_out <= "000000" & unsigned(brama_addr);          
          else   -- pridat same nuly
            data_out <= (others => '0');
          end if;
      end if;
   end process transfer_out;

   DspBus.DataOut <= data_out;
   
      
   
--------------------------------------------------------------------------------------------------
-- vyber 1 z N BRAM pic a conf --------------------------------------------------
--------------------------------------------------------------------------------------------------


   BramSelect : process(DspBus,sel_data,dsp_addr,fu_addr,brama_wr_select)
   variable  sel : natural;
   begin
      if (curr_state = LOAD) then
        sel := to_integer( dsp_addr(12 downto 10) );
      else
        sel := to_integer(unsigned( fu_addr(12 downto 10) ));
      end if;
      brama_wr_select     <= (others => '0');
      brama_rd_nselect    <= (others => '1');
      brama_wr_select(sel) <= DspBus.Write and sel_data;
      brama_rd_nselect(sel) <= brama_wr_select(sel);
   end process BramSelect;
   
   ConfSelect : process(DspBus,sel_conf,dsp_addr,conf_addr_cnt,confa_wr_select)
   variable  sel : natural;
   begin
      if (curr_state = LOAD_INIT) then
        sel :=  to_integer( dsp_addr(10 downto 10) );
      else
        sel := to_integer(unsigned( conf_addr_cnt(10 downto 10) ));

      end if;
      confa_wr_select     <= (others => '0');
      confa_rd_nselect    <= (others => '1');      
      confa_wr_select(sel) <= DspBus.Write and sel_conf;
      confa_rd_nselect(sel) <= confa_wr_select(sel);
      
   end process ConfSelect;
   
   
--------------------------------------------------------------------------------------------------
-- pevna prirazeni pro ovladani BRAM pic a conf --------------------------------------------------
--------------------------------------------------------------------------------------------------
   --bram
   brama_datain  <= std_logic_vector(DspBus.DataIn);
   brama_addr <=  std_logic_vector(dsp_addr(9 downto 0)) when cnt = '0' else fu_addr(9 downto 0);
   --conf
   confa_datain  <= std_logic_vector(DspBus.DataIn);
   conf_addr_cnt <=  std_logic_vector(dsp_addr(10 downto 0)) when cnt = '0' 
                   else seg_conf_addr + conf_addr;
   confa_addr <= conf_addr_cnt(9 downto 0);

   
   
	
	

--------------------------------------------------------------------------------------------------
-----  vystup z pameti Bram pro pic a conf -------------------------------------------------------
--------------------------------------------------------------------------------------------------
   BramDataout_P: process (brama_dataout, bramb_dataout)
       variable brama_t    : std_logic_vector(15 downto 0);
       variable bramb_t    : std_logic_vector(15 downto 0);
   begin
       brama_t := (others => '0');
       bramb_t := (others => '0');
       for i in 0 to 7 loop
           bramb_t     := bramb_t OR bramb_dataout(i);
           brama_t     := brama_t OR brama_dataout(i);
       end loop;
       bramb_dataout_or <= bramb_t;
       brama_dataout_or <= brama_t;
   end process BramDataout_P;
   
   ConfDataout_P: process (confa_dataout, confb_dataout) 
   begin      
       confa_dataout_or <= confa_dataout(0) OR confa_dataout(1);
       confb_dataout_or <= confb_dataout(0) OR confb_dataout(1);
   end process ConfDataout_P;
--------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------------------------
-- Address decoder -------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------
        sel_data  <= '1' when DspBus.Addr = DATA_FU else '0';
        sel_addr  <= '1' when DspBus.Addr = ADDR_FU else '0';        
        sel_conf  <= '1' when DspBus.Addr = CONF_FU else '0';        
        sel_size  <= '1' when DspBus.Addr = SIZE_FU else '0';
        
        
--------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------


end RTL;