
#ifndef __BUILD_IN_H
#define __BUILD_IN_H

// - count of build in structures -
const unsigned c_bi_struct_cnt = 15;
const unsigned c_bi_operator_cnt = 38;
const unsigned c_bi_function_cnt = 37;
const unsigned c_bi_all_cnt = c_bi_struct_cnt + c_bi_operator_cnt + c_bi_function_cnt;

// - n_idx - indexes of build int symbols -
enum {
   
   // - structures -
   c_bi_struct_blank_s,
   c_bi_struct_char_s,
   c_bi_struct_short_s,
   c_bi_struct_int_s,
   c_bi_struct_double_s,
   c_bi_struct_color_s,
   c_bi_struct_thread_s,
   c_bi_struct_string_s,
   c_bi_struct_local_img_s,
   c_bi_struct_char_array_s,
   c_bi_struct_int_array_s,
   c_bi_struct_double_array_s,
   c_bi_struct_obj_array_s,
   c_bi_struct_mutex_s,
   c_bi_struct_condition_s,

   // - operators -
   c_operator_binary_equal,
   c_operator_binary_plus_equal,
   c_operator_binary_minus_equal,
   c_operator_binary_asterisk_equal,
   c_operator_binary_slash_equal,
   c_operator_binary_percent_equal,
   c_operator_binary_double_ls_br_equal,
   c_operator_binary_double_rs_br_equal,
   c_operator_binary_ampersand_equal,
   c_operator_binary_pipe_equal,
   c_operator_binary_circumflex_equal,
   c_operator_binary_double_ampersand,
   c_operator_binary_double_pipe,
   c_operator_binary_ampersand,
   c_operator_binary_pipe,
   c_operator_binary_circumflex,
   c_operator_binary_double_equal,
   c_operator_binary_exclamation_equal,
   c_operator_binary_rs_br,
   c_operator_binary_ls_br,
   c_operator_binary_rs_br_equal,
   c_operator_binary_ls_br_equal,
   c_operator_binary_double_rs_br,
   c_operator_binary_double_ls_br,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_operator_binary_slash,
   c_operator_binary_percent,
   c_operator_unary_post_double_plus,
   c_operator_unary_post_double_minus,
   c_operator_unary_pre_double_plus,
   c_operator_unary_pre_double_minus,
   c_operator_unary_pre_plus,
   c_operator_unary_pre_minus,
   c_operator_unary_pre_exclamation,
   c_operator_unary_pre_tilde,
   c_operator_binary_le_br_re_br,

   // - functions -
   c_function_die_1,
   c_function_sys_enable_1,
   c_function_sys_disable_1,
   c_function_thread_self_0,
   c_function_print_1,
   c_function_color_3,
   c_function_join_0,
   c_function_detach_0,
   c_function_lock_0,
   c_function_trylock_0,
   c_function_unlock_0,

   c_function_wait_0,
   c_function_wait_1,
   c_function_timed_wait_1,
   c_function_signal_0,
   c_function_signal_1,
   c_function_broadcast_0,

   c_function_print_0,
   c_function_length_0,
   c_function_width_0,
   c_function_height_0,
   c_function_type_0,
   c_function_push_1,
   c_function_pop_0,
   c_function_get_idx_1,
   c_function_to_string_0,
   c_function_split_1,
   c_function_join_1,
   c_function_load_bmp_file_1,
   c_function_save_bmp_file_1,
   c_function_invert_0,
   c_function_gray_scale_0,
   c_function_edge_sobel_0,
   c_function_blur_0,
   c_function_sharp_0,
   c_function_treshold_1,
   c_function_fill_1,
};

// - indexes of name-spaces of build in symbols -
enum {
   c_bis_blank_s_record_idx = 1,
   c_bis_char_s_record_idx,
   c_bis_short_s_record_idx,
   c_bis_int_s_record_idx,
   c_bis_double_s_record_idx,
   c_bis_color_s_record_idx,
   c_bis_thread_s_record_idx,
   c_bis_string_s_record_idx,
   c_bis_local_img_s_record_idx,
   c_bis_char_array_s_record_idx,
   c_bis_int_array_s_record_idx,
   c_bis_double_array_s_record_idx,
   c_bis_obj_array_s_record_idx,
   c_bis_mutex_s_record_idx,
   c_bis_condition_s_record_idx,
};

/*
 * base index for calling of build in functions
 */

const unsigned c_build_in_call_base = 0xffff0000;

/*
 * build in global functions
 */

// - function count -
const unsigned c_bi_global_method_cnt = 6;
const unsigned c_bi_global_method_base = c_build_in_call_base;

// - indexes of function names -
const unsigned c_bi_global_method_n_idxs[c_bi_global_method_cnt] = {
   c_function_die_1,
   c_function_sys_enable_1,
   c_function_sys_disable_1,
   c_function_thread_self_0,
   c_function_print_1,
   c_function_color_3,
};

/*
 * build in structure blank_s
 */

// - method count -
const unsigned c_bis_blank_s_method_cnt = 2;
const unsigned c_bis_blank_s_method_base = c_bi_global_method_base + c_bi_global_method_cnt;

// - indexes of method names -
const unsigned c_bis_blank_s_method_n_idxs[c_bis_blank_s_method_cnt] = {
   c_operator_binary_equal,
   c_function_type_0,
};

/*
 * build in structure char_s
 */

// - method count -
const unsigned c_bis_char_s_method_cnt = 40;
const unsigned c_bis_char_s_method_base = c_bis_blank_s_method_base + c_bis_blank_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_char_s_method_n_idxs[c_bis_char_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_plus_equal,
   c_operator_binary_minus_equal,
   c_operator_binary_asterisk_equal,
   c_operator_binary_slash_equal,
   c_operator_binary_percent_equal,
   c_operator_binary_double_ls_br_equal,
   c_operator_binary_double_rs_br_equal,
   c_operator_binary_ampersand_equal,
   c_operator_binary_pipe_equal,
   c_operator_binary_circumflex_equal,
   c_operator_binary_double_ampersand,
   c_operator_binary_double_pipe,
   c_operator_binary_ampersand,
   c_operator_binary_pipe,
   c_operator_binary_circumflex,
   c_operator_binary_double_equal,
   c_operator_binary_exclamation_equal,
   c_operator_binary_rs_br,
   c_operator_binary_ls_br,
   c_operator_binary_rs_br_equal,
   c_operator_binary_ls_br_equal,
   c_operator_binary_double_rs_br,
   c_operator_binary_double_ls_br,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_operator_binary_slash,
   c_operator_binary_percent,
   c_operator_unary_post_double_plus,
   c_operator_unary_post_double_minus,
   c_operator_unary_pre_double_plus,
   c_operator_unary_pre_double_minus,
   c_operator_unary_pre_plus,
   c_operator_unary_pre_minus,
   c_operator_unary_pre_exclamation,
   c_operator_unary_pre_tilde,
   c_function_print_0,
   c_function_type_0,
   c_function_to_string_0,
};

/*
 * build in structure short_s
 */

// - method count -
const unsigned c_bis_short_s_method_cnt = 40;
const unsigned c_bis_short_s_method_base = c_bis_char_s_method_base + c_bis_char_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_short_s_method_n_idxs[c_bis_short_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_plus_equal,
   c_operator_binary_minus_equal,
   c_operator_binary_asterisk_equal,
   c_operator_binary_slash_equal,
   c_operator_binary_percent_equal,
   c_operator_binary_double_ls_br_equal,
   c_operator_binary_double_rs_br_equal,
   c_operator_binary_ampersand_equal,
   c_operator_binary_pipe_equal,
   c_operator_binary_circumflex_equal,
   c_operator_binary_double_ampersand,
   c_operator_binary_double_pipe,
   c_operator_binary_ampersand,
   c_operator_binary_pipe,
   c_operator_binary_circumflex,
   c_operator_binary_double_equal,
   c_operator_binary_exclamation_equal,
   c_operator_binary_rs_br,
   c_operator_binary_ls_br,
   c_operator_binary_rs_br_equal,
   c_operator_binary_ls_br_equal,
   c_operator_binary_double_rs_br,
   c_operator_binary_double_ls_br,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_operator_binary_slash,
   c_operator_binary_percent,
   c_operator_unary_post_double_plus,
   c_operator_unary_post_double_minus,
   c_operator_unary_pre_double_plus,
   c_operator_unary_pre_double_minus,
   c_operator_unary_pre_plus,
   c_operator_unary_pre_minus,
   c_operator_unary_pre_exclamation,
   c_operator_unary_pre_tilde,
   c_function_print_0,
   c_function_type_0,
   c_function_to_string_0,
};

/*
 * build in structure int_s
 */

// - method count -
const unsigned c_bis_int_s_method_cnt = 40;
const unsigned c_bis_int_s_method_base = c_bis_short_s_method_base + c_bis_short_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_int_s_method_n_idxs[c_bis_int_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_plus_equal,
   c_operator_binary_minus_equal,
   c_operator_binary_asterisk_equal,
   c_operator_binary_slash_equal,
   c_operator_binary_percent_equal,
   c_operator_binary_double_ls_br_equal,
   c_operator_binary_double_rs_br_equal,
   c_operator_binary_ampersand_equal,
   c_operator_binary_pipe_equal,
   c_operator_binary_circumflex_equal,
   c_operator_binary_double_ampersand,
   c_operator_binary_double_pipe,
   c_operator_binary_ampersand,
   c_operator_binary_pipe,
   c_operator_binary_circumflex,
   c_operator_binary_double_equal,
   c_operator_binary_exclamation_equal,
   c_operator_binary_rs_br,
   c_operator_binary_ls_br,
   c_operator_binary_rs_br_equal,
   c_operator_binary_ls_br_equal,
   c_operator_binary_double_rs_br,
   c_operator_binary_double_ls_br,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_operator_binary_slash,
   c_operator_binary_percent,
   c_operator_unary_post_double_plus,
   c_operator_unary_post_double_minus,
   c_operator_unary_pre_double_plus,
   c_operator_unary_pre_double_minus,
   c_operator_unary_pre_plus,
   c_operator_unary_pre_minus,
   c_operator_unary_pre_exclamation,
   c_operator_unary_pre_tilde,
   c_function_print_0,
   c_function_type_0,
   c_function_to_string_0,
};

/*
 * build in structure double_s
 */

// - method count -
const unsigned c_bis_double_s_method_cnt = 26;
const unsigned c_bis_double_s_method_base = c_bis_int_s_method_base + c_bis_int_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_double_s_method_n_idxs[c_bis_double_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_plus_equal,
   c_operator_binary_minus_equal,
   c_operator_binary_asterisk_equal,
   c_operator_binary_slash_equal,
   c_operator_binary_double_ampersand,
   c_operator_binary_double_pipe,
   c_operator_binary_double_equal,
   c_operator_binary_exclamation_equal,
   c_operator_binary_rs_br,
   c_operator_binary_ls_br,
   c_operator_binary_rs_br_equal,
   c_operator_binary_ls_br_equal,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_operator_binary_slash,
   c_operator_unary_post_double_plus,
   c_operator_unary_post_double_minus,
   c_operator_unary_pre_double_plus,
   c_operator_unary_pre_double_minus,
   c_operator_unary_pre_plus,
   c_operator_unary_pre_minus,
   c_function_print_0,
   c_function_type_0,
   c_function_to_string_0,
};

/*
 * build in structure color_s
 */

// - method count -
const unsigned c_bis_color_s_method_cnt = 9;
const unsigned c_bis_color_s_method_base = c_bis_double_s_method_base + c_bis_double_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_color_s_method_n_idxs[c_bis_color_s_method_cnt] = {
   c_operator_binary_equal,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_operator_binary_slash,
   c_operator_binary_le_br_re_br,
   c_function_print_0,
   c_function_type_0,
   c_function_to_string_0,
};

/*
 * build in structure thread_s
 */

// - mrthod count -
const unsigned c_bis_thread_s_method_cnt = 5;
const unsigned c_bis_thread_s_method_base = c_bis_color_s_method_base + c_bis_color_s_method_cnt;

// - method names indexes -
const unsigned c_bis_thread_s_method_n_idxs[c_bis_thread_s_method_cnt] = {
   c_operator_binary_equal,
   c_function_join_0,
   c_function_detach_0,
   c_function_print_0,
   c_function_type_0,
};

/*
 * build in structure string_s
 */

// - method count -
const unsigned c_bis_string_s_method_cnt = 13;
const unsigned c_bis_string_s_method_base = c_bis_thread_s_method_base + c_bis_thread_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_string_s_method_n_idxs[c_bis_string_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_ampersand,
   c_operator_binary_double_equal,
   c_operator_binary_exclamation_equal,
   c_operator_binary_plus,
   c_operator_binary_asterisk,
   c_operator_binary_le_br_re_br,
   c_function_print_0,
   c_function_length_0,
   c_function_type_0,
   c_function_get_idx_1,
   c_function_to_string_0,
   c_function_split_1,
};

/*
 * build in structure local_img_s
 */

// - method count -
const unsigned c_bis_local_img_s_method_cnt = 18;
const unsigned c_bis_local_img_s_method_base = c_bis_string_s_method_base + c_bis_string_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_local_img_s_method_n_idxs[c_bis_local_img_s_method_cnt] = {
   c_operator_binary_equal,
   c_operator_binary_plus,
   c_operator_binary_minus,
   c_operator_binary_asterisk,
   c_function_print_0,
   c_function_width_0,
   c_function_height_0,
   c_function_type_0,
   c_function_to_string_0,
   c_function_load_bmp_file_1,
   c_function_save_bmp_file_1,
   c_function_invert_0,
   c_function_gray_scale_0,
   c_function_edge_sobel_0,
   c_function_blur_0,
   c_function_sharp_0,
   c_function_treshold_1,
   c_function_fill_1,
};

/*
 * build in structure char_array_s
 */

// - method count -
const unsigned c_bis_char_array_s_method_cnt = 9;
const unsigned c_bis_char_array_s_method_base = c_bis_local_img_s_method_base + c_bis_local_img_s_method_cnt;

// - method name indexes -
const unsigned c_bis_char_array_s_method_n_idxs[c_bis_char_array_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_le_br_re_br,
   c_function_print_0,
   c_function_length_0,
   c_function_type_0,
   c_function_push_1,
   c_function_pop_0,
   c_function_get_idx_1,
   c_function_to_string_0,
};

/*
 * build in structure int_array_s
 */

// - method count -
const unsigned c_bis_int_array_s_method_cnt = 9;
const unsigned c_bis_int_array_s_method_base = c_bis_char_array_s_method_base + c_bis_char_array_s_method_cnt;

// - method names indexes -
const unsigned c_bis_int_array_s_method_n_idxs[c_bis_int_array_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_le_br_re_br,
   c_function_print_0,
   c_function_length_0,
   c_function_type_0,
   c_function_push_1,
   c_function_pop_0,
   c_function_get_idx_1,
   c_function_to_string_0,
};

/*
 * build in structure double_array_s
 */

// - method count -
const unsigned c_bis_double_array_s_method_cnt = 9;
const unsigned c_bis_double_array_s_method_base = c_bis_int_array_s_method_base + c_bis_int_array_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_double_array_s_method_n_idxs[c_bis_double_array_s_method_cnt] = {
   c_operator_binary_equal,		  
   c_operator_binary_le_br_re_br,
   c_function_print_0,
   c_function_length_0,
   c_function_type_0,
   c_function_push_1,
   c_function_pop_0,
   c_function_get_idx_1,
   c_function_to_string_0,
};

/*
 * build in structure obj_array_s
 */

// - method count -
const unsigned c_bis_obj_array_s_method_cnt = 9;
const unsigned c_bis_obj_array_s_method_base = c_bis_double_array_s_method_base + c_bis_double_array_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_obj_array_s_method_n_idxs[c_bis_obj_array_s_method_cnt] = {
   c_operator_binary_equal,
   c_operator_binary_le_br_re_br,
   c_function_print_0,
   c_function_length_0,
   c_function_type_0,
   c_function_push_1,
   c_function_pop_0,
   c_function_get_idx_1,
   c_function_to_string_0,
};

/*
 * build in structure mutex_s
 */

// - method count -
const unsigned c_bis_mutex_s_method_cnt = 6;
const unsigned c_bis_mutex_s_method_base = c_bis_obj_array_s_method_base + c_bis_obj_array_s_method_cnt;

// - indexes of method names -
const unsigned c_bis_mutex_s_method_n_idxs[c_bis_mutex_s_method_cnt] = {
   c_operator_binary_equal,
   c_function_lock_0,
   c_function_trylock_0,
   c_function_unlock_0,
   c_function_print_0,
   c_function_type_0,
};

/*
 * build in structure condition_s
 */

// - method count -
const unsigned c_bis_condition_s_method_cnt = 9;
const unsigned c_bis_condition_s_method_base = c_bis_mutex_s_method_base + c_bis_mutex_s_method_cnt;

// - method names indexes -
const unsigned c_bis_condition_s_method_n_idxs[c_bis_condition_s_method_cnt] = {
   c_operator_binary_equal,
   c_function_wait_0,
   c_function_wait_1,
   c_function_timed_wait_1,
   c_function_signal_0,
   c_function_signal_1,
   c_function_broadcast_0,
   c_function_print_0,
   c_function_type_0,
};

/*
 * declarations of build in functions
 */

void bic_global_die_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_global_sys_enable_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_global_sys_disable_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_global_thread_self_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_global_print_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_global_color_3(unsigned a_thread_idx,script_parser_s &_this);

void bic_blank_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_blank_function_type_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_char_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_percent_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_ampersand_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_pipe_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_circumflex_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_circumflex(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_double_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_binary_percent(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_pre_exclamation(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_operator_unary_pre_tilde(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_short_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_percent_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_ampersand_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_pipe_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_circumflex_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_circumflex(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_double_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_binary_percent(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_pre_exclamation(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_operator_unary_pre_tilde(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_short_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_int_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_percent_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_ampersand_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_pipe_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_circumflex_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_circumflex(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_double_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_binary_percent(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_pre_exclamation(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_operator_unary_pre_tilde(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_double_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_color_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_thisv);
void bic_color_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_thisv);
void bic_color_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_thisv);
void bic_color_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_thisv);
void bic_color_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this);
void bic_color_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_color_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_color_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_color_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_thread_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_thread_function_join_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_thread_function_detach_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_thread_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_thread_function_type_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_string_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_function_length_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_string_function_split_1(unsigned a_thread_idx,script_parser_s &_this);

void bic_local_img_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_width_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_height_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_load_bmp_file_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_save_bmp_file_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_invert_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_gray_scale_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_edge_sobel_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_blur_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_sharp_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_treshold_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_local_img_function_fill_1(unsigned a_thread_idx,script_parser_s &_this);

void bic_char_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_char_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_int_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_int_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_double_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_double_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_obj_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_obj_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_mutex_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_mutex_function_lock_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_mutex_function_trylock_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_mutex_function_unlock_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_mutex_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_mutex_function_type_0(unsigned a_thread_idx,script_parser_s &_this);

void bic_condition_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_wait_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_wait_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_timed_wait_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_signal_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_signal_1(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_broadcast_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_print_0(unsigned a_thread_idx,script_parser_s &_this);
void bic_condition_function_type_0(unsigned a_thread_idx,script_parser_s &_this);

/*
 * access to build in function callers
 */

extern void(*script_bic_callers[])(unsigned a_thread_idx,script_parser_s &_this);
extern const char *c_build_in_symbol_names[];

#endif

