
#include "p.script_parser.h"

/*
 * definitions and constants
 */

const unsigned c_int_max_str_length = 256;
const unsigned c_double_max_str_length = 256;
const unsigned c_color_max_length = 256;

/*
 * array of build in function callers
 */

const unsigned c_bic_function_cnt = 
   c_bi_global_method_cnt 
   + c_bis_blank_s_method_cnt 
   + c_bis_char_s_method_cnt 
   + c_bis_short_s_method_cnt 
   + c_bis_int_s_method_cnt 
   + c_bis_double_s_method_cnt 
   + c_bis_color_s_method_cnt 
   + c_bis_thread_s_method_cnt 
   + c_bis_string_s_method_cnt 
   + c_bis_local_img_s_method_cnt 
   + c_bis_char_array_s_method_cnt 
   + c_bis_int_array_s_method_cnt 
   + c_bis_double_array_s_method_cnt 
   + c_bis_obj_array_s_method_cnt
   + c_bis_mutex_s_method_cnt
   + c_bis_condition_s_method_cnt;

void(*script_bic_callers[c_bic_function_cnt])(unsigned a_thread_idx,script_parser_s &_this) = {
   bic_global_die_1,
   bic_global_sys_enable_1,
   bic_global_sys_disable_1,
   bic_global_thread_self_0,
   bic_global_print_1,
   bic_global_color_3,

   bic_blank_operator_binary_equal,
   bic_blank_function_type_0,

   bic_char_operator_binary_equal,
   bic_char_operator_binary_plus_equal,
   bic_char_operator_binary_minus_equal,
   bic_char_operator_binary_asterisk_equal,
   bic_char_operator_binary_slash_equal,
   bic_char_operator_binary_percent_equal,
   bic_char_operator_binary_double_ls_br_equal,
   bic_char_operator_binary_double_rs_br_equal,
   bic_char_operator_binary_ampersand_equal,
   bic_char_operator_binary_pipe_equal,
   bic_char_operator_binary_circumflex_equal,
   bic_char_operator_binary_double_ampersand,
   bic_char_operator_binary_double_pipe,
   bic_char_operator_binary_ampersand,
   bic_char_operator_binary_pipe,
   bic_char_operator_binary_circumflex,
   bic_char_operator_binary_double_equal,
   bic_char_operator_binary_exclamation_equal,
   bic_char_operator_binary_rs_br,
   bic_char_operator_binary_ls_br,
   bic_char_operator_binary_rs_br_equal,
   bic_char_operator_binary_ls_br_equal,
   bic_char_operator_binary_double_rs_br,
   bic_char_operator_binary_double_ls_br,
   bic_char_operator_binary_plus,
   bic_char_operator_binary_minus,
   bic_char_operator_binary_asterisk,
   bic_char_operator_binary_slash,
   bic_char_operator_binary_percent,
   bic_char_operator_unary_post_double_plus,
   bic_char_operator_unary_post_double_minus,
   bic_char_operator_unary_pre_double_plus,
   bic_char_operator_unary_pre_double_minus,
   bic_char_operator_unary_pre_plus,
   bic_char_operator_unary_pre_minus,
   bic_char_operator_unary_pre_exclamation,
   bic_char_operator_unary_pre_tilde,
   bic_char_function_print_0,
   bic_char_function_type_0,
   bic_char_function_to_string_0,

   bic_short_operator_binary_equal,
   bic_short_operator_binary_plus_equal,
   bic_short_operator_binary_minus_equal,
   bic_short_operator_binary_asterisk_equal,
   bic_short_operator_binary_slash_equal,
   bic_short_operator_binary_percent_equal,
   bic_short_operator_binary_double_ls_br_equal,
   bic_short_operator_binary_double_rs_br_equal,
   bic_short_operator_binary_ampersand_equal,
   bic_short_operator_binary_pipe_equal,
   bic_short_operator_binary_circumflex_equal,
   bic_short_operator_binary_double_ampersand,
   bic_short_operator_binary_double_pipe,
   bic_short_operator_binary_ampersand,
   bic_short_operator_binary_pipe,
   bic_short_operator_binary_circumflex,
   bic_short_operator_binary_double_equal,
   bic_short_operator_binary_exclamation_equal,
   bic_short_operator_binary_rs_br,
   bic_short_operator_binary_ls_br,
   bic_short_operator_binary_rs_br_equal,
   bic_short_operator_binary_ls_br_equal,
   bic_short_operator_binary_double_rs_br,
   bic_short_operator_binary_double_ls_br,
   bic_short_operator_binary_plus,
   bic_short_operator_binary_minus,
   bic_short_operator_binary_asterisk,
   bic_short_operator_binary_slash,
   bic_short_operator_binary_percent,
   bic_short_operator_unary_post_double_plus,
   bic_short_operator_unary_post_double_minus,
   bic_short_operator_unary_pre_double_plus,
   bic_short_operator_unary_pre_double_minus,
   bic_short_operator_unary_pre_plus,
   bic_short_operator_unary_pre_minus,
   bic_short_operator_unary_pre_exclamation,
   bic_short_operator_unary_pre_tilde,
   bic_short_function_print_0,
   bic_short_function_type_0,
   bic_short_function_to_string_0,

   bic_int_operator_binary_equal,
   bic_int_operator_binary_plus_equal,
   bic_int_operator_binary_minus_equal,
   bic_int_operator_binary_asterisk_equal,
   bic_int_operator_binary_slash_equal,
   bic_int_operator_binary_percent_equal,
   bic_int_operator_binary_double_ls_br_equal,
   bic_int_operator_binary_double_rs_br_equal,
   bic_int_operator_binary_ampersand_equal,
   bic_int_operator_binary_pipe_equal,
   bic_int_operator_binary_circumflex_equal,
   bic_int_operator_binary_double_ampersand,
   bic_int_operator_binary_double_pipe,
   bic_int_operator_binary_ampersand,
   bic_int_operator_binary_pipe,
   bic_int_operator_binary_circumflex,
   bic_int_operator_binary_double_equal,
   bic_int_operator_binary_exclamation_equal,
   bic_int_operator_binary_rs_br,
   bic_int_operator_binary_ls_br,
   bic_int_operator_binary_rs_br_equal,
   bic_int_operator_binary_ls_br_equal,
   bic_int_operator_binary_double_rs_br,
   bic_int_operator_binary_double_ls_br,
   bic_int_operator_binary_plus,
   bic_int_operator_binary_minus,
   bic_int_operator_binary_asterisk,
   bic_int_operator_binary_slash,
   bic_int_operator_binary_percent,
   bic_int_operator_unary_post_double_plus,
   bic_int_operator_unary_post_double_minus,
   bic_int_operator_unary_pre_double_plus,
   bic_int_operator_unary_pre_double_minus,
   bic_int_operator_unary_pre_plus,
   bic_int_operator_unary_pre_minus,
   bic_int_operator_unary_pre_exclamation,
   bic_int_operator_unary_pre_tilde,
   bic_int_function_print_0,
   bic_int_function_type_0,
   bic_int_function_to_string_0,

   bic_double_operator_binary_equal,
   bic_double_operator_binary_plus_equal,
   bic_double_operator_binary_minus_equal,
   bic_double_operator_binary_asterisk_equal,
   bic_double_operator_binary_slash_equal,
   bic_double_operator_binary_double_ampersand,
   bic_double_operator_binary_double_pipe,
   bic_double_operator_binary_double_equal,
   bic_double_operator_binary_exclamation_equal,
   bic_double_operator_binary_rs_br,
   bic_double_operator_binary_ls_br,
   bic_double_operator_binary_rs_br_equal,
   bic_double_operator_binary_ls_br_equal,
   bic_double_operator_binary_plus,
   bic_double_operator_binary_minus,
   bic_double_operator_binary_asterisk,
   bic_double_operator_binary_slash,
   bic_double_operator_unary_post_double_plus,
   bic_double_operator_unary_post_double_minus,
   bic_double_operator_unary_pre_double_plus,
   bic_double_operator_unary_pre_double_minus,
   bic_double_operator_unary_pre_plus,
   bic_double_operator_unary_pre_minus,
   bic_double_function_print_0,
   bic_double_function_type_0,
   bic_double_function_to_string_0,

   bic_color_operator_binary_equal,
   bic_color_operator_binary_plus,
   bic_color_operator_binary_minus,
   bic_color_operator_binary_asterisk,
   bic_color_operator_binary_slash,
   bic_color_operator_binary_le_br_re_br,
   bic_color_function_print_0,
   bic_color_function_type_0,
   bic_color_function_to_string_0,

   bic_thread_operator_binary_equal,
   bic_thread_function_join_0,
   bic_thread_function_detach_0,
   bic_thread_function_print_0,
   bic_thread_function_type_0,

   bic_string_operator_binary_equal,
   bic_string_operator_binary_ampersand,
   bic_string_operator_binary_double_equal,
   bic_string_operator_binary_exclamation_equal,
   bic_string_operator_binary_plus,
   bic_string_operator_binary_asterisk,
   bic_string_operator_binary_le_br_re_br,
   bic_string_function_print_0,
   bic_string_function_length_0,
   bic_string_function_type_0,
   bic_string_function_get_idx_1,
   bic_string_function_to_string_0,
   bic_string_function_split_1,

   bic_local_img_operator_binary_equal,
   bic_local_img_operator_binary_plus,
   bic_local_img_operator_binary_minus,
   bic_local_img_operator_binary_asterisk,
   bic_local_img_function_print_0,
   bic_local_img_function_width_0,
   bic_local_img_function_height_0,
   bic_local_img_function_type_0,
   bic_local_img_function_to_string_0,
   bic_local_img_function_load_bmp_file_1,
   bic_local_img_function_save_bmp_file_1,
   bic_local_img_function_invert_0,
   bic_local_img_function_gray_scale_0,
   bic_local_img_function_edge_sobel_0,
   bic_local_img_function_blur_0,
   bic_local_img_function_sharp_0,
   bic_local_img_function_treshold_1,
   bic_local_img_function_fill_1,

   bic_char_array_operator_binary_equal,
   bic_char_array_operator_binary_le_br_re_br,
   bic_char_array_function_print_0,
   bic_char_array_function_length_0,
   bic_char_array_function_type_0,
   bic_char_array_function_push_1,
   bic_char_array_function_pop_0,
   bic_char_array_function_get_idx_1,
   bic_char_array_function_to_string_0,

   bic_int_array_operator_binary_equal,
   bic_int_array_operator_binary_le_br_re_br,
   bic_int_array_function_print_0,
   bic_int_array_function_length_0,
   bic_int_array_function_type_0,
   bic_int_array_function_push_1,
   bic_int_array_function_pop_0,
   bic_int_array_function_get_idx_1,
   bic_int_array_function_to_string_0,

   bic_double_array_operator_binary_equal,
   bic_double_array_operator_binary_le_br_re_br,
   bic_double_array_function_print_0,
   bic_double_array_function_length_0,
   bic_double_array_function_type_0,
   bic_double_array_function_push_1,
   bic_double_array_function_pop_0,
   bic_double_array_function_get_idx_1,
   bic_double_array_function_to_string_0,

   bic_obj_array_operator_binary_equal,
   bic_obj_array_operator_binary_le_br_re_br,
   bic_obj_array_function_print_0,
   bic_obj_array_function_length_0,
   bic_obj_array_function_type_0,
   bic_obj_array_function_push_1,
   bic_obj_array_function_pop_0,
   bic_obj_array_function_get_idx_1,
   bic_obj_array_function_to_string_0,

   bic_mutex_operator_binary_equal,
   bic_mutex_function_lock_0,
   bic_mutex_function_trylock_0,
   bic_mutex_function_unlock_0,
   bic_mutex_function_print_0,
   bic_mutex_function_type_0,

   bic_condition_operator_binary_equal,
   bic_condition_function_wait_0,
   bic_condition_function_wait_1,
   bic_condition_function_timed_wait_1,
   bic_condition_function_signal_0,
   bic_condition_function_signal_1,
   bic_condition_function_broadcast_0,
   bic_condition_function_print_0,
   bic_condition_function_type_0,
};

// - names of build in symbols -
const char *c_build_in_symbol_names[c_bi_all_cnt] = {

   // - structures -
   "blank_s",
   "char_s",
   "short_s",
   "int_s",
   "double_s",
   "color_s",
   "thread_s",
   "string_s",
   "local_img_s",
   "char_array_s",
   "int_array_s",
   "double_array_s",
   "obj_array_s",
   "mutex_s",
   "condition_s",

   // - operators -
   "operator_binary_equal#1",
   "operator_binary_plus_equal#1",
   "operator_binary_minus_equal#1",
   "operator_binary_asterisk_equal#1",
   "operator_binary_slash_equal#1",
   "operator_binary_percent_equal#1",
   "operator_binary_double_ls_br_equal#1",
   "operator_binary_double_rs_br_equal#1",
   "operator_binary_ampersand_equal#1",
   "operator_binary_pipe_equal#1",
   "operator_binary_circumflex_equal#1",
   "operator_binary_double_ampersand#1",
   "operator_binary_double_pipe#1",
   "operator_binary_ampersand#1",
   "operator_binary_pipe#1",
   "operator_binary_circumflex#1",
   "operator_binary_double_equal#1",
   "operator_binary_exclamation_equal#1",
   "operator_binary_rs_br#1",
   "operator_binary_ls_br#1",
   "operator_binary_rs_br_equal#1",
   "operator_binary_ls_br_equal#1",
   "operator_binary_double_rs_br#1",
   "operator_binary_double_ls_br#1",
   "operator_binary_plus#1",
   "operator_binary_minus#1",
   "operator_binary_asterisk#1",
   "operator_binary_slash#1",
   "operator_binary_percent#1",
   "operator_unary_post_double_plus#0",
   "operator_unary_post_double_minus#0",
   "operator_unary_pre_double_plus#0",
   "operator_unary_pre_double_minus#0",
   "operator_unary_pre_plus#0",
   "operator_unary_pre_minus#0",
   "operator_unary_pre_exclamation#0",
   "operator_unary_pre_tilde#0",
   "operator_binary_le_br_re_br#1",

   // - functions -
   "die#1",
   "sys_enable#1",
   "sys_disable#1",
   "thread_self#0",
   "print#1",
   "color#3",
   "join#0",
   "detach#0",

   "lock#0",
   "trylock#0",
   "unlock#0",

   "wait#0",
   "wait#1",
   "timed_wait#1",
   "signal#0",
   "signal#1",
   "broadcast#0",

   "print#0",
   "length#0",
   "width#0",
   "height#0",
   "type#0",
   "push#1",
   "pop#0",
   "get_idx#1",
   "to_string#0",
   "split#1",
   "join#1",
   "load_bmp_file#1",
   "save_bmp_file#1",
   "invert#0",
   "gray_scale#0",
   "edge_sobel#0",
   "blur#0",
   "sharp#0",
   "treshold#1",
   "fill#1",
};

/*
 * functions describing build in functions of interpret
 */

/*
 * global build in functions
 */

void bic_global_die_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];
   err_test4(location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAM_EXPECTED_PARAM,_this.get_line_number(a_thread_idx),(unsigned)"global_sys_die_1",(unsigned)"string_s",(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[location.ui_first].p_symbol_idx].ui_first].data);

   string_s *string_ptr = IM_ACCESS_STRING_PTR(location.ulli_second);
   printf("%s, on line %u.\n",string_ptr->data,_this.get_line_number(a_thread_idx));

   mc_clear(true);
   exit(0);
}

void bic_global_sys_enable_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned location_idx = exp_stack.pop();
   value_location_s &location = value_location_pool[location_idx];
   err_test4(location.ui_first == c_value_type_INT,c_R_ERR_WRONG_PARAM_EXPECTED_PARAM,_this.get_line_number(a_thread_idx),(unsigned)"global_sys_enable_1",(unsigned)"int_s",(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[location.ui_first].p_symbol_idx].ui_first].data);

   int int_value = value_location_pool.get_int_value(location);
   int result = -1;

   switch (int_value) {
   case c_sc_SYSTEM_THREADS:
      {
	 if (!_this.multiple_threads) {
	    assert(a_thread_idx == 0);

	    _this.mutex.lock();
	    _this.multiple_threads = true;
	 }

	 result = 0;
      }
      break;
   default:
      err_test3(0,c_R_ERR_UNKNOWN_X_OPERATION_CONSTANT,_this.get_line_number(a_thread_idx),int_value,(unsigned)"global_sys_enable_1");
   }

   if (location.uc_third & c_value_modifier_TMP) {
      IM_ACCESS_INT_TRG(location.ulli_second) = result;
      exp_stack.push(location_idx);
   }
   else {
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }
}

void bic_global_sys_disable_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned location_idx = exp_stack.pop();
   value_location_s &location = value_location_pool[location_idx];
   err_test4(location.ui_first == c_value_type_INT,c_R_ERR_WRONG_PARAM_EXPECTED_PARAM,_this.get_line_number(a_thread_idx),(unsigned)"global_sys_disable_1",(unsigned)"int_s",(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[location.ui_first].p_symbol_idx].ui_first].data);

   int int_value = value_location_pool.get_int_value(location);
   int result = -1;

   switch (int_value) {
   case c_sc_SYSTEM_THREADS:
      {
	 if (_this.multiple_threads) {
	    assert(a_thread_idx == 0 && _this.sp_thread_pool.used == 1);

	    _this.mutex.unlock();
	    _this.multiple_threads = false;
	 }

	 result = 0;
      }
      break;
   default:
      err_test3(0,c_R_ERR_UNKNOWN_X_OPERATION_CONSTANT,_this.get_line_number(a_thread_idx),int_value,(unsigned)"global_sys_disable_1");
   }

   if (location.uc_third & c_value_modifier_TMP) {
      IM_ACCESS_INT_TRG(location.ulli_second) = result;
      exp_stack.push(location_idx);
   }
   else {
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }
}

void bic_global_thread_self_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   unsigned result_location_idx = value_location_pool.insert(c_value_type_THREAD,(unsigned long long)a_thread_idx,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_global_print_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   value_location_pool.print_value(location);
}

void bic_global_color_3(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &blue_location = value_location_pool[exp_stack.pop()];
   value_location_s &green_location = value_location_pool[exp_stack.pop()];
   value_location_s &red_location = value_location_pool[exp_stack.pop()];

   unsigned long long color_value = 0;
   short *color_ptr = (short *)&color_value;

   // - red color -
   switch (red_location.ui_first) {
   case c_value_type_CHAR:
      color_ptr[0] = (short)value_location_pool.get_char_value(red_location);
      break;
   case c_value_type_SHORT:
      color_ptr[0] = value_location_pool.get_short_value(red_location);
      break;
   case c_value_type_INT:
      color_ptr[0] = (short)value_location_pool.get_int_value(red_location);
      break;
   case c_value_type_DOUBLE:
      color_ptr[0] = (short)value_location_pool.get_double_value(red_location);
      break;
   default:
      err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"color_definition, at position 0,");
   }

   // - green color -
   switch (green_location.ui_first) {
   case c_value_type_CHAR:
      color_ptr[1] = (short)value_location_pool.get_char_value(green_location);
      break;
   case c_value_type_SHORT:
      color_ptr[1] = value_location_pool.get_short_value(green_location);
      break;
   case c_value_type_INT:
      color_ptr[1] = (short)value_location_pool.get_int_value(green_location);
      break;
   case c_value_type_DOUBLE:
      color_ptr[1] = (short)value_location_pool.get_double_value(green_location);
      break;
   default:
      err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"color_definition, at position 1,");
   }

   // - blue color -
   switch (blue_location.ui_first) {
   case c_value_type_CHAR:
      color_ptr[2] = (short)value_location_pool.get_char_value(blue_location);
      break;
   case c_value_type_SHORT:
      color_ptr[2] = value_location_pool.get_short_value(blue_location);
      break;
   case c_value_type_INT:
      color_ptr[2] = (short)value_location_pool.get_int_value(blue_location);
      break;
   case c_value_type_DOUBLE:
      color_ptr[2] = (short)value_location_pool.get_double_value(blue_location);
      break;
   default:
      err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"color_definition, at position 2,");
   }

   unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,color_value,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

/*
 * functions of structure blank_s
 */

void bic_blank_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   // - creation of new variable -
   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"blank_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"blank_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"blank_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_blank_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_BLANK,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

/*
 * definition of repetitive codes of individual operations
 */

#define BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME)\
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"char_s::"OPERATOR_NAME);\
\
   char *char_dst_ptr = value_location_pool.get_char_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*char_dst_ptr) OPERATOR ## = value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*char_dst_ptr) OPERATOR ## = value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*char_dst_ptr) OPERATOR ## = value_location_pool.get_int_value(src_location);\
	 break;\
      case c_value_type_DOUBLE:\
	 (*char_dst_ptr) = (char)((*char_dst_ptr) OPERATOR value_location_pool.get_double_value(src_location));\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"char_s::"OPERATOR_NAME);\
\
   char *char_dst_ptr = value_location_pool.get_char_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*char_dst_ptr) OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*char_dst_ptr) OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*char_dst_ptr) OPERATOR value_location_pool.get_int_value(src_location);\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   int result = 0;\
   bool done = false;\
\
   char char_dst_value = value_location_pool.get_char_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 result = char_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 result = char_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 {\
	    result = char_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
   \
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	       done = true;\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 result = char_dst_value OPERATOR value_location_pool.get_double_value(src_location);\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
\
   if (!done) {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

#define BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   char char_dst_value = value_location_pool.get_char_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 {\
	    char result = char_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_CHAR_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       if (dst_location.uc_third & c_value_modifier_TMP) {\
		  IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = result;\
		  exp_stack.push(dst_location_idx);\
	       }\
	       else {\
		  unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)result,c_value_modifier_TMP);\
		  tmp_variables_array.last().push(result_location_idx);\
		  exp_stack.push(result_location_idx);\
	       }\
	    }\
	 }\
	 break;\
      case c_value_type_SHORT:\
	 {\
	    short result = char_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_SHORT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_INT:\
	 {\
	    int result = char_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 {\
	    double result = char_dst_value OPERATOR value_location_pool.get_double_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_DOUBLE_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*((unsigned long long *)&result),c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   char char_dst_value = value_location_pool.get_char_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 {\
	    char result = char_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_CHAR_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       if (dst_location.uc_third & c_value_modifier_TMP) {\
		  IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = result;\
		  exp_stack.push(dst_location_idx);\
	       }\
	       else {\
		  unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)result,c_value_modifier_TMP);\
		  tmp_variables_array.last().push(result_location_idx);\
		  exp_stack.push(result_location_idx);\
	       }\
	    }\
	 }\
	 break;\
      case c_value_type_SHORT:\
	 {\
	    short result = char_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_SHORT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_INT:\
	 {\
	    int result = char_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_CHAR_UNARY_WRITABLE_POST_TMP_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.pop()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"char_s::"OPERATOR_NAME);\
\
   char *char_ptr = value_location_pool.get_char_ptr(location);\
\
   char result = (*char_ptr) OPERATOR ;\
\
   unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)result,c_value_modifier_TMP);\
   tmp_variables_array.last().push(result_location_idx);\
   exp_stack.push(result_location_idx);\
}

#define BIC_CHAR_UNARY_WRITABLE_PRE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.last()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"char_s::"OPERATOR_NAME);\
\
   char *char_ptr = value_location_pool.get_char_ptr(location);\
\
   (*char_ptr) OPERATOR ;\
}

#define BIC_CHAR_UNARY_PRE_TMP_RESULT(OPERATOR) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned location_idx = exp_stack.pop();\
   value_location_s &location = value_location_pool[location_idx];\
\
   char char_value = value_location_pool.get_char_value(location);\
\
   char result = OPERATOR char_value;\
\
   if (location.uc_third & c_value_modifier_TMP) {\
      IM_ACCESS_CHAR_TRG(location.ulli_second) = result;\
      exp_stack.push(location_idx);\
   }\
   else {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)result,c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

/*
 * function of structure char_s
 */

void bic_char_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"char_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    (*value_location_pool.get_char_ptr(dst_location)) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_char_ptr(dst_location)) = value_location_pool.get_short_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_SHORT;
	       IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    }
	    break;
	 case c_value_type_INT:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_char_ptr(dst_location)) = value_location_pool.get_int_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_INT;
	       IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    }
	    break;
	 case c_value_type_DOUBLE:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_char_ptr(dst_location)) = (char)value_location_pool.get_double_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_DOUBLE;
	       IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    }
	    break;
	 case c_value_type_COLOR:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"color_s",(unsigned)"char_s",(unsigned)"char_s::operator_binary_equal");

	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"thread_s",(unsigned)"char_s",(unsigned)"char_s::operator_binary_equal");

	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::operator_binary_equal");
	 }
      }
      else {
	 err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s",(unsigned)"char_s::operator_binary_equal");

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_s",(unsigned)"char_s::operator_binary_equal");

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_char_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus_equal");
}

void bic_char_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus_equal");
}

void bic_char_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_bionary_asterisk_equal");
}

void bic_char_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash_equal");
}

void bic_char_operator_binary_percent_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(%=,"operator_binary_percent_equal");
}

void bic_char_operator_binary_double_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   //BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(<<=,"operator_binary_double_ls_br_equal");
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"char_s::operator_binary_double_ls_br_equal");
}

void bic_char_operator_binary_double_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   //BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(>>=,"operator_binary_double_rs_br_equal");
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"char_s::operator_binary_double_rs_br_equal");
}

void bic_char_operator_binary_ampersand_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(&=,"operator_binary_ampersand_equal");
}

void bic_char_operator_binary_pipe_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(|=,"operator_binary_pipe_equal");
}

void bic_char_operator_binary_circumflex_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_EQUAL_OPS_CHAR_SHORT_INT(^=,"operator_binary_circumflex_equal");
}

void bic_char_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(&&,"operator_binary_double_ampersand");
}

void bic_char_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(||,"operator_binary_double_pipe");
}

void bic_char_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(&,"operator_binary_ampersand");
}

void bic_char_operator_binary_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(|,"operator_binary_pipe");
}

void bic_char_operator_binary_circumflex(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(^,"operator_binary_circumflex");
}

void bic_char_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(==,"operator_binary_double_equal");
}

void bic_char_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(!=,"operator_binary_exclamation_equal");
}

void bic_char_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>,"operator_binary_rs_br");
}

void bic_char_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<,"operator_binary_ls_br");
}

void bic_char_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>=,"operator_binary_rs_br_equal");
}

void bic_char_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<=,"operator_binary_ls_br_equal");
}

void bic_char_operator_binary_double_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   //BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(>>,"operator_binary_double_rs_br");
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"char_s::operator_binary_double_rs_br");
}

void bic_char_operator_binary_double_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   //BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(<<,"operator_binary_double_ls_br");
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"char_s::operator_binary_double_ls_br");
}

void bic_char_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus");
}

void bic_char_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus");
}

void bic_char_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk");
}

void bic_char_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash");
}

void bic_char_operator_binary_percent(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_BINARY_OPS_CHAR_SHORT_INT(%,"operator_binary_percent");
}

void bic_char_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_WRITABLE_POST_TMP_RESULT(++,"operator_unary_post_double_plus");
}

void bic_char_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_WRITABLE_POST_TMP_RESULT(--,"operator_unary_post_double_minus");
}

void bic_char_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_WRITABLE_PRE(++,"operator_unary_pre_double_plus");
}

void bic_char_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_WRITABLE_PRE(--,"operator_unary_pre_double_minus");
}

void bic_char_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_PRE_TMP_RESULT(+);
}

void bic_char_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_PRE_TMP_RESULT(-);
}

void bic_char_operator_unary_pre_exclamation(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_PRE_TMP_RESULT(!);
}

void bic_char_operator_unary_pre_tilde(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_CHAR_UNARY_PRE_TMP_RESULT(~);
}

void bic_char_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   putchar(value_location_pool.get_char_value(location));
}

void bic_char_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_CHAR,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_char_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.pop()];

   string_s *string_ptr = (string_s *)cmalloc(sizeof(string_s));
   string_ptr->init();
   string_ptr->create(1);
   string_ptr->data[0] = value_location_pool.get_char_value(location);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_STRING,IM_ACCESS_DATA_PTR(string_ptr),c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

/*
 * definition of repetitive codes of individual operations
 */

#define BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME)\
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"short_s::"OPERATOR_NAME);\
\
   short *short_dst_ptr = value_location_pool.get_short_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*short_dst_ptr) OPERATOR ## = value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*short_dst_ptr) OPERATOR ## = value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*short_dst_ptr) OPERATOR ## = value_location_pool.get_int_value(src_location);\
	 break;\
      case c_value_type_DOUBLE:\
	 (*short_dst_ptr) = (short)((*short_dst_ptr) OPERATOR value_location_pool.get_double_value(src_location));\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"short_s::"OPERATOR_NAME);\
\
   short *short_dst_ptr = value_location_pool.get_short_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*short_dst_ptr) OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*short_dst_ptr) OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*short_dst_ptr) OPERATOR value_location_pool.get_int_value(src_location);\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   int result = 0;\
   bool done = false;\
\
   short short_dst_value = value_location_pool.get_short_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 result = short_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 result = short_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 {\
	    result = short_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	       done = true;\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 result = (int)(short_dst_value OPERATOR value_location_pool.get_double_value(src_location));\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
\
   if (!done) {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

#define BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   short short_dst_value = value_location_pool.get_short_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 {\
	    short result = short_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
\
	    if (dst_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = result;\
	       exp_stack.push(dst_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_SHORT:\
	 {\
	    short result = short_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
\
	    if (dst_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = result;\
	       exp_stack.push(dst_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_INT:\
	 {\
	    int result = short_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 {\
	    double result = short_dst_value OPERATOR value_location_pool.get_double_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_DOUBLE_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*((unsigned long long *)&result),c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   short short_dst_value = value_location_pool.get_short_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 {\
	    short result = short_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
\
	    if (dst_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = result;\
	       exp_stack.push(dst_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_SHORT:\
	 {\
	    short result = short_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_SHORT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       if (dst_location.uc_third & c_value_modifier_TMP) {\
		  IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = result;\
		  exp_stack.push(dst_location_idx);\
	       }\
	       else {\
		  unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
		  tmp_variables_array.last().push(result_location_idx);\
		  exp_stack.push(result_location_idx);\
	       }\
	    }\
	 }\
	 break;\
      case c_value_type_INT:\
	 {\
	    int result = short_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_SHORT_UNARY_WRITABLE_POST_TMP_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.pop()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"short_s::"OPERATOR_NAME);\
\
   short *short_ptr = value_location_pool.get_short_ptr(location);\
\
   short result = (*short_ptr) OPERATOR ;\
\
   unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
   tmp_variables_array.last().push(result_location_idx);\
   exp_stack.push(result_location_idx);\
}

#define BIC_SHORT_UNARY_WRITABLE_PRE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.last()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"short_s::"OPERATOR_NAME);\
\
   short *short_ptr = value_location_pool.get_short_ptr(location);\
\
   (*short_ptr) OPERATOR ;\
}

#define BIC_SHORT_UNARY_PRE_TMP_RESULT(OPERATOR) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned location_idx = exp_stack.pop();\
   value_location_s &location = value_location_pool[location_idx];\
\
   short short_value = value_location_pool.get_short_value(location);\
\
   short result = OPERATOR short_value;\
\
   if (location.uc_third & c_value_modifier_TMP) {\
      IM_ACCESS_SHORT_TRG(location.ulli_second) = result;\
      exp_stack.push(location_idx);\
   }\
   else {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,(unsigned long long)result,c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

/*
 * functions of structure short_s
 */

void bic_short_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"short_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_short_ptr(dst_location)) = (short)value_location_pool.get_char_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_CHAR;
	       IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    }
	    break;
	 case c_value_type_SHORT:
	    (*value_location_pool.get_short_ptr(dst_location)) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_short_ptr(dst_location)) = (short)value_location_pool.get_int_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_INT;
	       IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    }
	    break;
	 case c_value_type_DOUBLE:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_short_ptr(dst_location)) = (short)value_location_pool.get_double_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_DOUBLE;
	       IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    }
	    break;
	 case c_value_type_COLOR:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"color_s",(unsigned)"short_s",(unsigned)"short_s::operator_binary_equal");
	    
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"thread_s",(unsigned)"short_s",(unsigned)"short_s::operator_binary_equal");
	    
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::operator_binary_equal");
	 }
      }
      else {
	 err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s",(unsigned)"short_s::operator_binary_equal");

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"short_s",(unsigned)"short_s::operator_binary_equal");

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_short_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus_equal");
}

void bic_short_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus_equal");
}

void bic_short_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk_equal");
}

void bic_short_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash_equal");
}

void bic_short_operator_binary_percent_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(%=,"operator_binary_percent_equal");
}

void bic_short_operator_binary_double_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(<<=,"operator_binary_double_ls_br_equal");
}

void bic_short_operator_binary_double_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(>>=,"operator_binary_double_rs_br_equal");
}

void bic_short_operator_binary_ampersand_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(&=,"operator_binary_ampersand_equal");
}

void bic_short_operator_binary_pipe_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(|=,"operator_binary_pipe_equal");
}

void bic_short_operator_binary_circumflex_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(^=,"operator_binary_circumflex_equal");
}

void bic_short_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(&&,"operator_binary_double_ampersand");
}

void bic_short_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(||,"operator_binary_double_pipe");
}

void bic_short_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(&,"operator_binary_ampersand");
}

void bic_short_operator_binary_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(|,"operator_binary_pipe");
}

void bic_short_operator_binary_circumflex(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(^,"operator_binary_circumflex");
}

void bic_short_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(==,"operator_binary_double_equal");
}

void bic_short_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(!=,"operator_binary_exclamation_equal");
}

void bic_short_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>,"operator_binary_rs_br");
}

void bic_short_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<,"operator_binary_ls_br");
}

void bic_short_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>=,"operator_binary_rs_br_equal");
}

void bic_short_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<=,"operator_binary_ls_br_equal");
}

void bic_short_operator_binary_double_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(>>,"operator_binary_double_rs_br");
}

void bic_short_operator_binary_double_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(<<,"operator_binary_double_ls_br");
}

void bic_short_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus");
}

void bic_short_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus");
}

void bic_short_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk");
}

void bic_short_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash");
}

void bic_short_operator_binary_percent(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_BINARY_OPS_CHAR_SHORT_INT(%,"operator_binary_percent");
}

void bic_short_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_WRITABLE_POST_TMP_RESULT(++,"operator_unary_post_double_plus");
}

void bic_short_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_WRITABLE_POST_TMP_RESULT(--,"operator_unary_post_double_minus");
}

void bic_short_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_WRITABLE_PRE(++,"operator_unary_pre_double_plus");
}

void bic_short_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_WRITABLE_PRE(--,"operator_unary_pre_double_minus");
}

void bic_short_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_PRE_TMP_RESULT(+);
}

void bic_short_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_PRE_TMP_RESULT(-);
}

void bic_short_operator_unary_pre_exclamation(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_PRE_TMP_RESULT(!);
}

void bic_short_operator_unary_pre_tilde(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_SHORT_UNARY_PRE_TMP_RESULT(~);
}

void bic_short_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   printf("%hd",value_location_pool.get_short_value(location));
}

void bic_short_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_SHORT,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_short_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.pop()];

   char res_str[c_int_max_str_length];
   unsigned res_str_length = snprintf(res_str,c_int_max_str_length,"%hd",value_location_pool.get_short_value(location));

   err_test2(res_str_length < c_int_max_str_length,c_DR_ERR_EXCEED_MAX_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"short_s");

   string_s *string_ptr = (string_s *)cmalloc(sizeof(string_s));
   string_ptr->init();
   string_ptr->set(res_str_length,res_str);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_STRING,IM_ACCESS_DATA_PTR(string_ptr),c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

/*
 * definition of repetitive codes of individual operations
 */

#define BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME)\
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"int_s::"OPERATOR_NAME);\
\
   int *int_dst_ptr = value_location_pool.get_int_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*int_dst_ptr) OPERATOR ## = value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*int_dst_ptr) OPERATOR ## = value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*int_dst_ptr) OPERATOR ## = value_location_pool.get_int_value(src_location);\
	 break;\
      case c_value_type_DOUBLE:\
	 (*int_dst_ptr) = (int)((*int_dst_ptr) OPERATOR value_location_pool.get_double_value(src_location));\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"int_s::"OPERATOR_NAME);\
\
   int *int_dst_ptr = value_location_pool.get_int_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*int_dst_ptr) OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*int_dst_ptr) OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*int_dst_ptr) OPERATOR value_location_pool.get_int_value(src_location);\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   int result = 0;\
   bool done = false;\
\
   int int_dst_value = value_location_pool.get_int_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 result = int_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 result = int_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 {\
	    result = int_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	       done = true;\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 result = (int)(int_dst_value OPERATOR value_location_pool.get_double_value(src_location));\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
\
   if (!done) {\
      if (dst_location.uc_third & c_value_modifier_TMP) {\
	 IM_ACCESS_INT_TRG(dst_location.ulli_second) = result;\
	 exp_stack.push(dst_location_idx);\
      }\
      else {\
	 unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	 tmp_variables_array.last().push(result_location_idx);\
	 exp_stack.push(result_location_idx);\
      }\
   }\
}

#define BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   int int_dst_value = value_location_pool.get_int_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 {\
	    int result = int_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
\
	    if (dst_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(dst_location.ulli_second) = result;\
	       exp_stack.push(dst_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_SHORT:\
	 {\
	    int result = int_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
\
	    if (dst_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(dst_location.ulli_second) = result;\
	       exp_stack.push(dst_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      case c_value_type_INT:\
	 {\
	    int result = int_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       if (dst_location.uc_third & c_value_modifier_TMP) {\
		  IM_ACCESS_INT_TRG(dst_location.ulli_second) = result;\
		  exp_stack.push(dst_location_idx);\
	       }\
	       else {\
		  unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
		  tmp_variables_array.last().push(result_location_idx);\
		  exp_stack.push(result_location_idx);\
	       }\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 {\
	    double result = int_dst_value OPERATOR value_location_pool.get_double_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_DOUBLE_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*((unsigned long long *)&result),c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_INT_BINARY_OPS_CHAR_SHORT_INT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   int result = 0;\
   bool done = false;\
\
   int int_dst_value = value_location_pool.get_int_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 result = int_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 result = int_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 {\
	    result = int_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	       done = true;\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
\
   if (!done) {\
      if (dst_location.uc_third & c_value_modifier_TMP) {\
	 IM_ACCESS_INT_TRG(dst_location.ulli_second) = result;\
	 exp_stack.push(dst_location_idx);\
      }\
      else {\
	 unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
	 tmp_variables_array.last().push(result_location_idx);\
	 exp_stack.push(result_location_idx);\
      }\
   }\
}

#define BIC_INT_UNARY_WRITABLE_POST_TMP_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.pop()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"int_s::"OPERATOR_NAME);\
\
   int *int_ptr = value_location_pool.get_int_ptr(location);\
\
   int result = (*int_ptr) OPERATOR ;\
\
   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
   tmp_variables_array.last().push(result_location_idx);\
   exp_stack.push(result_location_idx);\
}

#define BIC_INT_UNARY_WRITABLE_PRE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.last()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"int_s::"OPERATOR_NAME);\
\
   int *int_ptr = value_location_pool.get_int_ptr(location);\
\
   (*int_ptr) OPERATOR ;\
}

#define BIC_INT_UNARY_PRE_TMP_RESULT(OPERATOR) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned location_idx = exp_stack.pop();\
   value_location_s &location = value_location_pool[location_idx];\
\
   int int_value = value_location_pool.get_int_value(location);\
\
   int result = OPERATOR int_value;\
\
   if (location.uc_third & c_value_modifier_TMP) {\
      IM_ACCESS_INT_TRG(location.ulli_second) = result;\
      exp_stack.push(location_idx);\
   }\
   else {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

/*
 * functions of structure int_s
 */

void bic_int_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"int_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_int_ptr(dst_location)) = (int)value_location_pool.get_char_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_CHAR;
	       IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    }
	    break;
	 case c_value_type_SHORT:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_int_ptr(dst_location)) = (int)value_location_pool.get_short_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_SHORT;
	       IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    }
	    break;
	 case c_value_type_INT:
	    (*value_location_pool.get_int_ptr(dst_location)) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_int_ptr(dst_location)) = (int)value_location_pool.get_double_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_DOUBLE;
	       IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    }
	    break;
	 case c_value_type_COLOR:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"color_s",(unsigned)"int_s",(unsigned)"int_s::operator_binary_equal");
	    
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"thread_s",(unsigned)"int_s",(unsigned)"int_s::operator_binary_equal");
	    
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::operator_binary_equal");
	 }
      }
      else {
	 err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s",(unsigned)"int_s::operator_binary_equal");

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_s",(unsigned)"int_s::operator_binary_equal");

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_int_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus_equal");
}
void bic_int_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus_equal");
}

void bic_int_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk_equal");
}

void bic_int_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash_equal");
}

void bic_int_operator_binary_percent_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(%=,"operator_binary_percent_equal");
}

void bic_int_operator_binary_double_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(<<=,"operator_binary_double_ls_br_equal");
}

void bic_int_operator_binary_double_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(>>=,"operator_binary_double_rs_br_equal");
}

void bic_int_operator_binary_ampersand_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(&=,"operator_binary_ampersand_equal");
}

void bic_int_operator_binary_pipe_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(|=,"operator_binary_pipe_equal");
}

void bic_int_operator_binary_circumflex_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_EQUAL_OPS_CHAR_SHORT_INT(^=,"operator_binary_circumflex_equal");
}

void bic_int_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(&&,"operator_binary_double_ampersand");
}

void bic_int_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(||,"operator_binary_double_pipe");
}

void bic_int_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT(&,"operator_binary_ampersand");
}

void bic_int_operator_binary_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT(|,"operator_binary_pipe");
}

void bic_int_operator_binary_circumflex(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT(^,"operator_binary_circumflex");
}

void bic_int_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(==,"operator_binary_double_equal");
}

void bic_int_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(!=,"operator_binary_exclamation_equal");
}

void bic_int_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>,"operator_binary_rs_br");
}

void bic_int_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<,"operator_binary_ls_br");
}

void bic_int_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>=,"operator_binary_rs_br_equal");
}

void bic_int_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<=,"operator_binary_ls_br_equal");
}

void bic_int_operator_binary_double_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT(>>,"operator_binary_double_rs_br");
}

void bic_int_operator_binary_double_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT(<<,"operator_binary_double_ls_br");
}

void bic_int_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus");
}

void bic_int_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus");
}

void bic_int_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk");
}

void bic_int_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash");
}

void bic_int_operator_binary_percent(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_BINARY_OPS_CHAR_SHORT_INT(%,"operator_binary_percent");
}

void bic_int_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_WRITABLE_POST_TMP_RESULT(++,"operator_unary_post_double_plus");
}

void bic_int_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_WRITABLE_POST_TMP_RESULT(--,"operator_unary_post_double_minus");
}

void bic_int_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_WRITABLE_PRE(++,"operator_unary_pre_double_plus");
}

void bic_int_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_WRITABLE_PRE(--,"operator_unary_pre_double_minus");
}

void bic_int_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_PRE_TMP_RESULT(+);
}

void bic_int_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_PRE_TMP_RESULT(-);
}

void bic_int_operator_unary_pre_exclamation(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_PRE_TMP_RESULT(!);
}

void bic_int_operator_unary_pre_tilde(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_INT_UNARY_PRE_TMP_RESULT(~);
}

void bic_int_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   printf("%d",value_location_pool.get_int_value(location));
}

void bic_int_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_INT,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_int_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.pop()];

   char res_str[c_int_max_str_length];
   unsigned res_str_length = snprintf(res_str,c_int_max_str_length,"%d",value_location_pool.get_int_value(location));

   err_test2(res_str_length < c_int_max_str_length,c_DR_ERR_EXCEED_MAX_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"int_s");

   string_s *string_ptr = (string_s *)cmalloc(sizeof(string_s));
   string_ptr->init();
   string_ptr->set(res_str_length,res_str);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_STRING,IM_ACCESS_DATA_PTR(string_ptr),c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

/*
 * definition of repetitive codes of individual operations
 */

#define BIC_DOUBLE_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME)\
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &src_location = value_location_pool[exp_stack.pop()];\
   value_location_s &dst_location = value_location_pool[exp_stack.last()];\
\
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"double_s::"OPERATOR_NAME);\
\
   double *double_dst_ptr = value_location_pool.get_double_ptr(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 (*double_dst_ptr) OPERATOR ## = value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 (*double_dst_ptr) OPERATOR ## = value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 (*double_dst_ptr) OPERATOR ## = value_location_pool.get_int_value(src_location);\
	 break;\
      case c_value_type_DOUBLE:\
	 (*double_dst_ptr) OPERATOR ## = value_location_pool.get_double_value(src_location);\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   int result = 0;\
   bool done = false;\
\
   double double_dst_value = value_location_pool.get_double_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 result = double_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 result = double_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 {\
	    result = double_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_INT_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	       done = true;\
	    }\
	 }\
	 break;\
      case c_value_type_DOUBLE:\
	 result = double_dst_value OPERATOR value_location_pool.get_double_value(src_location);\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
\
   if (!done) {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

#define BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   double result = 0.0;\
   bool done = false;\
\
   double double_dst_value = value_location_pool.get_double_value(dst_location);\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch(src_location.ui_first) {\
      case c_value_type_CHAR:\
	 result = double_dst_value OPERATOR value_location_pool.get_char_value(src_location);\
	 break;\
      case c_value_type_SHORT:\
	 result = double_dst_value OPERATOR value_location_pool.get_short_value(src_location);\
	 break;\
      case c_value_type_INT:\
	 result = double_dst_value OPERATOR value_location_pool.get_int_value(src_location);\
	 break;\
      case c_value_type_DOUBLE:\
	 {\
	    result = double_dst_value OPERATOR value_location_pool.get_double_value(src_location);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       IM_ACCESS_DOUBLE_TRG(src_location.ulli_second) = result;\
	       exp_stack.push(src_location_idx);\
	       done = true;\
	    }\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
\
   if (!done) {\
      if (dst_location.uc_third & c_value_modifier_TMP) {\
	 IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = result;\
	 exp_stack.push(dst_location_idx);\
      }\
      else {\
	 unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*((unsigned long long *)&result),c_value_modifier_TMP);\
	 tmp_variables_array.last().push(result_location_idx);\
	 exp_stack.push(result_location_idx);\
      }\
   }\
}

#define BIC_DOUBLE_UNARY_WRITABLE_POST_TMP_RESULT(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.pop()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"double_s::"OPERATOR_NAME);\
\
   double *double_ptr = value_location_pool.get_double_ptr(location);\
\
   double result = (*double_ptr) OPERATOR ;\
\
   unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*((unsigned long long *)&result),c_value_modifier_TMP);\
   tmp_variables_array.last().push(result_location_idx);\
   exp_stack.push(result_location_idx);\
}

#define BIC_DOUBLE_UNARY_WRITABLE_PRE(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   value_location_s &location = value_location_pool[exp_stack.last()];\
   err_test2(location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"double_s::"OPERATOR_NAME);\
\
   double *double_ptr = value_location_pool.get_double_ptr(location);\
\
   (*double_ptr) OPERATOR ;\
}

#define BIC_DOUBLE_UNARY_PRE_TMP_RESULT(OPERATOR) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned location_idx = exp_stack.pop();\
   value_location_s &location = value_location_pool[location_idx];\
\
   double double_value = value_location_pool.get_double_value(location);\
\
   double result = OPERATOR double_value;\
\
   if (location.uc_third & c_value_modifier_TMP) {\
      IM_ACCESS_DOUBLE_TRG(location.ulli_second) = result;\
      exp_stack.push(location_idx);\
   }\
   else {\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*((unsigned long long *)&result),c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
}

/*
 * functions of structure double_s
 */

void bic_double_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];
   
   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"double_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_double_ptr(dst_location)) = (double)value_location_pool.get_char_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_CHAR;
	       IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    }
	    break;
	 case c_value_type_SHORT:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_double_ptr(dst_location)) = (double)value_location_pool.get_short_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_SHORT;
	       IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    }
	    break;
	 case c_value_type_INT:
	    if (dst_location.uc_third & c_value_modifier_INDEXED) {
	       (*value_location_pool.get_double_ptr(dst_location)) = (double)value_location_pool.get_int_value(src_location);
	    }
	    else {
	       dst_location.ui_first = c_value_type_INT;
	       IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    }
	    break;
	 case c_value_type_DOUBLE:
	    (*value_location_pool.get_double_ptr(dst_location)) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"color_s",(unsigned)"double_s",(unsigned)"double_s::operator_binary_equal");
	    
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)"thread_s",(unsigned)"double_s",(unsigned)"double_s::operator_binary_equal");
	    
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s::operator_binary_equal");
	 }
      }
      else {
	 err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s",(unsigned)"double_s::operator_binary_equal");

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      err_test4(!(dst_location.uc_third & c_value_modifier_INDEXED),c_R_ERR_CANNOT_ASSING_TO_INDEXED,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_s",(unsigned)"double_s::operator_binary_equal");

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_double_operator_binary_plus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus_equal");
}

void bic_double_operator_binary_minus_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus_equal");
}

void bic_double_operator_binary_asterisk_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk_equal");
}

void bic_double_operator_binary_slash_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_EQUAL_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash_equal");
}

void bic_double_operator_binary_double_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(&&,"operator_binary_double_ampersand");
}

void bic_double_operator_binary_double_pipe(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(||,"operator_binary_double_pipe");
}

void bic_double_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(==,"operator_binary_double_equal");
}

void bic_double_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(!=,"operator_binary_exclamation_equal");
}

void bic_double_operator_binary_rs_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>,"operator_binary_rs_br");
}

void bic_double_operator_binary_ls_br(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<,"operator_binary_ls_br");
}

void bic_double_operator_binary_rs_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(>=,"operator_binary_rs_br_equal");
}

void bic_double_operator_binary_ls_br_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE_INT_RESULT(<=,"operator_binary_ls_br_equal");
}

void bic_double_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(+,"operator_binary_plus");
}

void bic_double_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(-,"operator_binary_minus");
}

void bic_double_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(*,"operator_binary_asterisk");
}

void bic_double_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_BINARY_OPS_CHAR_SHORT_INT_DOUBLE(/,"operator_binary_slash");
}

void bic_double_operator_unary_post_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_UNARY_WRITABLE_POST_TMP_RESULT(++,"operator_unary_post_double_plus");
}

void bic_double_operator_unary_post_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_UNARY_WRITABLE_POST_TMP_RESULT(--,"operator_unary_post_double_minus");
}

void bic_double_operator_unary_pre_double_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_UNARY_WRITABLE_PRE(++,"operator_unary_pre_double_plus");
}

void bic_double_operator_unary_pre_double_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_UNARY_WRITABLE_PRE(--,"operator_unary_pre_double_minus");
}

void bic_double_operator_unary_pre_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_UNARY_PRE_TMP_RESULT(+);
}

void bic_double_operator_unary_pre_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_DOUBLE_UNARY_PRE_TMP_RESULT(-);
}

void bic_double_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   printf("%f",value_location_pool.get_double_value(location));
}

void bic_double_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_DOUBLE,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_double_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.pop()];

   char res_str[c_double_max_str_length];
   unsigned res_str_length = snprintf(res_str,c_double_max_str_length,"%f",value_location_pool.get_double_value(location));

   err_test2(res_str_length < c_double_max_str_length,c_DR_ERR_EXCEED_MAX_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"double_s");

   string_s *string_ptr = (string_s *)cmalloc(sizeof(string_s));
   string_ptr->init();
   string_ptr->set(res_str_length,res_str);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_STRING,IM_ACCESS_DATA_PTR(string_ptr),c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

/*
 * functions of structure color_s
 */

void bic_color_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"color_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);;
	    break;
	 case c_value_type_INT:
	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    *(long long unsigned *)value_location_pool.get_color_ptr(dst_location) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"color_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"color_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_color_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   /* ***** */

   unsigned src_location_idx = exp_stack.pop();
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   short *dst_color_ptr = value_location_pool.get_color_ptr(dst_location);

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_COLOR:
	 {
	    short *src_color_ptr = value_location_pool.get_color_ptr(src_location);
	    short *trg_color_ptr;

	    if (src_location.uc_third & c_value_modifier_TMP) {
	       trg_color_ptr = src_color_ptr;
	       exp_stack.push(src_location_idx);
	    }
	    else {
	       if (dst_location.uc_third & c_value_modifier_TMP) {
		  trg_color_ptr = dst_color_ptr;
		  exp_stack.push(dst_location_idx);
	       }
	       else {
		  unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
		  tmp_variables_array.last().push(result_location_idx);
		  exp_stack.push(result_location_idx);

		  trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
	       }
	    }

	    trg_color_ptr[0] = dst_color_ptr[0] + src_color_ptr[0];
	    trg_color_ptr[1] = dst_color_ptr[1] + src_color_ptr[1];
	    trg_color_ptr[2] = dst_color_ptr[2] + src_color_ptr[2];
	 }
	 break;
      case c_value_type_LOCAL_IMG:
	 {
	    local_img_s *sli_ptr = IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second);
	    local_img_s *tli_ptr;

	    if (src_location.uc_third & c_value_modifier_TMP) {
	       tli_ptr = sli_ptr;
	       exp_stack.push(src_location_idx);
	    }
	    else {
	       tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));
	       tli_ptr->init();

	       unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);
	       tmp_variables_array.last().push(result_location_idx);
	       exp_stack.push(result_location_idx);
	    }

	    bool result;
	    
	    if (_this.multiple_threads) {
	       result = tli_ptr->lock_add_color(_this.mutex,*sli_ptr,dst_color_ptr);
	    }
	    else {
	       result = tli_ptr->add_color(*sli_ptr,dst_color_ptr);
	    }

	    err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"color_s::operator_binary_plus");
	 }
	 break;
      default:
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"color_s::operator_binary_plus");
      }
   }
   else {
      assert(0);
   }
}

void bic_color_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   /* ***** */

   unsigned src_location_idx = exp_stack.pop();
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   short *dst_color_ptr = value_location_pool.get_color_ptr(dst_location);

   err_test3(src_location.ui_first == c_value_type_COLOR,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"color_s::operator_binary_minus");

   short *src_color_ptr = value_location_pool.get_color_ptr(src_location);
   short *trg_color_ptr;

   if (src_location.uc_third & c_value_modifier_TMP) {
      trg_color_ptr = src_color_ptr;
      exp_stack.push(src_location_idx);
   }
   else {
      if (dst_location.uc_third & c_value_modifier_TMP) {
	 trg_color_ptr = dst_color_ptr;
	 exp_stack.push(dst_location_idx);
      }
      else {
	 unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
	 tmp_variables_array.last().push(result_location_idx);
	 exp_stack.push(result_location_idx);

	 trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
      }
   }

   trg_color_ptr[0] = dst_color_ptr[0] - src_color_ptr[0];
   trg_color_ptr[1] = dst_color_ptr[1] - src_color_ptr[1];
   trg_color_ptr[2] = dst_color_ptr[2] - src_color_ptr[2];
}

void bic_color_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   /* ***** */

   unsigned src_location_idx = exp_stack.pop();
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   short *dst_color_ptr = value_location_pool.get_color_ptr(dst_location);

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 {
	    char src_char_value = value_location_pool.get_char_value(src_location);
	    short *trg_color_ptr;

	    if (dst_location.uc_third & c_value_modifier_TMP) {
	       trg_color_ptr = dst_color_ptr;
	       exp_stack.push(dst_location_idx);
	    }
	    else {
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
	       tmp_variables_array.last().push(result_location_idx);
	       exp_stack.push(result_location_idx);

	       trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
	    }

	    trg_color_ptr[0] = dst_color_ptr[0] * src_char_value;
	    trg_color_ptr[1] = dst_color_ptr[1] * src_char_value;
	    trg_color_ptr[2] = dst_color_ptr[2] * src_char_value;
	 }
	 break;
      case c_value_type_SHORT:
	 {
	    short src_short_value = value_location_pool.get_short_value(src_location);
	    short *trg_color_ptr;

	    if (dst_location.uc_third & c_value_modifier_TMP) {
	       trg_color_ptr = dst_color_ptr;
	       exp_stack.push(dst_location_idx);
	    }
	    else {
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
	       tmp_variables_array.last().push(result_location_idx);
	       exp_stack.push(result_location_idx);

	       trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
	    }

	    trg_color_ptr[0] = dst_color_ptr[0] * src_short_value;
	    trg_color_ptr[1] = dst_color_ptr[1] * src_short_value;
	    trg_color_ptr[2] = dst_color_ptr[2] * src_short_value;
	 }
	 break;
      case c_value_type_INT:
	 {
	    int src_int_value = value_location_pool.get_int_value(src_location);
	    short *trg_color_ptr;

	    if (dst_location.uc_third & c_value_modifier_TMP) {
	       trg_color_ptr = dst_color_ptr;
	       exp_stack.push(dst_location_idx);
	    }
	    else {
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
	       tmp_variables_array.last().push(result_location_idx);
	       exp_stack.push(result_location_idx);

	       trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
	    }

	    trg_color_ptr[0] = dst_color_ptr[0] * src_int_value;
	    trg_color_ptr[1] = dst_color_ptr[1] * src_int_value;
	    trg_color_ptr[2] = dst_color_ptr[2] * src_int_value;
	 }
	 break;
      case c_value_type_DOUBLE:
	 {
	    double src_double_value = value_location_pool.get_double_value(src_location);
	    short *trg_color_ptr;

	    if (dst_location.uc_third & c_value_modifier_TMP) {
	       trg_color_ptr = dst_color_ptr;
	       exp_stack.push(dst_location_idx);
	    }
	    else {
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
	       tmp_variables_array.last().push(result_location_idx);
	       exp_stack.push(result_location_idx);

	       trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
	    }

	    trg_color_ptr[0] = (short)(dst_color_ptr[0] * src_double_value);
	    trg_color_ptr[1] = (short)(dst_color_ptr[1] * src_double_value);
	    trg_color_ptr[2] = (short)(dst_color_ptr[2] * src_double_value);
	 }
	 break;
      case c_value_type_LOCAL_IMG:
	 {
	    local_img_s *sli_ptr = IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second);
	    local_img_s *tli_ptr;

	    if (src_location.uc_third & c_value_modifier_TMP) {
	       tli_ptr = sli_ptr;
	       exp_stack.push(src_location_idx);
	    }
	    else {
	       tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));
	       tli_ptr->init();

	       unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);
	       tmp_variables_array.last().push(result_location_idx);
	       exp_stack.push(result_location_idx);
	    }

	    bool result;
	    
	    if (_this.multiple_threads) {
	       result = tli_ptr->lock_mul_color(_this.mutex,*sli_ptr,dst_color_ptr);
	    }
	    else {
	       result = tli_ptr->mul_color(*sli_ptr,dst_color_ptr);
	    }

	    err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"color_s::operator_binary_asterisk");
	 }
	 break;
      default:
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"color_s::operator_binary_asterisk");
      }
   }
   else {
      assert(0);
   }
}

void bic_color_operator_binary_slash(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   /* ***** */

   unsigned src_location_idx = exp_stack.pop();
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   short *dst_color_ptr = value_location_pool.get_color_ptr(dst_location);
   short *trg_color_ptr;

   if (dst_location.uc_third & c_value_modifier_TMP) {
      trg_color_ptr = dst_color_ptr;
      exp_stack.push(dst_location_idx);
   }
   else {
      unsigned result_location_idx = value_location_pool.insert(c_value_type_COLOR,(unsigned long long)0,c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);

      trg_color_ptr = (short *)&value_location_pool[result_location_idx].ulli_second;
   }

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 {
	    char src_char_value = value_location_pool.get_char_value(src_location);

	    trg_color_ptr[0] = dst_color_ptr[0] / src_char_value;
	    trg_color_ptr[1] = dst_color_ptr[1] / src_char_value;
	    trg_color_ptr[2] = dst_color_ptr[2] / src_char_value;
	 }
	 break;
      case c_value_type_SHORT:
	 {
	    short src_short_value = value_location_pool.get_short_value(src_location);

	    trg_color_ptr[0] = dst_color_ptr[0] / src_short_value;
	    trg_color_ptr[1] = dst_color_ptr[1] / src_short_value;
	    trg_color_ptr[2] = dst_color_ptr[2] / src_short_value;
	 }
	 break;
      case c_value_type_INT:
	 {
	    int src_int_value = value_location_pool.get_int_value(src_location);

	    trg_color_ptr[0] = dst_color_ptr[0] / src_int_value;
	    trg_color_ptr[1] = dst_color_ptr[1] / src_int_value;
	    trg_color_ptr[2] = dst_color_ptr[2] / src_int_value;
	 }
	 break;
      case c_value_type_DOUBLE:
	 {
	    double src_double_value = value_location_pool.get_double_value(src_location);

	    trg_color_ptr[0] = (short)(dst_color_ptr[0] / src_double_value);
	    trg_color_ptr[1] = (short)(dst_color_ptr[1] / src_double_value);
	    trg_color_ptr[2] = (short)(dst_color_ptr[2] / src_double_value);
	 }
	 break;
      default:
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"color_s::operator_binary_slash");
      }
   }
   else {
      assert(0);
   }
}

void bic_color_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   int result = 0;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 result = (int)value_location_pool.get_char_value(src_location);
	 break;
      case c_value_type_SHORT:
	 result = (int)value_location_pool.get_short_value(src_location);
	 break;
      case c_value_type_INT:
	 result = value_location_pool.get_int_value(src_location);
	 break;
      default:
	 err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"color_s::operator_binary_le_br_re_br");
      }
   }
   else {
      assert(0);
   }

   // - test if index fit in requested range -
   err_test2(result <= 3,c_R_ERR_IDX_EXCEED_ARRAY_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"color_s");

   unsigned long long indexed_descriptor = ((unsigned long long)dst_location_idx << 32 ) | ((unsigned long long)result);
   unsigned result_location_idx = value_location_pool.insert(c_value_type_SHORT,indexed_descriptor,(dst_location.uc_third & c_value_modifier_WRITABLE) | c_value_modifier_INDEXED);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_color_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];

   short *color_ptr = value_location_pool.get_color_ptr(location);
   printf("color r:%hd g:%hd b:%hd a:%hd",color_ptr[0],color_ptr[1],color_ptr[2],color_ptr[3]);
}

void bic_color_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_COLOR,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_color_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.pop()];

   short *color_ptr = value_location_pool.get_color_ptr(location);

   char res_str[c_color_max_length];
   unsigned res_str_length = snprintf(res_str,c_color_max_length,"color(%hd,%hd,%hd)",color_ptr[0],color_ptr[1],color_ptr[2]);

   err_test2(res_str_length < c_color_max_length,c_DR_ERR_EXCEED_MAX_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"color_s");

   string_s *string_ptr = (string_s *)cmalloc(sizeof(string_s));
   string_ptr->init();
   string_ptr->set(res_str_length,res_str);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_STRING,IM_ACCESS_DATA_PTR(string_ptr),c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

/*
 * functions of structure thread_s
 */

void bic_thread_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"thread_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"thread_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"thread_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_thread_function_join_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test if is enabled multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   unsigned thread_idx;
   int result_value = c_tc_THREAD_OK;
  
   // - retrieval of index of thread on which want actual thread join -
   {
      ui_array_s &exp_stack = _this.sp_thread_pool[a_thread_idx].exp_stack;

      // *****

      value_location_s &location = _this.value_location_pool[exp_stack.pop()];
      thread_idx = IM_ACCESS_THREAD_SRC(location.ulli_second);
   }

   if (thread_idx == a_thread_idx) {
      result_value = c_tc_THREAD_ERR_DEADLK;
   }
   else {
      switch(_this.sp_thread_pool[thread_idx].state) {
      case c_thread_state_JOINABLE:
	 {
	    // - setting of thread stated as joined to actual thread -
	    _this.sp_thread_pool[thread_idx].state = c_thread_state_JOINED;

	    // - waiting on thread ending -
	    do {

	       sp_thread_s &sp_thread = _this.sp_thread_pool[thread_idx];

	       if (sp_thread.state == c_thread_state_JOINED_ENDED) {

		  int result = pthread_join(sp_thread.pthread,NULL);
		  err_test1(result == 0,c_R_ERR_THREAD_FUNCTION_RETURN,_this.get_line_number(a_thread_idx));

		  sp_thread.state = c_thread_state_NOT_EXIST;
		  _this.sp_thread_pool.remove(thread_idx);
		  break;
	       }
	       else {

		  // - UNLOCK -
		  _this.mutex.unlock();

		  // - YIELD -
		  pthread_yield();

		  // - LOCK -
		  _this.mutex.lock();
	       }
	    } while(1);
	 }
	 break;
      case c_thread_state_JOINABLE_ENDED:
	 {
	    sp_thread_s &sp_thread = _this.sp_thread_pool[thread_idx];

	    int result = pthread_join(sp_thread.pthread,NULL);
	    err_test1(result == 0,c_R_ERR_THREAD_FUNCTION_RETURN,_this.get_line_number(a_thread_idx));

	    sp_thread.state = c_thread_state_NOT_EXIST;
	    _this.sp_thread_pool.remove(thread_idx);
	 }
	 break;
      case c_thread_state_DETACHED:
      case c_thread_state_JOINED:
      case c_thread_state_JOINED_ENDED:
	 result_value = c_tc_THREAD_ERR_INVAL;
	 break;
      case c_thread_state_NOT_EXIST:
	 result_value = c_tc_THREAD_ERR_SEARCH;
	 break;
      default:
	 assert(0);
      }
   }

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_thread_function_detach_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test if is enabled multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   unsigned thread_idx;
   int result_value = c_tc_THREAD_OK;

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_pool_s &sp_thread_pool = _this.sp_thread_pool;
   sp_thread_s &sp_thread = sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];
   thread_idx = IM_ACCESS_THREAD_SRC(location.ulli_second);
   assert(thread_idx != 0);

   sp_thread_s &thread = sp_thread_pool[thread_idx];

   // - test of thread state -
   switch (thread.state) {
   case c_thread_state_JOINABLE:
      {
	 int result = pthread_detach(thread.pthread);
	 err_test1(result == 0,c_R_ERR_THREAD_FUNCTION_RETURN,_this.get_line_number(a_thread_idx));

	 thread.state = c_thread_state_DETACHED;
      }
      break;
   case c_thread_state_JOINABLE_ENDED:
      {
	 int result = pthread_join(sp_thread.pthread,NULL);
	 err_test1(result == 0,c_R_ERR_THREAD_FUNCTION_RETURN,_this.get_line_number(a_thread_idx));

	 thread.state = c_thread_state_NOT_EXIST;
	 _this.sp_thread_pool.remove(thread_idx);
      }
      break;
   case c_thread_state_JOINED:
   case c_thread_state_JOINED_ENDED:
   case c_thread_state_DETACHED:
      result_value = c_tc_THREAD_ERR_INVAL;
      break;
   case c_thread_state_NOT_EXIST:
      result_value = c_tc_THREAD_ERR_SEARCH;
      break;
   default:
      assert(0);
   }

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_thread_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   printf("thread: %u",IM_ACCESS_THREAD_SRC(location.ulli_second));
}

void bic_thread_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_THREAD,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

/*
 * functions of structure string_s
 */

void bic_string_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"string_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));
	    
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));
	    
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       *IM_ACCESS_STRING_PTR(dst_location.ulli_second) = *IM_ACCESS_STRING_PTR(src_location.ulli_second);
	       break;
	    case c_value_type_LOCAL_IMG:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      IM_ACCESS_STRING_PTR(dst_location.ulli_second)->clear();
      cfree(IM_ACCESS_STRING_PTR(dst_location.ulli_second));

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_string_operator_binary_ampersand(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"string_s::operator_binary_ampersand");
}

void bic_string_operator_binary_double_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   err_test3(src_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::operator_binary_double_equal");

   int result = (*(IM_ACCESS_STRING_PTR(dst_location.ulli_second)) == *(IM_ACCESS_STRING_PTR(src_location.ulli_second)));

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_string_operator_binary_exclamation_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   err_test3(src_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::operator_binary_exclamation_equal");

   int result = !(*(IM_ACCESS_STRING_PTR(dst_location.ulli_second)) == *(IM_ACCESS_STRING_PTR(src_location.ulli_second)));

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_string_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned src_location_idx = exp_stack.pop();
   unsigned dst_location_idx = exp_stack.pop();

   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   err_test3(src_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::operator_binary_ampersand");

   string_s *src_string_ptr = IM_ACCESS_STRING_PTR(src_location.ulli_second);
   string_s *dst_string_ptr = IM_ACCESS_STRING_PTR(dst_location.ulli_second);
   string_s *conc_string_ptr = (string_s *)cmalloc(sizeof(string_s));

   conc_string_ptr->init();
   conc_string_ptr->conc_set(dst_string_ptr->size - 1,dst_string_ptr->data,src_string_ptr->size - 1,src_string_ptr->data);

   if (src_location.uc_third & c_value_modifier_TMP) {
      src_string_ptr->clear();
      cfree(src_string_ptr);

      src_location.ulli_second = (unsigned long long)(unsigned)conc_string_ptr;
      exp_stack.push(src_location_idx);
   }
   else {
      if (dst_location.uc_third & c_value_modifier_TMP) {
	 dst_string_ptr->clear();
	 cfree(dst_string_ptr);

	 dst_location.ulli_second = (unsigned long long)(unsigned)conc_string_ptr;
	 exp_stack.push(dst_location_idx);
      }
      else {
	 unsigned conc_location_idx = value_location_pool.insert(c_value_type_STRING,(unsigned long long)(unsigned)conc_string_ptr,c_value_modifier_TMP);
	 tmp_variables_array.last().push(conc_location_idx);
	 exp_stack.push(conc_location_idx);
      }
   }
}

void bic_string_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"string_s::operator_binary_asterisk");
}

void bic_string_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   int result = 0;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 result = (int)value_location_pool.get_char_value(src_location);
	 break;
      case c_value_type_SHORT:
	 result = (int)value_location_pool.get_short_value(src_location);
	 break;
      case c_value_type_INT:
	 result = value_location_pool.get_int_value(src_location);
	 break;
      default:
	 err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"string_s::operator_binary_le_br_re_br");
      }
   }
   else {
      assert(0);
   }

   // - test if index fits in string length -
   err_test2((int)(IM_ACCESS_STRING_PTR(dst_location.ulli_second)->size - 1) > result,c_R_ERR_IDX_EXCEED_ARRAY_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"string_s");

   unsigned long long indexed_descriptor = ((unsigned long long)dst_location_idx << 32 ) | ((unsigned long long)result);
   unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,indexed_descriptor,(dst_location.uc_third & c_value_modifier_WRITABLE) | c_value_modifier_INDEXED);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_string_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   printf("%s",IM_ACCESS_STRING_PTR(location.ulli_second)->data);
}

void bic_string_function_length_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   int result = (int)IM_ACCESS_STRING_PTR(location.ulli_second)->size - 1;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_string_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_STRING,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_string_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   err_test3(src_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::function_get_idx_1");

   string_s *src_string_ptr = IM_ACCESS_STRING_PTR(src_location.ulli_second);
   string_s *dst_string_ptr = IM_ACCESS_STRING_PTR(dst_location.ulli_second);

   int result;
   char *idx_ptr = strstr(dst_string_ptr->data,src_string_ptr->data);

   if (idx_ptr != NULL) {
      result = idx_ptr - dst_string_ptr->data;
   }
   else {
      result = -1;
   }

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_string_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // *****
}

void bic_string_function_split_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   err_test3(src_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"string_s::function_split_1");

   string_s *src_string_ptr = IM_ACCESS_STRING_PTR(src_location.ulli_second);
   string_s *dst_string_ptr = IM_ACCESS_STRING_PTR(dst_location.ulli_second);
   ui_array_s *obj_array_ptr = (ui_array_s *)cmalloc(sizeof(ui_array_s));
   obj_array_ptr->init();

   {
      char *dst_ptr = dst_string_ptr->data;
      char *new_dst_ptr;

      while((new_dst_ptr = strstr(dst_ptr,src_string_ptr->data)) != NULL) {
	 
	 string_s *new_string_ptr = (string_s *)cmalloc(sizeof(string_s));
	 new_string_ptr->init();
	 new_string_ptr->set(new_dst_ptr - dst_ptr,dst_ptr);

	 unsigned ns_position_idx = value_location_pool.insert(c_value_type_STRING,(unsigned long long)(unsigned)new_string_ptr,c_value_modifier_WRITABLE);
	 obj_array_ptr->push(ns_position_idx);

	 dst_ptr = new_dst_ptr + src_string_ptr->size - 1;
      }

      {
	 string_s *new_string_ptr = (string_s *)cmalloc(sizeof(string_s));
	 new_string_ptr->init();
	 new_string_ptr->set((dst_string_ptr->size - 1) - (dst_ptr - dst_string_ptr->data),dst_ptr);

	 unsigned ns_position_idx = value_location_pool.insert(c_value_type_STRING,(unsigned long long)(unsigned)new_string_ptr,c_value_modifier_WRITABLE);
	 obj_array_ptr->push(ns_position_idx);
      }
   }

   unsigned oa_location_idx = value_location_pool.insert(c_value_type_OBJ_ARRAY,(unsigned long long)(unsigned)obj_array_ptr,c_value_modifier_TMP);
   tmp_variables_array.last().push(oa_location_idx);
   exp_stack.push(oa_location_idx);
}

/*
 * definition of repetitive codes of individual operations
 */

#define BIC_LOCAL_IMG_BINARY_POINT_OPS_COLOR_IMG(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned src_location_idx = exp_stack.pop();\
   unsigned dst_location_idx = exp_stack.pop();\
   value_location_s &src_location = value_location_pool[src_location_idx];\
   value_location_s &dst_location = value_location_pool[dst_location_idx];\
\
   local_img_s *dli_ptr = IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second);\
   local_img_s *tli_ptr;\
\
   if (src_location.ui_first < c_value_type_STRUCT_BASE) {\
      switch (src_location.ui_first) {\
      case c_value_type_COLOR:\
	 {\
	    short *src_color_ptr = value_location_pool.get_color_ptr(src_location);\
	    \
	    if (dst_location.uc_third & c_value_modifier_TMP) {\
	       tli_ptr = dli_ptr;\
	       exp_stack.push(dst_location_idx);\
	    }\
	    else {\
	       tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));\
	       tli_ptr->init();\
\
	       unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);\
	       tmp_variables_array.last().push(result_location_idx);\
	       exp_stack.push(result_location_idx);\
	    }\
\
	    bool result;\
\
	    if (_this.multiple_threads) {\
	       result = tli_ptr->lock_ ## OPERATOR ## _color(_this.mutex,*dli_ptr,src_color_ptr);\
	    }\
	    else {\
	       result = tli_ptr->OPERATOR ## _color(*dli_ptr,src_color_ptr);\
	    }\
\
	    err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::"OPERATOR_NAME);\
	 }\
	 break;\
      case c_value_type_LOCAL_IMG:\
	 {\
	    local_img_s *sli_ptr = IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second);\
\
	    if (src_location.uc_third & c_value_modifier_TMP) {\
	       tli_ptr = sli_ptr;\
	       exp_stack.push(src_location_idx);\
	    }\
	    else {\
	       if (dst_location.uc_third & c_value_modifier_TMP) {\
		  tli_ptr = dli_ptr;\
		  exp_stack.push(dst_location_idx);\
	       }\
	       else {\
		  tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));\
		  tli_ptr->init();\
\
		  unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);\
		  tmp_variables_array.last().push(result_location_idx);\
		  exp_stack.push(result_location_idx);\
	       }\
	    }\
\
	    bool result;\
\
	    if (_this.multiple_threads) {\
	       result = tli_ptr->lock_ ## OPERATOR(_this.mutex,*dli_ptr,*sli_ptr);\
	    }\
	    else {\
	       result = tli_ptr->OPERATOR(*dli_ptr,*sli_ptr);\
	    }\
\
	    err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::"OPERATOR_NAME);\
	 }\
	 break;\
      default:\
	 err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::"OPERATOR_NAME);\
      }\
   }\
   else {\
      assert(0);\
   }\
}

#define BIC_LOCAL_IMG_UNARY_POINT_OPS_IMG(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned location_idx = exp_stack.pop();\
   value_location_s &location = value_location_pool[location_idx];\
\
   local_img_s *li_ptr = IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second);\
   local_img_s *tli_ptr;\
\
   if (location.uc_third & c_value_modifier_TMP) {\
      tli_ptr = li_ptr;\
      exp_stack.push(location_idx);\
   }\
   else {\
      tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));\
      tli_ptr->init();\
\
      unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);\
      tmp_variables_array.last().push(result_location_idx);\
      exp_stack.push(result_location_idx);\
   }\
\
   bool result;\
\
   if (_this.multiple_threads) {\
      result = tli_ptr->lock_ ## OPERATOR(_this.mutex,*li_ptr);\
   }\
   else {\
      result = tli_ptr->OPERATOR(*li_ptr);\
   }\
\
   err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::"OPERATOR_NAME);\
}

#define BIC_LOCAL_IMG_UNARY_OPS_IMG(OPERATOR,OPERATOR_NAME) \
{\
   value_location_pool_s &value_location_pool = _this.value_location_pool;\
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];\
\
   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;\
   ui_array_s &exp_stack = sp_thread.exp_stack;\
\
   /* ***** */\
\
   unsigned location_idx = exp_stack.pop();\
   value_location_s &location = value_location_pool[location_idx];\
\
   local_img_s *li_ptr = IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second);\
   local_img_s *tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));\
   tli_ptr->init();\
\
   bool result;\
\
   if (_this.multiple_threads) {\
      result = tli_ptr->lock_ ## OPERATOR(_this.mutex,*li_ptr);\
   }\
   else {\
      result = tli_ptr->OPERATOR(*li_ptr);\
   }\
\
   err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::"OPERATOR_NAME);\
\
   unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);\
   tmp_variables_array.last().push(result_location_idx);\
   exp_stack.push(result_location_idx);\
}

/*
 * functions of structure local_img_s
 */

void bic_local_img_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       if (_this.multiple_threads) {
		  IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second)->lock_set(_this.mutex,*IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second));
	       }
	       else {
		  IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second)->set(*IM_ACCESS_LOCAL_IMG_PTR(src_location.ulli_second));
	       }
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      value_location_pool.local_img_clear(IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second));

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_local_img_operator_binary_plus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_BINARY_POINT_OPS_COLOR_IMG(add,"operator_binary_plus");
}

void bic_local_img_operator_binary_minus(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_BINARY_POINT_OPS_COLOR_IMG(sub,"operator_binary_minus");
}

void bic_local_img_operator_binary_asterisk(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_BINARY_POINT_OPS_COLOR_IMG(mul,"operator_binary_asterisk");
}

void bic_local_img_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   value_location_pool.local_img_print(IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second));
}

void bic_local_img_function_width_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];
   local_img_s *local_img_ptr = IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)local_img_ptr->img_3ub.width,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_local_img_function_height_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];
   local_img_s *local_img_ptr = IM_ACCESS_LOCAL_IMG_PTR(location.ulli_second);

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)local_img_ptr->img_3ub.height,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_local_img_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_LOCAL_IMG,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_local_img_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::function_to_string_0");
}

void bic_local_img_function_load_bmp_file_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &second_location = value_location_pool[exp_stack.pop()];
   value_location_s &first_location = value_location_pool[exp_stack.last()];

   err_test3(second_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[second_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::function_load_bmp_file_1");

   local_img_s *local_img_ptr = IM_ACCESS_LOCAL_IMG_PTR(first_location.ulli_second);
   string_s *string_ptr = IM_ACCESS_STRING_PTR(second_location.ulli_second);

   bool result;

   if (_this.multiple_threads) {
      result = local_img_ptr->lock_load_bmp_file(_this.mutex,string_ptr->data);
   }
   else {
      result = local_img_ptr->load_bmp_file(string_ptr->data);
   }

   err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::function_load_bmp_file_1");
}

void bic_local_img_function_save_bmp_file_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &second_location = value_location_pool[exp_stack.pop()];
   value_location_s &first_location = value_location_pool[exp_stack.last()];

   err_test3(second_location.ui_first == c_value_type_STRING,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[second_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::function_save_bmp_file_1");

   local_img_s *local_img_ptr = IM_ACCESS_LOCAL_IMG_PTR(first_location.ulli_second);
   string_s *string_ptr = IM_ACCESS_STRING_PTR(second_location.ulli_second);

   bool result;

   if (_this.multiple_threads) {
      result = local_img_ptr->lock_save_bmp_file(_this.mutex,string_ptr->data);
   }
   else {
      result = local_img_ptr->save_bmp_file(string_ptr->data);
   }

   err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::function_save_bmp_file_1");
}

void bic_local_img_function_invert_0(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_UNARY_POINT_OPS_IMG(invert,"function_invert_0");
}

void bic_local_img_function_gray_scale_0(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_UNARY_POINT_OPS_IMG(gray_scale,"function_gray_scale_0");
}

void bic_local_img_function_edge_sobel_0(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_UNARY_OPS_IMG(edge_sobel,"function_edge_sobel_0");
}

void bic_local_img_function_blur_0(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_UNARY_OPS_IMG(blur,"function_blur_0");
}

void bic_local_img_function_sharp_0(unsigned a_thread_idx,script_parser_s &_this)
{
   BIC_LOCAL_IMG_UNARY_OPS_IMG(sharp,"function_sharp_0");
}

void bic_local_img_function_treshold_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   /* ***** */

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   err_test3(src_location.ui_first == c_value_type_COLOR,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::function_treshold_1");

   short *src_color_ptr = value_location_pool.get_color_ptr(src_location);

   local_img_s *dli_ptr = IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second);
   local_img_s *tli_ptr;

   if (dst_location.uc_third & c_value_modifier_TMP) {
      tli_ptr = dli_ptr;
      exp_stack.push(dst_location_idx);
   }
   else {
      tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));
      tli_ptr->init();

      unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }

   bool result;
   if (_this.multiple_threads) {
      result = tli_ptr->lock_treshold(_this.mutex,*dli_ptr,src_color_ptr);
   }
   else {
      result = tli_ptr->treshold(*dli_ptr,src_color_ptr);
   }

   err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::function_treshold_1");
}

void bic_local_img_function_fill_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   /* ***** */

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   err_test3(src_location.ui_first == c_value_type_COLOR,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"local_img_s::function_fill_1");

   short *src_color_ptr = value_location_pool.get_color_ptr(src_location);

   local_img_s *dli_ptr = IM_ACCESS_LOCAL_IMG_PTR(dst_location.ulli_second);
   local_img_s *tli_ptr;

   if (dst_location.uc_third & c_value_modifier_TMP) {
      tli_ptr = dli_ptr;
      exp_stack.push(dst_location_idx);
   }
   else {
      tli_ptr = (local_img_s *)cmalloc(sizeof(local_img_s));
      tli_ptr->init();

      unsigned result_location_idx = value_location_pool.insert(c_value_type_LOCAL_IMG,IM_ACCESS_DATA_PTR(tli_ptr),c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }

   bool result;
   if (_this.multiple_threads) {
      result = tli_ptr->lock_fill_color(_this.mutex,src_color_ptr);
   }
   else {
      result = tli_ptr->fill_color(src_color_ptr);
   }

   err_test2(result,c_R_ERR_IMAGE_OPERATION_RETURN,_this.get_line_number(a_thread_idx),(unsigned)"local_img_s::function_fill_1");
}

/*
 * functions of structure char_array_s
 */

void bic_char_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"char_array_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_array_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));
	       
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       *IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second) = *IM_ACCESS_CHAR_ARRAY_PTR(src_location.ulli_second);
	       break;
	    case c_value_type_INT_ARRAY:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_array_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->clear();
      cfree(IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second));

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_char_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   int result = 0;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 result = (int)value_location_pool.get_char_value(src_location);
	 break;
      case c_value_type_SHORT:
	 result = (int)value_location_pool.get_short_value(src_location);
	 break;
      case c_value_type_INT:
	 result = value_location_pool.get_int_value(src_location);
	 break;
      default:
	 err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"char_array_s::operator_binary_le_br_re_br");
      }
   }
   else {
      assert(0);
   }

   // - test if index fits in array size -
   err_test2((int)IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second)->used > result,c_R_ERR_IDX_EXCEED_ARRAY_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"char_array_s");

   unsigned long long indexed_descriptor = ((unsigned long long)dst_location_idx << 32 ) | ((unsigned long long)result);
   unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,indexed_descriptor,(dst_location.uc_third & c_value_modifier_WRITABLE) | c_value_modifier_INDEXED);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_char_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   value_location_pool.char_array_print(IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second));
}

void bic_char_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   int result = (int)IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second)->used;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_char_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_CHAR_ARRAY,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_char_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   // - retrieval of pointer to array -
   bc_array_s *bc_array_ptr = IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second);

   switch (src_location.ui_first) {
   case c_value_type_CHAR:
      bc_array_ptr->push(value_location_pool.get_char_value(src_location));
      break;
   case c_value_type_SHORT:
      bc_array_ptr->push((char)value_location_pool.get_short_value(src_location));
      break;
   case c_value_type_INT:
      bc_array_ptr->push((char)value_location_pool.get_int_value(src_location));
      break;
   case c_value_type_DOUBLE:
      bc_array_ptr->push((char)value_location_pool.get_double_value(src_location));
      break;
   default:
      err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"char_array_s::function_push_1");
   }

   // - acquire of index of inserted char -
   int result = (int)bc_array_ptr->used - 1;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_char_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   char result = IM_ACCESS_CHAR_ARRAY_PTR(location.ulli_second)->pop();

   unsigned result_location_idx = value_location_pool.insert(c_value_type_CHAR,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_char_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned src_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   bc_array_s *bc_array_ptr = IM_ACCESS_CHAR_ARRAY_PTR(dst_location.ulli_second);

   switch (src_location.ui_first) {
   case c_value_type_CHAR:
      {
	 unsigned idx = bc_array_ptr->get_idx(value_location_pool.get_char_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   case c_value_type_SHORT:
      {
	 unsigned idx = bc_array_ptr->get_idx((char)value_location_pool.get_short_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   case c_value_type_INT:
      {
	 unsigned idx = bc_array_ptr->get_idx((char)value_location_pool.get_int_value(src_location));

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_INT_TRG(src_location.ulli_second) = idx;
	    exp_stack.push(src_location_idx);
	 }
	 else {
	    unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	    tmp_variables_array.last().push(idx_location_idx);
	    exp_stack.push(idx_location_idx);
	 }
      }
      break;
   default:
      err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"char_array_s::function_get_idx_1");
   }
}

void bic_char_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"char_array_s::function_to_string_0");
}

/*
 * functions of structure int_array_s
 */

void bic_int_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"int_array_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_array_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       *IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second) = *IM_ACCESS_INT_ARRAY_PTR(src_location.ulli_second);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_array_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->clear();
      cfree(IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second));

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_int_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   int result = 0;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 result = (int)value_location_pool.get_char_value(src_location);
	 break;
      case c_value_type_SHORT:
	 result = (int)value_location_pool.get_short_value(src_location);
	 break;
      case c_value_type_INT:
	 result = value_location_pool.get_int_value(src_location);
	 break;
      default:
	 err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"int_array_s::operator_binary_le_br_re_br");
      }
   }
   else {
      assert(0);
   }

   // - test if index fit in array size -
   err_test2((int)IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second)->used > result,c_R_ERR_IDX_EXCEED_ARRAY_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"int_array_s");

   unsigned long long indexed_descriptor = ((unsigned long long)dst_location_idx << 32 ) | ((unsigned long long)result);
   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,indexed_descriptor,(dst_location.uc_third & c_value_modifier_WRITABLE) | c_value_modifier_INDEXED);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_int_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   value_location_pool.int_array_print(IM_ACCESS_INT_ARRAY_PTR(location.ulli_second));
}

void bic_int_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   int result = (int)IM_ACCESS_INT_ARRAY_PTR(location.ulli_second)->used;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_int_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_INT_ARRAY,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_int_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   // - retrieve of pointer at array -
   bi_array_s *bi_array_ptr = IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second);

   switch (src_location.ui_first) {
   case c_value_type_CHAR:
      bi_array_ptr->push((int)value_location_pool.get_char_value(src_location));
      break;
   case c_value_type_SHORT:
      bi_array_ptr->push((int)value_location_pool.get_short_value(src_location));
      break;
   case c_value_type_INT:
      bi_array_ptr->push(value_location_pool.get_int_value(src_location));
      break;
   case c_value_type_DOUBLE:
      bi_array_ptr->push((int)value_location_pool.get_double_value(src_location));
      break;
   default:
      err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_array_s::function_push_1");
   }

   // - retrieve of index of inserted integer -
   int result = (int)bi_array_ptr->used - 1;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_int_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   int result = IM_ACCESS_INT_ARRAY_PTR(location.ulli_second)->pop();

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_int_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned src_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   bi_array_s *bi_array_ptr = IM_ACCESS_INT_ARRAY_PTR(dst_location.ulli_second);

   switch (src_location.ui_first) {
   case c_value_type_CHAR:
      {
	 unsigned idx = bi_array_ptr->get_idx((int)value_location_pool.get_char_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   case c_value_type_SHORT:
      {
	 unsigned idx = bi_array_ptr->get_idx((int)value_location_pool.get_short_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   case c_value_type_INT:
      {
	 unsigned idx = bi_array_ptr->get_idx(value_location_pool.get_int_value(src_location));

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_INT_TRG(src_location.ulli_second) = idx;
	    exp_stack.push(src_location_idx);
	 }
	 else {
	    unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	    tmp_variables_array.last().push(idx_location_idx);
	    exp_stack.push(idx_location_idx);
	 }
      }
      break;
   default:
      err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"int_array_s::function_get_idx_1");
   }
}

void bic_int_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"int_array_s::function_to_string_0");
}

/*
 * functions of structure double_array_s
 */

void bic_double_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"double_array_s::operator_binary_equal");

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_array_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	    cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));
	       
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       *IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second) = *IM_ACCESS_DOUBLE_ARRAY_PTR(src_location.ulli_second);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
	       cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_array_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->clear();
      cfree(IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second));

      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_double_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   
   unsigned dst_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[dst_location_idx];

   int result = 0;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 result = (int)value_location_pool.get_char_value(src_location);
	 break;
      case c_value_type_SHORT:
	 result = (int)value_location_pool.get_short_value(src_location);
	 break;
      case c_value_type_INT:
	 result = value_location_pool.get_int_value(src_location);
	 break;
      default:
	 err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"double_array_s::operator_binary_le_br_re_br");
      }
   }
   else {
      assert(0);
   }

   // - test if index fit in array size -
   err_test2((int)IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second)->used > result,c_R_ERR_IDX_EXCEED_ARRAY_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"double_array_s");

   unsigned long long indexed_descriptor = ((unsigned long long)dst_location_idx << 32 ) | ((unsigned long long)result);
   unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,indexed_descriptor,(dst_location.uc_third & c_value_modifier_WRITABLE) | c_value_modifier_INDEXED);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_double_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   value_location_pool.double_array_print(IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second));
}

void bic_double_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   int result = (int)IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second)->used;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_double_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_DOUBLE_ARRAY,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_double_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   // - ziskani ukazatele na pole -
   bd_array_s *bd_array_ptr = IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second);

   switch (src_location.ui_first) {
   case c_value_type_CHAR:
      bd_array_ptr->push((double)value_location_pool.get_char_value(src_location));
      break;
   case c_value_type_SHORT:
      bd_array_ptr->push((double)value_location_pool.get_short_value(src_location));
      break;
   case c_value_type_INT:
      bd_array_ptr->push((double)value_location_pool.get_int_value(src_location));
      break;
   case c_value_type_DOUBLE:
      bd_array_ptr->push(value_location_pool.get_double_value(src_location));
      break;
   default:
      err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_array_s::function_push_1");
   }

   // - retrieve of index of inserted element -
   int result = (int)bd_array_ptr->used - 1;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_double_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   double result = IM_ACCESS_DOUBLE_ARRAY_PTR(location.ulli_second)->pop();

   unsigned result_location_idx = value_location_pool.insert(c_value_type_DOUBLE,*(unsigned long long *)&result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_double_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned src_location_idx = exp_stack.pop();
   value_location_s &src_location = value_location_pool[src_location_idx];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   bd_array_s *bd_array_ptr = IM_ACCESS_DOUBLE_ARRAY_PTR(dst_location.ulli_second);

   switch (src_location.ui_first) {
   case c_value_type_CHAR:
      {
	 unsigned idx = bd_array_ptr->get_idx((double)value_location_pool.get_char_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   case c_value_type_SHORT:
      {
	 unsigned idx = bd_array_ptr->get_idx((double)value_location_pool.get_short_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   case c_value_type_INT:
      {
	 unsigned idx = bd_array_ptr->get_idx((double)value_location_pool.get_int_value(src_location));

	 if (src_location.uc_third & c_value_modifier_TMP) {
	    IM_ACCESS_INT_TRG(src_location.ulli_second) = idx;
	    exp_stack.push(src_location_idx);
	 }
	 else {
	    unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	    tmp_variables_array.last().push(idx_location_idx);
	    exp_stack.push(idx_location_idx);
	 }
      }
      break;
   case c_value_type_DOUBLE:
      {
	 unsigned idx = bd_array_ptr->get_idx(value_location_pool.get_double_value(src_location));

	 unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
	 tmp_variables_array.last().push(idx_location_idx);
	 exp_stack.push(idx_location_idx);
      }
      break;
   default:
      err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"double_array_s::function_get_idx_1");
   }
}

void bic_double_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"double_array_s::function_to_string_0");
}

/*
 * functions of structure obj_array_s
 */

void bic_obj_array_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"obj_array_s::operator_binary_equal");

   value_location_pool.obj_array_clear(IM_ACCESS_OBJ_ARRAY_PTR(dst_location.ulli_second));

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"obj_array_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"obj_array_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_obj_array_operator_binary_le_br_re_br(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   int result = 0;

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      switch(src_location.ui_first) {
      case c_value_type_CHAR:
	 result = (int)value_location_pool.get_char_value(src_location);
	 break;
      case c_value_type_SHORT:
	 result = (int)value_location_pool.get_short_value(src_location);
	 break;
      case c_value_type_INT:
	 result = value_location_pool.get_int_value(src_location);
	 break;
      default:
	 err_test2(0,c_R_ERR_EXPECTED_NUMBER_EXPRESSION,_this.get_line_number(a_thread_idx),(unsigned)"obj_array_s::operator_binary_le_br_re_br");
      }
   }
   else {
      assert(0);
   }

   ui_array_s *ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(dst_location.ulli_second);

   // - test if index fit in array size -
   err_test2((int)ui_array_ptr->used > result,c_R_ERR_IDX_EXCEED_ARRAY_STRING_SIZE,_this.get_line_number(a_thread_idx),(unsigned)"obj_array_s");

   // - insert of index of element location to stack -
   exp_stack.push(ui_array_ptr->data[result]);
}

void bic_obj_array_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.last()];
   value_location_pool.obj_array_print(IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second));
}

void bic_obj_array_function_length_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   int result = (int)IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second)->used;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_obj_array_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_OBJ_ARRAY,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_obj_array_function_push_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned src_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   // - retrieve of pointer to array -
   ui_array_s *ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(dst_location.ulli_second);

   // - creation of new element of array -
   unsigned value_location_idx = value_location_pool.copy_create_value(src_location_idx);
   ui_array_ptr->push(value_location_idx);

   // - retrieve of index of inserted element -
   int result = (int)ui_array_ptr->used - 1;

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_obj_array_function_pop_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];

   unsigned value_location_idx = IM_ACCESS_OBJ_ARRAY_PTR(location.ulli_second)->pop();

   // - popped element becomes temporary variable -
   value_location_s &value_location = value_location_pool[value_location_idx];
   value_location.uc_third |= c_value_modifier_TMP;

   tmp_variables_array.last().push(value_location_idx);
   exp_stack.push(value_location_idx);
}

void bic_obj_array_function_get_idx_1(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned src_location_idx = exp_stack.pop();
   value_location_s &dst_location = value_location_pool[exp_stack.pop()];

   ui_array_s *ui_array_ptr = IM_ACCESS_OBJ_ARRAY_PTR(dst_location.ulli_second);

   unsigned idx = c_idx_not_exist;

   if (ui_array_ptr->used != 0) {
      unsigned *ui_ptr = ui_array_ptr->data;
      unsigned *ui_ptr_end = ui_ptr + ui_array_ptr->used;

      do {
	 if (value_location_pool.compare_values(src_location_idx,*ui_ptr)) {
	    idx = ui_ptr - ui_array_ptr->data;
	    break;
	 }
      } while(++ui_ptr < ui_ptr_end);
   }
   
   // - creation of return value -
   unsigned idx_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)idx,c_value_modifier_TMP);
   tmp_variables_array.last().push(idx_location_idx);
   exp_stack.push(idx_location_idx);
}

void bic_obj_array_function_to_string_0(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"obj_array_s::function_to_string_0");
}

/*
 * functions of structure mutex_s
 */

void bic_mutex_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_mcs_pool_s &sp_mcs_pool = _this.sp_mcs_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"mutex_s::operator_binary_equal");

   sp_mcs_pool.mutex_remove(IM_ACCESS_MUTEX_SRC(dst_location.ulli_second));

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"mutex_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"mutex_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_mutex_function_lock_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   unsigned sp_mutex_idx;
   int result_value = c_mc_MUTEX_OK;

   {
      value_location_pool_s &value_location_pool = _this.value_location_pool;
      sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

      ui_array_s &exp_stack = sp_thread.exp_stack;

      // *****
      
      value_location_s &location = value_location_pool[exp_stack.pop()];
      sp_mutex_idx = IM_ACCESS_MUTEX_SRC(location.ulli_second);
   }

   do {

      sp_mcs_s &sp_mutex = _this.sp_mcs_pool[sp_mutex_idx];
      
      // - test if mutex is locked -
      if (sp_mutex.ui_first == 0) {
	 sp_mutex.ui_first = 1;
	 sp_mutex.ui_third = a_thread_idx;
	 break;
      }

      // - test on deadlock -
      if (sp_mutex.ui_third == a_thread_idx) {
	 result_value = c_mc_MUTEX_ERR_DEADLK;
	 break;
      }

      // - UNLOCK -
      _this.mutex.unlock();

      // - YIELD -
      pthread_yield();

      // - LOCK -
      _this.mutex.lock();

   } while(1);

   {
      value_location_pool_s &value_location_pool = _this.value_location_pool;
      sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

      ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
      ui_array_s &exp_stack = sp_thread.exp_stack;

      // *****

      // - creation of return value -
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }
}

void bic_mutex_function_trylock_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_mcs_pool_s &sp_mcs_pool = _this.sp_mcs_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];
   sp_mcs_s &sp_mutex = sp_mcs_pool[IM_ACCESS_MUTEX_SRC(location.ulli_second)];

   int result_value = c_mc_MUTEX_OK;

   // - test if mutex is locked -
   if (sp_mutex.ui_first == 0) {
      sp_mutex.ui_first = 1;
      sp_mutex.ui_third = a_thread_idx;
   }
   else {
      result_value = c_mc_MUTEX_ERR_BUSY;
   }

   // - creation of return value -
   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_mutex_function_unlock_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_mcs_pool_s &sp_mcs_pool = _this.sp_mcs_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &location = value_location_pool[exp_stack.pop()];
   sp_mcs_s &sp_mutex = sp_mcs_pool[IM_ACCESS_MUTEX_SRC(location.ulli_second)];

   int result_value = c_mc_MUTEX_OK;

   // - test if mutex is locked and is owned by this thread -
   
   if (sp_mutex.ui_third != a_thread_idx) {
      result_value = c_mc_MUTEX_ERR_PERM;
   }
   else {
      if (sp_mutex.ui_first == 0) {
	 result_value = c_mc_MUTEX_ERR_UNLOCKED;
      }
      else {
	 sp_mutex.ui_first = 0;
      }
   }

   // - creation of return value -
   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);
}

void bic_mutex_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_mcs_pool_s &sp_mcs_pool = _this.sp_mcs_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.last()];

   sp_mcs_s &sp_mutex = sp_mcs_pool[IM_ACCESS_MUTEX_SRC(location.ulli_second)];
   printf("mutex: %s",(sp_mutex.ui_first)?"locked":"unlocked");
}

void bic_mutex_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_MUTEX,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

void bic_condition_operator_binary_equal(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_mcs_pool_s &sp_mcs_pool = _this.sp_mcs_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   value_location_s &src_location = value_location_pool[exp_stack.pop()];
   value_location_s &dst_location = value_location_pool[exp_stack.last()];

   err_test2(dst_location.uc_third & c_value_modifier_WRITABLE,c_R_ERR_EXPECTED_WRITABLE,_this.get_line_number(a_thread_idx),(unsigned)"condition_s::operator_binary_equal");

   sp_mcs_pool.condition_remove(IM_ACCESS_COND_SRC(dst_location.ulli_second));

   if (src_location.ui_first < c_value_type_STRUCT_BASE) {
      if (src_location.ui_first < c_value_type_STRING) {
	 switch(src_location.ui_first) {
	 case c_value_type_CHAR:
	    dst_location.ui_first = c_value_type_CHAR;
	    IM_ACCESS_CHAR_TRG(dst_location.ulli_second) = value_location_pool.get_char_value(src_location);
	    break;
	 case c_value_type_SHORT:
	    dst_location.ui_first = c_value_type_SHORT;
	    IM_ACCESS_SHORT_TRG(dst_location.ulli_second) = value_location_pool.get_short_value(src_location);
	    break;
	 case c_value_type_INT:
	    dst_location.ui_first = c_value_type_INT;
	    IM_ACCESS_INT_TRG(dst_location.ulli_second) = value_location_pool.get_int_value(src_location);
	    break;
	 case c_value_type_DOUBLE:
	    dst_location.ui_first = c_value_type_DOUBLE;
	    IM_ACCESS_DOUBLE_TRG(dst_location.ulli_second) = value_location_pool.get_double_value(src_location);
	    break;
	 case c_value_type_COLOR:
	    dst_location.ui_first = c_value_type_COLOR;
	    IM_ACCESS_COLOR_TRG(dst_location.ulli_second) = *(long long unsigned *)value_location_pool.get_color_ptr(src_location);
	    break;
	 case c_value_type_THREAD:
	    dst_location.ui_first = c_value_type_THREAD;
	    IM_ACCESS_THREAD_TRG(dst_location.ulli_second) = IM_ACCESS_THREAD_SRC(src_location.ulli_second);
	    break;
	 default:
	    err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"condition_s::operator_binary_equal");
	 }
      }
      else {
	 if (src_location.uc_third & c_value_modifier_TMP) {
	    value_location_pool.tmp_value_shift(dst_location,src_location);
	 }
	 else {
	    switch (src_location.ui_first) {
	    case c_value_type_STRING:
	       value_location_pool.copy_string_value(dst_location,src_location);
	       break;
	    case c_value_type_LOCAL_IMG:
	       value_location_pool.copy_local_img_value(dst_location,src_location);
	       break;
	    case c_value_type_CHAR_ARRAY:
	       value_location_pool.copy_char_array_value(dst_location,src_location);
	       break;
	    case c_value_type_INT_ARRAY:
	       value_location_pool.copy_int_array_value(dst_location,src_location);
	       break;
	    case c_value_type_DOUBLE_ARRAY:
	       value_location_pool.copy_double_array_value(dst_location,src_location);
	       break;
	    case c_value_type_OBJ_ARRAY:
	       value_location_pool.copy_obj_array_value(dst_location,src_location);
	       break;
	    case c_value_type_MUTEX:
	       value_location_pool.copy_mutex_value(dst_location,src_location);
	       break;
	    case c_value_type_CONDITION:
	       value_location_pool.copy_condition_value(dst_location,src_location);
	       break;
	    default:
	       err_test3(0,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[src_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"condition_s::operator_binary_equal");
	    }
	 }
      }
   }
   else {
      if (src_location.uc_third & c_value_modifier_TMP) {
	 value_location_pool.tmp_value_shift(dst_location,src_location);
      }
      else {
	 value_location_pool.copy_struct_value(dst_location,src_location);
      }
   }
}

void bic_condition_function_wait_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   unsigned sp_condition_idx;
   int result_value = c_cc_CONDITION_OK;

   {
      value_location_pool_s &value_location_pool = _this.value_location_pool;
      sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

      ui_array_s &exp_stack = sp_thread.exp_stack;

      // *****
      
      // - acquire of condition index -
      value_location_s &location = value_location_pool[exp_stack.pop()];
      sp_condition_idx = IM_ACCESS_COND_SRC(location.ulli_second);

      // - increase waited signal count by one -
      sp_mcs_s &sp_condition = _this.sp_mcs_pool[sp_condition_idx];
      sp_condition.ui_first++;
   }

   do {
      sp_mcs_s &sp_condition = _this.sp_mcs_pool[sp_condition_idx];

      // - test of signal count in condition -
      if (sp_condition.ui_third != 0) {
	 sp_condition.ui_first--;
	 sp_condition.ui_third--;
	 break;
      }

      // - UNLOCK -
      _this.mutex.unlock();

      // - YIELD -
      pthread_yield();

      // - LOCK -
      _this.mutex.lock();

   } while(1);

   {
      value_location_pool_s &value_location_pool = _this.value_location_pool;
      sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

      ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
      ui_array_s &exp_stack = sp_thread.exp_stack;

      // *****

      // - creation of return value -
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }
}

void bic_condition_function_wait_1(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   int wait_cnt;
   unsigned sp_condition_idx;
   int result_value = c_cc_CONDITION_OK;

   {
      value_location_pool_s &value_location_pool = _this.value_location_pool;
      sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

      ui_array_s &exp_stack = sp_thread.exp_stack;

      // *****
      
      // - retrieve of count of signals to wait -
      value_location_s &wc_location = value_location_pool[exp_stack.pop()];
      
      err_test3(wc_location.ui_first == c_value_type_INT,c_R_ERR_WRONG_PARAMETER,_this.get_line_number(a_thread_idx),(unsigned)_this.symbol_names[_this.symbol_records[0].symbols_array[c_symbol_type_structure][_this.symbol_records[wc_location.ui_first].p_symbol_idx].ui_first].data,(unsigned)"condition_s::function_wait_1");

      wait_cnt = value_location_pool.get_int_value(wc_location);

      // - test of parameter -
      assert(wait_cnt >= 1);

      // - retrieve of condition index -
      value_location_s &location = value_location_pool[exp_stack.pop()];
      sp_condition_idx = IM_ACCESS_COND_SRC(location.ulli_second);

      // - increase count of waited signals by wait_cnt -
      sp_mcs_s &sp_condition = _this.sp_mcs_pool[sp_condition_idx];
      sp_condition.ui_first += wait_cnt;
   }

   do {
      sp_mcs_s &sp_condition = _this.sp_mcs_pool[sp_condition_idx];

      // - test of signals count in condition -
      if (sp_condition.ui_third != 0) {
	 
	 if (sp_condition.ui_third < (unsigned)wait_cnt) {
	    sp_condition.ui_first -= sp_condition.ui_third;
	    wait_cnt -= sp_condition.ui_third;
	    sp_condition.ui_third = 0;
	 }
	 else {
	    sp_condition.ui_first -= wait_cnt;
	    sp_condition.ui_third -= wait_cnt;
	    break;
	 }
      }

      // - UNLOCK -
      _this.mutex.unlock();

      // - YIELD -
      pthread_yield();

      // - LOCK -
      _this.mutex.lock();

   } while(1);

   {
      value_location_pool_s &value_location_pool = _this.value_location_pool;
      sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

      ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
      ui_array_s &exp_stack = sp_thread.exp_stack;

      // *****

      // - creation of return value -
      unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)result_value,c_value_modifier_TMP);
      tmp_variables_array.last().push(result_location_idx);
      exp_stack.push(result_location_idx);
   }
}

void bic_condition_function_timed_wait_1(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"condition_s::function_timed_wait_1");
}

void bic_condition_function_signal_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   // - retrieve of reference at condition -
   value_location_s &location = value_location_pool[exp_stack.pop()];
   sp_mcs_s &sp_condition = _this.sp_mcs_pool[IM_ACCESS_COND_SRC(location.ulli_second)];

   // - increase count of signals if waited on more than obtained -
   if (sp_condition.ui_first > sp_condition.ui_third) {
      sp_condition.ui_third++;
   }

   // - creation of return value -
   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_cc_CONDITION_OK,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);

   // - UNLOCK -
   _this.mutex.unlock();

   // - YIELD -
   pthread_yield();

   // - LOCK -
   _this.mutex.lock();
}

void bic_condition_function_signal_1(unsigned a_thread_idx,script_parser_s &_this)
{
   err_test2(0,c_DR_ERR_OPERATION_NOT_IMPLEMENTED,_this.get_line_number(a_thread_idx),(unsigned)"condition_s::function_signal_1");
}

void bic_condition_function_broadcast_0(unsigned a_thread_idx,script_parser_s &_this)
{
   // - test of enabling of multi threading -
   err_test1(_this.multiple_threads,c_R_ERR_NOT_ALLOWED_MULTITHREADING,_this.get_line_number(a_thread_idx));

   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   // - acquire of reference to condition -
   value_location_s &location = value_location_pool[exp_stack.pop()];
   sp_mcs_s &sp_condition = _this.sp_mcs_pool[IM_ACCESS_COND_SRC(location.ulli_second)];

   // - set count of signal at same number on which threads using condition wait -
   sp_condition.ui_third = sp_condition.ui_first;

   // - creation of return value -
   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_cc_CONDITION_OK,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.push(result_location_idx);

   // - UNLOCK -
   _this.mutex.unlock();

   // - YIELD -
   pthread_yield();

   // - LOCK -
   _this.mutex.lock();
}

void bic_condition_function_print_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_mcs_pool_s &sp_mcs_pool = _this.sp_mcs_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****
   
   value_location_s &location = value_location_pool[exp_stack.last()];

   sp_mcs_s &sp_condition = sp_mcs_pool[IM_ACCESS_COND_SRC(location.ulli_second)];
   printf("condition: waiting %d",sp_condition.ui_first);
}

void bic_condition_function_type_0(unsigned a_thread_idx,script_parser_s &_this)
{
   value_location_pool_s &value_location_pool = _this.value_location_pool;
   sp_thread_s &sp_thread = _this.sp_thread_pool[a_thread_idx];

   ui_arrays_s &tmp_variables_array = sp_thread.tmp_variables_array;
   ui_array_s &exp_stack = sp_thread.exp_stack;

   // *****

   unsigned result_location_idx = value_location_pool.insert(c_value_type_INT,(unsigned long long)c_tc_TYPE_CONDITION,c_value_modifier_TMP);
   tmp_variables_array.last().push(result_location_idx);
   exp_stack.last() = result_location_idx;
}

