
syn clear
syn case match

syn region     scriptChar start=/'/ skip=/\\'/ end=/'/ oneline
syn region     scriptString start=/"/ skip=/\\"/ end=/"/ oneline

"from c.vim syntax file
syn case ignore
syn match	scriptNumbers	display transparent "\<\d\|\.\d" contains=scriptNumber,scriptFloat,scriptOctalError,scriptOctal
syn match	scriptNumbersCom	display contained transparent "\<\d\|\.\d" contains=scriptNumber,scriptFloat,scriptOctal
syn match	scriptNumber		display contained "\d\+\(u\=l\{0,2}\|ll\=u\)\>"
syn match	scriptNumber		display contained "0x\x\+\(u\=l\{0,2}\|ll\=u\)\>"
syn match	scriptOctal		display contained "0\o\+\(u\=l\{0,2}\|ll\=u\)\>" contains=scriptOctalZero
syn match	scriptOctalZero	display contained "\<0"
syn match	scriptFloat		display contained "\d\+f"
syn match	scriptFloat		display contained "\d\+\.\d*\(e[-+]\=\d\+\)\=[fl]\="
syn match	scriptFloat		display contained "\.\d\+\(e[-+]\=\d\+\)\=[fl]\=\>"
syn match	scriptFloat		display contained "\d\+e[-+]\=\d\+[fl]\=\>"

" flag an octal number with wrong digits
syn match	cOctalError	display contained "0\o*[89]\d*"
syn case match

syn keyword    scriptTypes blank_s char_s short_s int_s double_s color_s thread_s string_s local_img_s char_array_s int_array_s double_array_s obj_array_s mutex_s condition_s

syn keyword    scriptOperators operator_binary_equal operator_binary_plus_equal operator_binary_minus_equal operator_binary_asterisk_equal operator_binary_slash_equal operator_binary_percent_equal operator_binary_double_ls_br_equal operator_binary_double_rs_br_equal operator_binary_ampersand_equal operator_binary_pipe_equal operator_binary_circumflex_equal operator_binary_double_ampersand operator_binary_double_pipe operator_binary_ampersand operator_binary_pipe operator_binary_circumflex operator_binary_double_equal operator_binary_exclamation_equal operator_binary_rs_br operator_binary_ls_br operator_binary_rs_br_equal operator_binary_ls_br_equal operator_binary_double_rs_br operator_binary_double_ls_br operator_binary_plus operator_binary_minus operator_binary_asterisk operator_binary_slash operator_binary_percent operator_unary_post_double_plus operator_unary_post_double_minus operator_unary_pre_double_plus operator_unary_pre_double_minus operator_unary_pre_plus operator_unary_pre_minus operator_unary_pre_exclamation operator_unary_pre_tilde operator_binary_le_br_re_br

syn keyword    scriptStatement if else do while break continue return new this thread
syn keyword    scriptStructure fun struct
syn keyword    scriptArray char int double array

syn keyword    scriptConstant SYSTEM_THREADS TYPE_BLANK TYPE_CHAR TYPE_SHORT TYPE_INT TYPE_DOUBLE TYPE_COLOR TYPE_THREAD TYPE_STRING TYPE_LOCAL_IMG TYPE_CHAR_ARRAY TYPE_INT_ARRAY TYPE_DOUBLE_ARRAY TYPE_OBJ_ARRAY TYPE_MUTEX TYPE_CONDITION THREAD_OK THREAD_ERR_SEARCH THREAD_ERR_INVAL THREAD_ERR_DEADLK MUTEX_ERR_DEADLK MUTEX_ERR_PERM MUTEX_ERR_UNLOCKED MUTEX_ERR_BUSY CONDITION_ERR_TIMEDOUT CONDITION_ERR_UNKNOWN 

syn match      scriptComment	 display /\#.*/
syn match      scriptComment	 display /\/\/.*/
syn region     scriptComment start=/\/\*/ end=/\*\//

hi def link    scriptTypes Type
hi def link    scriptOperators Special

hi def link    scriptChar String
hi def link    scriptString String

"from c.vim syntax file
hi def link scriptNumber Number
hi def link scriptOctal Number
hi def link scriptOctalZero PreProc
hi def link scriptFloat Float
hi def link scriptOctalError scriptError

hi def link    scriptStatement Statement
hi def link    scriptStructure Structure
hi def link    scriptArray Type

hi def link    scriptConstant Constant
hi def link    scriptComment Comment

